/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.ConnectionLimitingFactory;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.LocatedFileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.core.fs.UnsupportedSchemeFactory;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.fs.local.LocalFileSystemFactory;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystem.class);
    private static final ReentrantLock OUTPUT_DIRECTORY_INIT_LOCK = new ReentrantLock(true);
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static final HashMap<FSKey, FileSystem> CACHE = new HashMap();
    private static final List<FileSystemFactory> RAW_FACTORIES = FileSystem.loadFileSystems();
    private static final HashMap<String, FileSystemFactory> FS_FACTORIES = new HashMap();
    private static final FileSystemFactory FALLBACK_FACTORY = FileSystem.loadHadoopFsFactory();
    private static URI DEFAULT_SCHEME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Configuration config) throws IOException, IllegalConfigurationException {
        block7: {
            LOCK.lock();
            try {
                CACHE.clear();
                FS_FACTORIES.clear();
                for (FileSystemFactory factory : RAW_FACTORIES) {
                    factory.configure(config);
                    String scheme = factory.getScheme();
                    FileSystemFactory fsf = ConnectionLimitingFactory.decorateIfLimited(factory, scheme, config);
                    FS_FACTORIES.put(scheme, fsf);
                }
                FALLBACK_FACTORY.configure(config);
                String stringifiedUri = config.getString(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, null);
                if (stringifiedUri == null) {
                    DEFAULT_SCHEME = null;
                    break block7;
                }
                try {
                    DEFAULT_SCHEME = new URI(stringifiedUri);
                }
                catch (URISyntaxException e2) {
                    throw new IllegalConfigurationException("The default file system scheme ('" + CoreOptions.DEFAULT_FILESYSTEM_SCHEME + "') is invalid: " + stringifiedUri, e2);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static FileSystem getLocalFileSystem() {
        return FileSystemSafetyNet.wrapWithSafetyNetWhenActivated(LocalFileSystem.getSharedInstance());
    }

    public static FileSystem get(URI uri) throws IOException {
        return FileSystemSafetyNet.wrapWithSafetyNetWhenActivated(FileSystem.getUnguardedFileSystem(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static FileSystem getUnguardedFileSystem(URI fsUri) throws IOException {
        Preconditions.checkNotNull(fsUri, "file system URI");
        LOCK.lock();
        try {
            FileSystem fs;
            FileSystemFactory factory;
            URI uri;
            if (fsUri.getScheme() != null) {
                uri = fsUri;
            } else {
                URI rewrittenUri;
                URI defaultUri;
                block19: {
                    defaultUri = FileSystem.getDefaultFsUri();
                    rewrittenUri = null;
                    try {
                        rewrittenUri = new URI(defaultUri.getScheme(), null, defaultUri.getHost(), defaultUri.getPort(), fsUri.getPath(), null, null);
                    }
                    catch (URISyntaxException e2) {
                        if (!defaultUri.getScheme().equals("file")) break block19;
                        try {
                            rewrittenUri = new URI("file", null, new Path(new File(fsUri.getPath()).getAbsolutePath()).toUri().getPath(), null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                }
                if (rewrittenUri != null) {
                    uri = rewrittenUri;
                } else {
                    throw new IOException("The file system URI '" + fsUri + "' declares no scheme and cannot be interpreted relative to the default file system URI (" + defaultUri + ").");
                }
            }
            if (uri.getScheme().equals("file") && uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
                String supposedUri = "file:///" + uri.getAuthority() + uri.getPath();
                throw new IOException("Found local file path with authority '" + uri.getAuthority() + "' in path '" + uri.toString() + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
            }
            FSKey key = new FSKey(uri.getScheme(), uri.getAuthority(), uri.getQuery());
            FileSystem cached = CACHE.get(key);
            if (cached != null) {
                FileSystem e2 = cached;
                return e2;
            }
            if (FS_FACTORIES.isEmpty()) {
                FileSystem.initialize(new Configuration());
            }
            if ((factory = FS_FACTORIES.get(uri.getScheme())) != null) {
                fs = factory.create(uri);
            } else {
                try {
                    fs = FALLBACK_FACTORY.create(uri);
                }
                catch (UnsupportedFileSystemSchemeException e3) {
                    throw new UnsupportedFileSystemSchemeException("Could not find a file system implementation for scheme '" + uri.getScheme() + "'. The scheme is not directly supported by Flink and no Hadoop file system to support this scheme could be loaded.", e3);
                }
            }
            CACHE.put(key, fs);
            FileSystem fileSystem = fs;
            return fileSystem;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static URI getDefaultFsUri() {
        return DEFAULT_SCHEME != null ? DEFAULT_SCHEME : LocalFileSystem.getLocalFsURI();
    }

    public abstract Path getWorkingDirectory();

    public abstract Path getHomeDirectory();

    public abstract URI getUri();

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public abstract BlockLocation[] getFileBlockLocations(FileStatus var1, long var2, long var4) throws IOException;

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public abstract FSDataInputStream open(Path var1) throws IOException;

    @Deprecated
    public long getDefaultBlockSize() {
        return 0x2000000L;
    }

    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    public LocatedFileStatus[] listLocatedStatus(Path f) throws IOException {
        FileStatus[] fileStatuses = this.listStatus(f);
        if (fileStatuses == null) {
            return null;
        }
        LocatedFileStatus[] result = new LocatedFileStatus[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            result[i] = new DefaultLocatedFileStatus(fileStatuses[i], this.getFileBlockLocations(fileStatuses[i], 0L, fileStatuses[i].getLen()));
        }
        return result;
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e2) {
            return false;
        }
    }

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    public abstract boolean mkdirs(Path var1) throws IOException;

    @Deprecated
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite ? WriteMode.OVERWRITE : WriteMode.NO_OVERWRITE);
    }

    @Deprecated
    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite ? WriteMode.OVERWRITE : WriteMode.NO_OVERWRITE);
    }

    public abstract FSDataOutputStream create(Path var1, WriteMode var2) throws IOException;

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract boolean isDistributedFS();

    public abstract FileSystemKind getKind();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean initOutPathLocalFS(Path outPath, WriteMode writeMode, boolean createDirectory) throws IOException {
        if (this.isDistributedFS()) {
            return false;
        }
        try {
            OUTPUT_DIRECTORY_INIT_LOCK.lockInterruptibly();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new IOException("The thread was interrupted while trying to initialize the output directory");
        }
        try {
            FileStatus status;
            try {
                status = this.getFileStatus(outPath);
            }
            catch (FileNotFoundException e3) {
                status = null;
            }
            if (status != null) {
                switch (writeMode) {
                    case NO_OVERWRITE: {
                        if (status.isDir() && createDirectory) {
                            boolean e3 = true;
                            return e3;
                        }
                        throw new IOException("File or directory " + outPath + " already exists. Existing files and directories are not overwritten in " + WriteMode.NO_OVERWRITE.name() + " mode. Use " + WriteMode.OVERWRITE.name() + " mode to overwrite existing files and directories.");
                    }
                    case OVERWRITE: {
                        if (status.isDir()) {
                            if (createDirectory) {
                                boolean e3 = true;
                                return e3;
                            }
                            try {
                                this.delete(outPath, true);
                                break;
                            }
                            catch (IOException e4) {
                                throw new IOException("Could not remove existing directory '" + outPath + "' to allow overwrite by result file", e4);
                            }
                        }
                        try {
                            this.delete(outPath, false);
                            break;
                        }
                        catch (IOException e5) {
                            throw new IOException("Could not remove existing file '" + outPath + "' to allow overwrite by result file/directory", e5);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid write mode: " + (Object)((Object)writeMode));
                    }
                }
            }
            if (createDirectory) {
                if (!this.exists(outPath)) {
                    this.mkdirs(outPath);
                }
                try {
                    boolean e5 = this.getFileStatus(outPath).isDir();
                    return e5;
                }
                catch (FileNotFoundException e6) {
                    boolean bl = false;
                    OUTPUT_DIRECTORY_INIT_LOCK.unlock();
                    return bl;
                }
            }
            boolean bl = !this.exists(outPath);
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            OUTPUT_DIRECTORY_INIT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initOutPathDistFS(Path outPath, WriteMode writeMode, boolean createDirectory) throws IOException {
        if (!this.isDistributedFS()) {
            return false;
        }
        try {
            OUTPUT_DIRECTORY_INIT_LOCK.lockInterruptibly();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new IOException("The thread was interrupted while trying to initialize the output directory");
        }
        try {
            if (this.exists(outPath)) {
                switch (writeMode) {
                    case NO_OVERWRITE: {
                        throw new IOException("File or directory already exists. Existing files and directories are not overwritten in " + WriteMode.NO_OVERWRITE.name() + " mode. Use " + WriteMode.OVERWRITE.name() + " mode to overwrite existing files and directories.");
                    }
                    case OVERWRITE: {
                        try {
                            this.delete(outPath, true);
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid write mode: " + (Object)((Object)writeMode));
                    }
                }
            }
            if (createDirectory) {
                try {
                    if (!this.exists(outPath)) {
                        this.mkdirs(outPath);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean bl = this.exists(outPath) && this.getFileStatus(outPath).isDir();
                return bl;
            }
            boolean bl = !this.exists(outPath);
            return bl;
        }
        finally {
            OUTPUT_DIRECTORY_INIT_LOCK.unlock();
        }
    }

    private static List<FileSystemFactory> loadFileSystems() {
        ArrayList<FileSystemFactory> list = new ArrayList<FileSystemFactory>();
        list.add(new LocalFileSystemFactory());
        LOG.debug("Loading extension file systems via services");
        try {
            ServiceLoader<FileSystemFactory> serviceLoader = ServiceLoader.load(FileSystemFactory.class);
            Iterator<FileSystemFactory> iter = serviceLoader.iterator();
            while (iter.hasNext()) {
                try {
                    FileSystemFactory factory = iter.next();
                    list.add(factory);
                    LOG.debug("Added file system {}:{}", (Object)factory.getScheme(), (Object)factory.getClass().getName());
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalErrorOrOOM(t);
                    LOG.error("Failed to load a file system via services", t);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalErrorOrOOM(t);
            LOG.error("Failed to load additional file systems via services", t);
        }
        return Collections.unmodifiableList(list);
    }

    private static FileSystemFactory loadHadoopFsFactory() {
        Class<FileSystemFactory> factoryClass;
        ClassLoader cl = FileSystem.class.getClassLoader();
        try {
            factoryClass = Class.forName("org.apache.flink.runtime.fs.hdfs.HadoopFsFactory", false, cl).asSubclass(FileSystemFactory.class);
        }
        catch (ClassNotFoundException e2) {
            LOG.info("No Flink runtime dependency present. The extended set of supported File Systems via Hadoop is not available.");
            return new UnsupportedSchemeFactory("Flink runtime classes missing in classpath/dependencies.");
        }
        catch (Exception | LinkageError e3) {
            LOG.warn("Flink's Hadoop file system factory could not be loaded", e3);
            return new UnsupportedSchemeFactory("Flink's Hadoop file system factory could not be loaded", e3);
        }
        try {
            Class.forName("org.apache.hadoop.conf.Configuration", false, cl);
            Class.forName("org.apache.hadoop.fs.FileSystem", false, cl);
        }
        catch (ClassNotFoundException e4) {
            LOG.info("Hadoop is not in the classpath/dependencies. The extended set of supported File Systems via Hadoop is not available.");
            return new UnsupportedSchemeFactory("Hadoop is not in the classpath/dependencies.");
        }
        try {
            return factoryClass.newInstance();
        }
        catch (Exception | LinkageError e5) {
            LOG.warn("Flink's Hadoop file system factory could not be created", e5);
            return new UnsupportedSchemeFactory("Flink's Hadoop file system factory could not be created", e5);
        }
    }

    private static final class FSKey {
        private final String scheme;
        @Nullable
        private final String authority;
        @Nullable
        private final String query;

        public FSKey(String scheme, @Nullable String authority, @Nullable String query) {
            this.scheme = Preconditions.checkNotNull(scheme, "scheme");
            this.authority = authority;
            this.query = query;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == FSKey.class) {
                FSKey that = (FSKey)obj;
                return this.scheme.equals(that.scheme) && (this.authority == null ? that.authority == null : that.authority != null && this.authority.equals(that.authority)) && (this.query == null ? that.query == null : that.query != null && this.query.equals(that.query));
            }
            return false;
        }

        public int hashCode() {
            return 961 * this.scheme.hashCode() + 31 * (this.authority == null ? 0 : this.authority.hashCode()) + (this.query == null ? 0 : this.query.hashCode());
        }

        public String toString() {
            return this.scheme + "://" + (this.authority != null ? this.authority : "") + "?" + this.query;
        }
    }

    static class DefaultLocatedFileStatus
    implements LocatedFileStatus {
        FileStatus fileStatus;
        BlockLocation[] locations;

        public DefaultLocatedFileStatus(FileStatus fileStatus, BlockLocation[] blockLocations) {
            this.fileStatus = fileStatus;
            this.locations = blockLocations;
        }

        @Override
        public BlockLocation[] getBlockLocation() {
            return this.locations;
        }

        @Override
        public long getLen() {
            return this.fileStatus.getLen();
        }

        @Override
        public long getBlockSize() {
            return this.fileStatus.getBlockSize();
        }

        @Override
        public short getReplication() {
            return this.fileStatus.getReplication();
        }

        @Override
        public long getModificationTime() {
            return this.fileStatus.getModificationTime();
        }

        @Override
        public long getAccessTime() {
            return this.fileStatus.getAccessTime();
        }

        @Override
        public boolean isDir() {
            return this.fileStatus.isDir();
        }

        @Override
        public Path getPath() {
            return this.fileStatus.getPath();
        }
    }

    public static enum WriteMode {
        NO_OVERWRITE,
        OVERWRITE;

    }
}

