/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class ByteArrayInputStreamWithPos
extends InputStream {
    protected byte[] buffer;
    protected int position;
    protected int count;
    protected int mark = 0;

    public ByteArrayInputStreamWithPos(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayInputStreamWithPos(byte[] buffer, int offset, int length) {
        this.position = offset;
        this.buffer = buffer;
        this.mark = offset;
        this.count = Math.min(buffer.length, offset + length);
    }

    @Override
    public int read() {
        return this.position < this.count ? 0xFF & this.buffer[this.position++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        Preconditions.checkNotNull(b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.count) {
            return -1;
        }
        int available = this.count - this.position;
        if (len > available) {
            len = available;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public long skip(long toSkip) {
        long remain = this.count - this.position;
        if (toSkip < remain) {
            remain = toSkip < 0L ? 0L : toSkip;
        }
        this.position = (int)((long)this.position + remain);
        return remain;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    @Override
    public int available() {
        return this.count - this.position;
    }

    @Override
    public void close() throws IOException {
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pos) {
        Preconditions.checkArgument(pos >= 0 && pos <= this.count, "Position out of bounds.");
        this.position = pos;
    }
}

