/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.functions;

import java.io.IOException;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.streaming.data.PythonSingleInputStreamer;
import org.apache.flink.util.Collector;

public class PythonMapPartition<IN, OUT>
extends RichMapPartitionFunction<IN, OUT>
implements ResultTypeQueryable<OUT> {
    private static final long serialVersionUID = 3866306483023916413L;
    private final PythonSingleInputStreamer<IN, OUT> streamer;
    private final transient TypeInformation<OUT> typeInformation;

    public PythonMapPartition(Configuration config, int envId, int setId, TypeInformation<OUT> typeInformation) {
        this.typeInformation = typeInformation;
        this.streamer = new PythonSingleInputStreamer(this, config, envId, setId, typeInformation instanceof PrimitiveArrayTypeInfo);
    }

    @Override
    public void open(Configuration config) throws IOException {
        this.streamer.open();
        this.streamer.sendBroadCastVariables(config);
    }

    @Override
    public void mapPartition(Iterable<IN> values, Collector<OUT> out) throws Exception {
        this.streamer.streamBufferWithoutGroups(values.iterator(), out);
    }

    @Override
    public void close() throws IOException {
        this.streamer.close();
    }

    @Override
    public TypeInformation<OUT> getProducedType() {
        return this.typeInformation;
    }
}

