/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.UnsortedGrouping;

public class SetCache {
    private final Map<Integer, SetType> setTypes = new HashMap<Integer, SetType>();
    private final Map<Integer, DataSet> dataSets = new HashMap<Integer, DataSet>();
    private final Map<Integer, UnsortedGrouping> unsortedGroupings = new HashMap<Integer, UnsortedGrouping>();
    private final Map<Integer, SortedGrouping> sortedGroupings = new HashMap<Integer, SortedGrouping>();
    private int cachedID = -1;
    private SetType cachedType = null;

    public <D extends DataSet<?>> void add(int id, D set) {
        this.cacheSetType(id, SetType.DATA_SET);
        this.dataSets.put(id, set);
    }

    public <U extends UnsortedGrouping<?>> void add(int id, U set) {
        this.cacheSetType(id, SetType.UNSORTED_GROUPING);
        this.unsortedGroupings.put(id, set);
    }

    public <S extends SortedGrouping<?>> void add(int id, S set) {
        this.cacheSetType(id, SetType.SORTED_GROUPING);
        this.sortedGroupings.put(id, set);
    }

    private <T> void cacheSetType(int id, SetType type) {
        SetType prior = this.setTypes.put(id, type);
        if (prior != null) {
            throw new IllegalStateException("Set ID " + id + " used to denote multiple sets.");
        }
    }

    public boolean isDataSet(int id) {
        return this.isType(id, SetType.DATA_SET);
    }

    public boolean isUnsortedGrouping(int id) {
        return this.isType(id, SetType.UNSORTED_GROUPING);
    }

    public boolean isSortedGrouping(int id) {
        return this.isType(id, SetType.SORTED_GROUPING);
    }

    private boolean isType(int id, SetType type) {
        if (this.cachedID != id) {
            this.cachedID = id;
            this.cachedType = this.setTypes.get(id);
            if (this.cachedType == null) {
                throw new IllegalStateException("No set exists for the given ID " + id);
            }
        }
        return this.cachedType == type;
    }

    public <T> DataSet<T> getDataSet(int id) {
        return this.verifyType(id, this.dataSets.get(id), SetType.DATA_SET);
    }

    public <T> UnsortedGrouping<T> getUnsortedGrouping(int id) {
        return this.verifyType(id, this.unsortedGroupings.get(id), SetType.UNSORTED_GROUPING);
    }

    public <T> SortedGrouping<T> getSortedGrouping(int id) {
        return this.verifyType(id, this.sortedGroupings.get(id), SetType.SORTED_GROUPING);
    }

    private <X> X verifyType(int id, X set, SetType type) {
        if (set == null) {
            SetType actualType = this.setTypes.get(id);
            throw new IllegalStateException("Set ID " + id + " did not denote a " + (Object)((Object)type) + ", but a " + (Object)((Object)actualType) + " instead.");
        }
        return set;
    }

    public void reset() {
        this.setTypes.clear();
        this.dataSets.clear();
        this.unsortedGroupings.clear();
        this.sortedGroupings.clear();
    }

    private static enum SetType {
        DATA_SET(DataSet.class.getName()),
        UNSORTED_GROUPING(UnsortedGrouping.class.getName()),
        SORTED_GROUPING(SortedGrouping.class.getName());

        private final String className;

        private SetType(String className) {
            this.className = className;
        }

        public String toString() {
            return this.className;
        }
    }
}

