/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.reflections.scanners;

import org.apache.flink.shaded.org.reflections.scanners.AbstractScanner;
import org.apache.flink.shaded.org.reflections.util.FilterBuilder;

public class SubTypesScanner
extends AbstractScanner {
    public SubTypesScanner() {
        this(true);
    }

    public SubTypesScanner(boolean excludeObjectClass) {
        if (excludeObjectClass) {
            this.filterResultsBy(new FilterBuilder().exclude(Object.class.getName()));
        }
    }

    public void scan(Object cls) {
        String className = this.getMetadataAdapter().getClassName(cls);
        String superclass = this.getMetadataAdapter().getSuperclassName(cls);
        if (this.acceptResult(superclass)) {
            this.getStore().put(superclass, className);
        }
        for (String anInterface : this.getMetadataAdapter().getInterfacesNames(cls)) {
            if (!this.acceptResult(anInterface)) continue;
            this.getStore().put(anInterface, className);
        }
    }
}

