/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAddPartition
extends SqlAlterTable {
    private List<SqlNodeList> newPartitionSpecList;
    private List<SqlNode> newPartitionLocationList;
    private Boolean newPartitionIfNotExists;
    private final List<SqlNodeList> newPartitionPropList;

    public SqlAddPartition(SqlParserPos pos, SqlIdentifier tableName, List<SqlNodeList> newPartitionSpecList, List<SqlNode> newPartitionLocationList, Boolean newPartitionIfNotExists, List<SqlNodeList> newPartitionPropList) {
        super(pos, tableName);
        this.newPartitionSpecList = newPartitionSpecList;
        this.newPartitionLocationList = newPartitionLocationList;
        this.operandKind = SqlAlterTable.AlterKind.ADD_PARTITION;
        this.newPartitionIfNotExists = newPartitionIfNotExists;
        this.newPartitionPropList = newPartitionPropList;
    }

    public List<SqlNodeList> getNewPartitionSpecList() {
        return this.newPartitionSpecList;
    }

    public List<SqlNode> getNewPartitionLocationList() {
        return this.newPartitionLocationList;
    }

    public Boolean getNewPartitionIfNotExists() {
        return this.newPartitionIfNotExists;
    }

    public List<SqlNodeList> getNewPartitionPropList() {
        return this.newPartitionPropList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("ADD");
        if (this.newPartitionIfNotExists.booleanValue()) {
            writer.keyword("IF NOT EXISTS");
        }
        for (int i = 0; i < this.newPartitionSpecList.size(); ++i) {
            SqlNodeList properties;
            writer.keyword("PARTITION");
            SqlWriter.Frame frame = writer.startList("(", ")");
            SqlNodeList partitionSpec = this.newPartitionSpecList.get(i);
            partitionSpec.unparse(writer, leftPrec, rightPrec);
            writer.endList(frame);
            SqlNode location = this.newPartitionLocationList.get(i);
            if (null != location) {
                writer.keyword("LOCATION");
                location.unparse(writer, leftPrec, rightPrec);
            }
            if ((properties = this.newPartitionPropList.get(i)) == null) continue;
            writer.newlineAndIndent();
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : properties) {
                writer.sep(",", false);
                writer.newlineAndIndent();
                writer.print("  ");
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }
}

