/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlAnalyzeTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ANALYZE TABLE", SqlKind.OTHER_DDL);
    private SqlIdentifier tableName;
    private SqlNodeList columnList;
    private boolean withColumns;

    public SqlAnalyzeTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, boolean withColumns) {
        super(pos);
        this.tableName = Objects.requireNonNull(tableName, "Table name is missing");
        this.columnList = Objects.requireNonNull(columnList, "Column list should not be null");
        this.withColumns = withColumns;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public void setColumnList(SqlNodeList columnList) {
        this.columnList = columnList;
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public void setTableName(SqlIdentifier tableName) {
        this.tableName = tableName;
    }

    public boolean isWithColumns() {
        return this.withColumns;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE");
        writer.keyword("TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("COMPUTE");
        writer.keyword("STATISTICS");
        if (this.withColumns) {
            writer.keyword("FOR");
            writer.keyword("COLUMNS");
            if (!SqlNodeList.isEmptyList(this.columnList)) {
                int columnMaxIndex = this.columnList.size() - 1;
                SqlWriter.Frame columnsFrame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
                for (int idx = 0; idx <= columnMaxIndex; ++idx) {
                    SqlNode column = this.columnList.get(idx);
                    column.unparse(writer, leftPrec, rightPrec);
                    if (idx == columnMaxIndex) continue;
                    writer.sep(",", false);
                }
                writer.endList(columnsFrame);
            }
        }
    }

    public void validate() {
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }
}

