/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

public enum SqlColumnType {
    BOOLEAN,
    TINYINT,
    SMALLINT,
    INT,
    BIGINT,
    FLOAT,
    DOUBLE,
    DECIMAL,
    DATE,
    TIME,
    TIMESTAMP,
    VARCHAR,
    VARBINARY,
    ANY,
    ARRAY,
    MAP,
    ROW,
    UNSUPPORTED;


    public static SqlColumnType getType(String type) {
        String lowerCaseType;
        if (type == null) {
            return UNSUPPORTED;
        }
        switch (lowerCaseType = type.toLowerCase()) {
            case "boolean": {
                return BOOLEAN;
            }
            case "tinyint": {
                return TINYINT;
            }
            case "smallint": {
                return SMALLINT;
            }
            case "int": 
            case "integer": {
                return INT;
            }
            case "bigint": {
                return BIGINT;
            }
            case "real": 
            case "float": {
                return FLOAT;
            }
            case "decimal": {
                return DECIMAL;
            }
            case "double": {
                return DOUBLE;
            }
            case "date": {
                return DATE;
            }
            case "time": {
                return TIME;
            }
            case "timestamp": {
                return TIMESTAMP;
            }
            case "varchar": {
                return VARCHAR;
            }
            case "varbinary": {
                return VARBINARY;
            }
            case "any": {
                return ANY;
            }
            case "array": {
                return ARRAY;
            }
            case "map": {
                return MAP;
            }
            case "row": {
                return ROW;
            }
        }
        return UNSUPPORTED;
    }
}

