/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class SqlCreateDatabase
extends SqlCall {
    private final SqlIdentifier databaseName;
    private final SqlNodeList propertyList;
    private final SqlCharStringLiteral comment;
    private final boolean ifNotExists;

    public SqlCreateDatabase(SqlParserPos position, SqlIdentifier databaseName, SqlNodeList propertyList, SqlCharStringLiteral comment, boolean ifNotExists) {
        super(position);
        this.databaseName = databaseName;
        this.propertyList = propertyList;
        this.comment = comment;
        this.ifNotExists = ifNotExists;
    }

    public SqlIdentifier getDatabaseName() {
        return this.databaseName;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlCharStringLiteral getComment() {
        return this.comment;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public SqlOperator getOperator() {
        return null;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("DATABASE");
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        if (this.comment != null) {
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
            writer.newlineAndIndent();
        }
        if (this.propertyList != null) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                writer.sep(",", false);
                writer.newlineAndIndent();
                writer.print("  ");
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    public String[] fullDatabaseName() {
        return this.databaseName.names.toArray(new String[0]);
    }
}

