/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlProperty;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.Pair;
import org.apache.flink.sql.parser.ddl.SqlColumnType;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.plan.SqlParseException;

public class SqlCreateTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_TABLE", SqlKind.CREATE_TABLE);
    private String tableType;
    private SqlIdentifier tableName;
    private SqlNodeList columnList;
    private SqlNodeList propertyList;
    private SqlNodeList primaryKeyList;
    private List<SqlNodeList> uniqueKeysList;
    private List<IndexWrapper> indexKeysList;
    private SqlWatermark watermark;
    private SqlNodeList partitionKeysList;
    private SqlCharStringLiteral comment;

    public SqlCreateTable(SqlParserPos pos, String tableType, SqlIdentifier tableName, SqlNodeList columnList, SqlNodeList primaryKeyList, List<SqlNodeList> uniqueKeysList, List<IndexWrapper> indexKeysList, SqlWatermark watermark, SqlNodeList propertyList, SqlNodeList partitionKeysList, SqlCharStringLiteral comment) {
        super(pos);
        this.tableType = tableType;
        this.tableName = Objects.requireNonNull(tableName, "Table name is missing");
        this.columnList = Objects.requireNonNull(columnList, "Column list should not be null");
        this.primaryKeyList = primaryKeyList;
        this.uniqueKeysList = uniqueKeysList;
        this.indexKeysList = indexKeysList;
        this.watermark = watermark;
        this.propertyList = propertyList;
        this.partitionKeysList = partitionKeysList;
        this.comment = comment;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public void setTableName(SqlIdentifier tableName) {
        this.tableName = tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public void setColumnList(SqlNodeList columnList) {
        this.columnList = columnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(SqlNodeList propertyList) {
        this.propertyList = propertyList;
    }

    public SqlNodeList getPartitionKeysList() {
        return this.partitionKeysList;
    }

    public void setPartitionKeysList(SqlNodeList partitionKeysList) {
        this.partitionKeysList = partitionKeysList;
    }

    public SqlNodeList getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    public void setPrimaryKeyList(SqlNodeList primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
    }

    public List<SqlNodeList> getUniqueKeysList() {
        return this.uniqueKeysList;
    }

    public void setUniqueKeysList(List<SqlNodeList> uniqueKeysList) {
        this.uniqueKeysList = uniqueKeysList;
    }

    public List<IndexWrapper> getIndexKeysList() {
        return this.indexKeysList;
    }

    public void setIndexKeysList(List<IndexWrapper> indexKeysList) {
        this.indexKeysList = indexKeysList;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public SqlCharStringLiteral getComment() {
        return this.comment;
    }

    public void setComment(SqlCharStringLiteral comment) {
        this.comment = comment;
    }

    public void validate() throws SqlParseException {
        HashSet<String> columnNames = new HashSet<String>();
        if (this.columnList != null) {
            for (SqlNode column : this.columnList) {
                SqlCall tableColumn;
                String columnName = null;
                if (column instanceof SqlTableColumn) {
                    tableColumn = (SqlTableColumn)column;
                    columnName = ((SqlTableColumn)tableColumn).getName().getSimple();
                    String typeName = ((SqlTableColumn)tableColumn).getType().getTypeName().getSimple();
                    if (SqlColumnType.getType(typeName) == null) {
                        throw new SqlParseException(column.getParserPosition(), "Not support type [" + typeName + "], at " + column.getParserPosition());
                    }
                } else if (column instanceof SqlBasicCall) {
                    tableColumn = (SqlBasicCall)column;
                    columnName = ((SqlBasicCall)tableColumn).getOperands()[1].toString();
                }
                if (columnNames.add(columnName)) continue;
                throw new SqlParseException(column.getParserPosition(), "Duplicate column name [" + columnName + "], at " + column.getParserPosition());
            }
        }
        if (this.primaryKeyList != null) {
            for (SqlNode primaryKeyNode : this.primaryKeyList) {
                String primaryKey = ((SqlIdentifier)primaryKeyNode).getSimple();
                if (columnNames.contains(primaryKey)) continue;
                throw new SqlParseException(primaryKeyNode.getParserPosition(), "Primary key [" + primaryKey + "] not defined in columns, at " + primaryKeyNode.getParserPosition());
            }
        }
        if (this.uniqueKeysList != null) {
            for (SqlNodeList uniqueKeys : this.uniqueKeysList) {
                for (SqlNode uniqueKeyNode : uniqueKeys) {
                    String uniqueKey = ((SqlIdentifier)uniqueKeyNode).getSimple();
                    if (columnNames.contains(uniqueKey)) continue;
                    throw new SqlParseException(uniqueKeyNode.getParserPosition(), "Unique key [" + uniqueKey + "] not defined in columns, at " + uniqueKeyNode.getParserPosition());
                }
            }
        }
        if (this.indexKeysList != null) {
            for (IndexWrapper index : this.indexKeysList) {
                for (SqlNode indexKeyNode : index.indexKeys) {
                    String indexKey = ((SqlIdentifier)indexKeyNode).getSimple();
                    if (columnNames.contains(indexKey)) continue;
                    throw new SqlParseException(indexKeyNode.getParserPosition(), "IndexWrapper column [" + indexKey + "] not defined in columns, at " + indexKeyNode.getParserPosition());
                }
            }
        }
        if (this.partitionKeysList != null) {
            for (SqlNode partitionKeyNode : this.partitionKeysList.getList()) {
                String partitionKey = ((SqlIdentifier)partitionKeyNode).getSimple();
                if (columnNames.contains(partitionKey)) continue;
                throw new SqlParseException(partitionKeyNode.getParserPosition(), "Partition column [" + partitionKey + "] not defined in columns, at " + partitionKeyNode.getParserPosition());
            }
        }
        if (this.propertyList != null) {
            HashSet<String> propertyKeys = new HashSet<String>();
            for (SqlNode propertyNode : this.propertyList.getList()) {
                String propertyKey = ((SqlProperty)propertyNode).getKey().getSimple();
                if (propertyKeys.add(propertyKey)) continue;
                throw new SqlParseException(propertyNode.getParserPosition(), "Duplicate property key[" + propertyKey + "] at " + propertyNode.getParserPosition());
            }
        }
    }

    public boolean containsComputedColumn() {
        for (SqlNode column : this.columnList) {
            if (!(column instanceof SqlBasicCall)) continue;
            return true;
        }
        return false;
    }

    public String getColumnSqlString() {
        SqlPrettyWriter writer = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        writer.setAlwaysUseParentheses(true);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        writer.startList("", "");
        for (SqlNode column : this.columnList) {
            writer.sep(",");
            if (column instanceof SqlTableColumn) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                tableColumn.getName().unparse(writer, 0, 0);
                continue;
            }
            column.unparse(writer, 0, 0);
        }
        return writer.toString();
    }

    public void getComputedColumnsStringsPair(List<Pair<String, String>> container) {
        for (SqlNode column : this.columnList) {
            if (!(column instanceof SqlBasicCall) || column.getKind() != SqlKind.AS) continue;
            SqlBasicCall call = (SqlBasicCall)column;
            SqlPrettyWriter writer = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
            writer.setAlwaysUseParentheses(false);
            writer.setIndentation(0);
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            String v = writer.toString();
            writer = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
            writer.setAlwaysUseParentheses(false);
            writer.setIndentation(0);
            ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
            String k = writer.toString();
            container.add(Pair.of(k, v));
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame withFrame;
        SqlWriter.Frame keyFrame;
        writer.keyword("CREATE TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : this.columnList) {
            this.printIndent(writer);
            if (column instanceof SqlBasicCall) {
                SqlCall call = (SqlCall)column;
                SqlCall newCall = call.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(1), call.operand(0)});
                newCall.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            column.unparse(writer, leftPrec, rightPrec);
        }
        if (this.primaryKeyList != null && this.primaryKeyList.size() > 0) {
            this.printIndent(writer);
            writer.keyword("PRIMARY KEY");
            SqlWriter.Frame keyFrame2 = writer.startList("(", ")");
            this.primaryKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(keyFrame2);
        }
        if (this.uniqueKeysList != null && this.uniqueKeysList.size() > 0) {
            this.printIndent(writer);
            for (SqlNodeList uniqueKeyList : this.uniqueKeysList) {
                writer.keyword("UNIQUE");
                keyFrame = writer.startList("(", ")");
                uniqueKeyList.unparse(writer, leftPrec, rightPrec);
                writer.endList(keyFrame);
            }
        }
        if (this.indexKeysList != null && this.indexKeysList.size() > 0) {
            for (IndexWrapper index : this.indexKeysList) {
                this.printIndent(writer);
                if (index.unique) {
                    writer.keyword("UNIQUE");
                }
                writer.keyword("INDEX");
                keyFrame = writer.startList("(", ")");
                index.indexKeys.unparse(writer, leftPrec, rightPrec);
                writer.endList(keyFrame);
            }
        }
        if (this.watermark != null) {
            this.printIndent(writer);
            this.watermark.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
        if (this.partitionKeysList != null) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            withFrame = writer.startList("(", ")");
            this.partitionKeysList.unparse(writer, leftPrec, rightPrec);
            writer.endList(withFrame);
            writer.newlineAndIndent();
        }
        if (this.comment != null) {
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
            writer.newlineAndIndent();
        }
        if (this.propertyList != null) {
            writer.keyword("WITH");
            withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public SqlWatermark getWatermark() {
        return this.watermark;
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }

    public static class IndexWrapper {
        public boolean unique;
        public SqlNodeList indexKeys;

        public IndexWrapper(boolean unique, SqlNodeList indexKeys) {
            this.unique = unique;
            this.indexKeys = indexKeys;
        }
    }

    public static class TableTempWrapper {
        public List<SqlNode> columnList = new ArrayList<SqlNode>();
        public SqlNodeList primaryKeyList;
        public List<SqlNodeList> uniqueKeysList = new ArrayList<SqlNodeList>();
        public List<IndexWrapper> indexKeysList = new ArrayList<IndexWrapper>();
        public SqlWatermark watermark;
        public String tableType;
    }
}

