/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.sql.parser.plan.SqlParseException;

public class SqlCreateView
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_VIEW", SqlKind.CREATE_VIEW){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlCreateView(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], operands[2], (SqlLiteral)operands[3], (SqlNodeList)operands[4]);
        }
    };
    private SqlIdentifier viewName;
    private SqlNodeList fieldList;
    private SqlNode query;
    private boolean replaceView;
    private String subQuerySql;
    private final SqlNodeList propertyList;

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, SqlLiteral replaceView, SqlNodeList propertyList) {
        this(pos, viewName, fieldList, query, replaceView.booleanValue(), propertyList);
    }

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, boolean replaceView, SqlNodeList propertyList) {
        super(pos);
        this.viewName = viewName;
        this.query = query;
        this.replaceView = replaceView;
        this.fieldList = fieldList;
        this.propertyList = propertyList;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add(this.viewName);
        ops.add(this.fieldList);
        ops.add(this.query);
        ops.add(SqlLiteral.createBoolean(this.replaceView, SqlParserPos.ZERO));
        return ops;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.replaceView) {
            writer.keyword("OR");
            writer.keyword("REPLACE");
        }
        writer.keyword("VIEW");
        this.viewName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList.size() > 0) {
            writer.keyword("(");
            this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
            for (int i = 1; i < this.fieldList.size(); ++i) {
                writer.keyword(",");
                this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
        if (this.propertyList != null) {
            writer.newlineAndIndent();
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                writer.sep(",", false);
                writer.newlineAndIndent();
                writer.print("  ");
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
            writer.newlineAndIndent();
        }
        writer.keyword("AS");
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    public List<String> getSchemaPath() {
        if (this.viewName.isSimple()) {
            return ImmutableList.of();
        }
        return this.viewName.names.subList(0, this.viewName.names.size() - 1);
    }

    public String getName() {
        if (this.viewName.isSimple()) {
            return this.viewName.getSimple();
        }
        return (String)this.viewName.names.get(this.viewName.names.size() - 1);
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            fieldNames.add(node.toString());
        }
        return fieldNames;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public boolean getReplace() {
        return this.replaceView;
    }

    public String getSubQuerySql() {
        return this.subQuerySql;
    }

    public void setSubQuerySql(String subQuerySql) {
        this.subQuerySql = subQuerySql;
    }

    public void validate() throws SqlParseException {
        if (this.fieldList.size() > 0) {
            HashSet<String> columnAlias = new HashSet<String>();
            for (SqlNode column : this.fieldList.getList()) {
                String columnName = null;
                if (!(column instanceof SqlIdentifier)) {
                    throw new SqlParseException(column.getParserPosition(), "Unsupported columns [" + column + "]. The optional column_list clause only accept a list of comma-separated identifiers." + column);
                }
                columnName = ((SqlIdentifier)column).getSimple();
                if (columnAlias.add(columnName)) continue;
                throw new SqlParseException(column.getParserPosition(), "Duplicate alias name [" + columnName + "], at " + column.getParserPosition());
            }
        }
    }

    public String[] fullViewName() {
        return this.viewName.names.toArray(new String[0]);
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }
}

