/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlDropPartition
extends SqlAlterTable {
    private List<SqlNodeList> dropPartitionSpecList;
    private Boolean dropPartitionIfExists;

    public SqlDropPartition(SqlParserPos pos, SqlIdentifier tableName, List<SqlNodeList> dropPartitionSpecList, Boolean dropPartitionIfExists) {
        super(pos, tableName);
        this.dropPartitionSpecList = dropPartitionSpecList;
        this.operandKind = SqlAlterTable.AlterKind.DROP_PARTITION;
        this.dropPartitionIfExists = dropPartitionIfExists;
    }

    public List<SqlNodeList> getDropPartitionSpecList() {
        return this.dropPartitionSpecList;
    }

    public Boolean getDropPartitionIfExists() {
        return this.dropPartitionIfExists;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("DROP");
        if (this.dropPartitionIfExists.booleanValue()) {
            writer.keyword("IF EXISTS");
        }
        for (int i = 0; i < this.dropPartitionSpecList.size(); ++i) {
            writer.keyword("PARTITION");
            SqlWriter.Frame frame = writer.startList("(", ")");
            SqlNodeList partitionSpec = this.dropPartitionSpecList.get(i);
            partitionSpec.unparse(writer, leftPrec, rightPrec);
            writer.endList(frame);
        }
    }
}

