/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlHiddenColumn
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("HIDDEN_COLUMN", SqlKind.OTHER);
    private SqlIdentifier name;
    private String type;
    private boolean hidden;

    public SqlHiddenColumn(SqlParserPos pos, SqlNode name, String type, boolean hidden) {
        super(pos);
        this.name = (SqlIdentifier)Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.hidden = hidden;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name);
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public void setName(SqlIdentifier name) {
        this.name = name;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        writer.print(this.type + "()");
        if (this.hidden) {
            writer.keyword("HIDDEN");
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }
}

