/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlRenamePartition
extends SqlAlterTable {
    private SqlNodeList partitionSpec;
    private SqlNodeList newPartitionSpec;

    public SqlRenamePartition(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partitionSpec, SqlNodeList newPartitionSpec) {
        super(pos, tableName);
        this.partitionSpec = partitionSpec;
        this.newPartitionSpec = newPartitionSpec;
        this.operandKind = SqlAlterTable.AlterKind.RENAME_PARTITION;
    }

    public SqlNodeList getPartitionSpec() {
        return this.partitionSpec;
    }

    public SqlNodeList getNewPartitionSpec() {
        return this.newPartitionSpec;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("PARTITION");
        SqlWriter.Frame frame = writer.startList("(", ")");
        this.partitionSpec.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
        writer.keyword("RENAME TO PARTITION ");
        frame = writer.startList("(", ")");
        this.newPartitionSpec.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }
}

