/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDescribeTable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlRichDescribeTable
extends SqlDescribeTable {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE_TABLE", SqlKind.DESCRIBE_TABLE);
    private boolean isExtended;
    private boolean isFormatted;
    private SqlIdentifier table;
    private SqlIdentifier column;

    public SqlRichDescribeTable(SqlParserPos pos, SqlIdentifier table, SqlIdentifier column, boolean isExtended, boolean isFormatted) {
        super(pos, table, column);
        this.table = table;
        this.column = column;
        this.isExtended = isExtended;
        this.isFormatted = isFormatted;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE");
        if (this.isExtended) {
            writer.keyword("EXTENDED");
        }
        if (this.isFormatted) {
            writer.keyword("FORMATTED");
        }
        writer.keyword("TABLE");
        this.table.unparse(writer, leftPrec, rightPrec);
        if (this.column != null) {
            this.column.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public SqlIdentifier getTable() {
        return this.table;
    }

    @Override
    public SqlIdentifier getColumn() {
        return this.column;
    }

    public boolean getIsExtended() {
        return this.isExtended;
    }

    public boolean getIsFormatted() {
        return this.isFormatted;
    }

    public String[] fullTableName() {
        return this.table.names.toArray(new String[0]);
    }
}

