/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlSetTableProps
extends SqlAlterTable {
    private SqlNodeList propertyList;

    public SqlSetTableProps(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyList) {
        super(pos, tableName);
        this.propertyList = propertyList;
        this.operandKind = SqlAlterTable.AlterKind.SET_TBLPROPERTIES;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode property : this.propertyList) {
            writer.sep(",");
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }
}

