/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlTableColumn
extends SqlCall {
    private SqlIdentifier name;
    private SqlDataTypeSpec type;
    private SqlCharStringLiteral comment;
    private boolean isHeader = false;

    public SqlTableColumn(SqlIdentifier name, SqlDataTypeSpec type, SqlCharStringLiteral comment, SqlParserPos pos) {
        super(pos);
        this.name = Objects.requireNonNull(name, "Column name should not be null");
        this.type = Objects.requireNonNull(type, "Column type should not be null");
        this.comment = comment;
    }

    @Override
    public SqlOperator getOperator() {
        return null;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.print(" ");
        this.type.unparse(writer, leftPrec, rightPrec);
        if (this.isHeader) {
            writer.keyword("HEADER");
        }
        if (this.comment != null) {
            writer.print(" COMMENT ");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean header) {
        this.isHeader = header;
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public void setName(SqlIdentifier name) {
        this.name = name;
    }

    public SqlDataTypeSpec getType() {
        return this.type;
    }

    public void setType(SqlDataTypeSpec type) {
        this.type = type;
    }

    public SqlCharStringLiteral getComment() {
        return this.comment;
    }

    public void setComment(SqlCharStringLiteral comment) {
        this.comment = comment;
    }
}

