/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.plan.SqlParseException;

public class SqlWatermark
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("WATERMARK", SqlKind.OTHER);
    private static final String WITH_OFFSET_FUNC = "withOffset";
    private SqlIdentifier watermarkName;
    private SqlIdentifier columnName;
    private SqlCall functionCall;

    public SqlWatermark(SqlIdentifier watermarkName, SqlIdentifier columnName, SqlNode functionCall, SqlParserPos pos) {
        super(pos);
        this.watermarkName = watermarkName;
        this.columnName = Objects.requireNonNull(columnName, "Column name is missing in watermark clause");
        this.functionCall = Objects.requireNonNull((SqlCall)functionCall, "Function call is missing in watermark, clause");
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.watermarkName, this.columnName, this.functionCall);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("WATERMARK");
        if (this.watermarkName != null) {
            this.watermarkName.unparse(writer, leftPrec, rightPrec);
        }
        writer.keyword("FOR");
        this.columnName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        this.functionCall.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    public SqlIdentifier getWatermarkName() {
        return this.watermarkName;
    }

    public SqlIdentifier getColumnName() {
        return this.columnName;
    }

    public SqlCall getFunctionCall() {
        return this.functionCall;
    }

    public long getWatermarkOffset() throws SqlParseException {
        SqlOperator wmOp = this.functionCall.getOperator();
        String funcName = wmOp.getName();
        if (WITH_OFFSET_FUNC.equalsIgnoreCase(funcName)) {
            List<SqlNode> operands = this.functionCall.getOperandList();
            if (operands.size() != 2) {
                throw new SqlParseException(this.functionCall.getParserPosition(), "Watermark function 'withOffset(<rowtime_field>, <offset>)' only accept two arguments.");
            }
            String timeField = operands.get(0).toString();
            String rowtimeField = this.getColumnName().toString();
            if (!rowtimeField.equals(timeField)) {
                throw new SqlParseException(operands.get(0).getParserPosition(), "The first argument of 'withOffset' must be the rowtime field.");
            }
            String offsetStr = operands.get(1).toString();
            long offset = -1L;
            try {
                offset = Long.valueOf(offsetStr);
            }
            catch (NumberFormatException e2) {
                throw new SqlParseException(operands.get(1).getParserPosition(), "The second argument of 'withOffset' must be an integer, but is " + offsetStr, e2);
            }
            return offset;
        }
        throw new SqlParseException(this.functionCall.getParserPosition(), "Unsupported Watermark Function '" + funcName + "'");
    }
}

