/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dml;

import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlInsertOverwrite
extends SqlInsert {
    private final SqlNode table;
    private final SqlNodeList partitionSpecs;

    public SqlInsertOverwrite(SqlParserPos pos, SqlNode table, SqlNodeList partitionSpecs, SqlNode source) {
        super(pos, new SqlNodeList(pos), table, source, partitionSpecs, null, null);
        this.table = table;
        this.partitionSpecs = partitionSpecs;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("INSERT OVERWRITE");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.table.unparse(writer, opLeft, opRight);
        writer.newlineAndIndent();
        if (this.partitionSpecs != null && this.partitionSpecs.size() > 0) {
            writer.keyword("PARTITION");
            this.partitionSpecs.unparse(writer, opLeft, opRight);
            writer.newlineAndIndent();
        }
        this.getSource().unparse(writer, 0, 0);
    }
}

