/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.errorcode;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorFactory {
    protected static Pattern pattern1 = Pattern.compile("[0-9]{8}");
    protected static Set<String> modNames = new HashSet<String>();

    private ErrorFactory() {
    }

    public static Object createProxy(Class clazz) {
        Class<?>[] classArray;
        ClassLoader classLoader = clazz.getClassLoader();
        if (clazz.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        } else {
            classArray = clazz.getInterfaces();
        }
        return Proxy.newProxyInstance(classLoader, classArray, (obj, method, args) -> {
            ErrorFactory.checkParam(method, args);
            return ErrorFactory.assemblyErrCodeString(method, args);
        });
    }

    protected static void checkParam(Method method, Object[] args) {
        ErrCode errCode = method.getAnnotation(ErrCode.class);
        String errDetail = errCode.details();
        String errCause = errCode.cause();
        MessageFormat format1 = new MessageFormat(errDetail);
        MessageFormat format2 = new MessageFormat(errCause);
        if (args == null || args.length == 0 ? format1.getFormatsByArgumentIndex() != null && format1.getFormatsByArgumentIndex().length > 0 || format2.getFormatsByArgumentIndex() != null && format2.getFormatsByArgumentIndex().length > 0 : format1.getFormatsByArgumentIndex() != null && format1.getFormatsByArgumentIndex().length > args.length || format1.getFormatsByArgumentIndex() == null || format2.getFormatsByArgumentIndex() != null && format2.getFormatsByArgumentIndex().length > args.length) {
            throw new AssertionError((Object)("mismatched parameter length between " + method.getName() + " and its annotation @ErrCode"));
        }
    }

    protected static String assemblyErrCodeString(Method method, Object[] args) {
        ErrCode errCode = method.getAnnotation(ErrCode.class);
        String errId = errCode.codeId();
        String errCause = errCode.cause();
        String errDetail = errCode.details();
        String errAction = errCode.action();
        if (args != null && args.length != 0) {
            MessageFormat format1 = new MessageFormat(errDetail);
            errDetail = format1.format(args);
            MessageFormat format2 = new MessageFormat(errCause);
            errCause = format2.format(args);
        }
        errId = ErrorFactory.prettyPrint(errId);
        errCause = ErrorFactory.prettyPrint(errCause);
        errDetail = ErrorFactory.prettyPrint(errDetail);
        errAction = ErrorFactory.prettyPrint(errAction);
        String msg = "\n************\nERR_ID:\n" + errId + "\nCAUSE:\n" + errCause + "\nACTION:\n" + errAction + "\nDETAIL:\n" + errDetail + "\n************";
        return msg;
    }

    public static String prettyPrint(String str) {
        if (str != null && str.length() != 0) {
            str = ErrorFactory.indent(5) + str.replaceAll("\n", "\n" + ErrorFactory.indent(5));
        }
        return str;
    }

    public static void validate(Class<?> clazz) {
        ErrorFactory.validate(clazz, EnumSet.allOf(ValidationType.class));
    }

    public static void validate(Class<?> clazz, EnumSet<ValidationType> validations) {
        int cnt = 0;
        HashSet<String> errIds = new HashSet<String>();
        for (Method method : clazz.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            ++cnt;
            ErrCode anno1 = method.getAnnotation(ErrCode.class);
            block6: for (ValidationType validation : validations) {
                switch (validation) {
                    case ANNOTATION_SPECIFIED: {
                        if (anno1 == null || StringUtils.isEmpty((CharSequence)anno1.codeId()) || StringUtils.isEmpty((CharSequence)anno1.cause())) {
                            throw new AssertionError((Object)String.format("error code method[%s] must specify @ErrCode annotation with cause, details and none-empty codeId!", method.getName()));
                        }
                        break;
                    }
                    case ERROR_ID_CHECK: {
                        if (anno1 == null) {
                            throw new AssertionError((Object)String.format("error code method[%s]has no @ErrId annotation!", method.getName()));
                        }
                        String errId = anno1.codeId();
                        if (!ErrorFactory.checkErrorCodeFmt(errId)) {
                            throw new AssertionError((Object)String.format("error code method[%s]has invalid error code: %s", method.getName(), errId));
                        }
                        if (errIds.contains(errId)) {
                            throw new AssertionError((Object)String.format("error code method[%s]has duplicated err id: %s", method.getName(), errId));
                        }
                        errIds.add(errId);
                        break;
                    }
                    case ARGUMENT_MATCH: {
                        if (anno1 == null) {
                            throw new AssertionError((Object)String.format("error code method[%s]has no @ErrCode annotation!", method.getName()));
                        }
                        String msg = anno1.details();
                        String cause = anno1.cause();
                        MessageFormat msgFmt = new MessageFormat(msg);
                        MessageFormat causeFmt = new MessageFormat(cause);
                        Format[] msgFormats = msgFmt.getFormatsByArgumentIndex();
                        Format[] causeFormats = causeFmt.getFormatsByArgumentIndex();
                        Format[] formats = msgFormats.length != 0 ? msgFormats : causeFormats;
                        ArrayList<Class<Date>> types = new ArrayList<Class<Date>>();
                        Class<?>[] paramTypes = method.getParameterTypes();
                        if (msgFormats.length != 0 && causeFormats.length != 0) break;
                        for (int i = 0; i < formats.length; ++i) {
                            Format fmt1 = formats[i];
                            Class<?> paramType = paramTypes[i];
                            Class e2 = fmt1 instanceof NumberFormat ? (paramType == Short.TYPE || paramType == Integer.TYPE || paramType == Long.TYPE || paramType == Float.TYPE || paramType == Double.TYPE || Number.class.isAssignableFrom(paramType) ? paramType : Number.class) : (fmt1 instanceof DateFormat ? Date.class : String.class);
                            types.add(e2);
                        }
                        List<Class<?>> paramTypeList = Arrays.asList(paramTypes);
                        if (!types.equals(paramTypeList)) {
                            throw new AssertionError((Object)String.format("error code[%s] has type mismatch(s) between method param %s and format elements %s in annotation", method.getName(), types, paramTypeList));
                        }
                        continue block6;
                    }
                }
            }
        }
        if (cnt == 0 && validations.contains((Object)ValidationType.AT_LEAST_ONE)) {
            throw new AssertionError((Object)(clazz + " contains no error code"));
        }
    }

    protected static boolean checkErrorCodeFmt(String errId) {
        if (errId == null || errId.isEmpty()) {
            return false;
        }
        String[] parts = errId.split("-");
        if (parts.length != 2) {
            return false;
        }
        if (!modNames.contains(parts[0])) {
            return false;
        }
        return pattern1.matcher(parts[1]).matches();
    }

    public static String indent(int cnt) {
        if (cnt <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    static {
        modNames.add("SQL");
        modNames.add("PAR");
        modNames.add("CON");
        modNames.add("STB");
        modNames.add("RUN");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ErrCode {
        public String codeId();

        public String cause();

        public String details();

        public String action();
    }

    public static enum ValidationType {
        ANNOTATION_SPECIFIED,
        AT_LEAST_ONE,
        ERROR_ID_CHECK,
        ARGUMENT_MATCH;

    }
}

