/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.node.SqlTreeJSONGenerator;
import org.apache.flink.sql.parser.node.SqlTreeNode;
import org.apache.flink.sql.parser.node.SqlTreeNodes;
import org.apache.flink.sql.parser.plan.FlinkSqlValidator;

public class SqlToTreeConverter {
    private final Map<String, SqlTreeNode> context = new HashMap<String, SqlTreeNode>();
    private final List<SqlTreeNode> nodes = new ArrayList<SqlTreeNode>();
    private final FlinkSqlValidator validator;

    public SqlToTreeConverter(FlinkSqlValidator validator) {
        this.validator = validator;
    }

    public void convertSql(SqlNode query) {
        SqlTreeNode node = this.convertQueryRecursive(query);
        if (node != null) {
            this.nodes.add(node);
        }
    }

    public String getJSON() {
        SqlTreeJSONGenerator generator = new SqlTreeJSONGenerator();
        return generator.getJSON(this.nodes);
    }

    public List<SqlTreeNode> getNodes() {
        return this.nodes;
    }

    private SqlTreeNode convertQueryRecursive(SqlNode query) {
        SqlKind kind = query.getKind();
        switch (kind) {
            case SELECT: {
                return this.convertSelect((SqlSelect)query);
            }
            case INSERT: {
                return this.convertInsert((SqlInsert)query);
            }
            case CREATE_VIEW: {
                return this.convertView((SqlCreateView)query);
            }
            case CREATE_TABLE: {
                return null;
            }
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                return this.convertSetOp((SqlCall)query);
            }
            case OTHER_DDL: {
                return null;
            }
        }
        throw new AssertionError((Object)("not a query: " + query));
    }

    private SqlTreeNode convertView(SqlCreateView view) {
        String viewName = view.getName();
        SqlTreeNode input = this.convertQueryRecursive(view.getQuery());
        this.context.put(viewName, input);
        return input;
    }

    private SqlTreeNode convertInsert(SqlInsert insert) {
        SqlTreeNode input = this.convertQueryRecursive(insert.getSource());
        String tableName = insert.getTargetTable().toString();
        return SqlTreeNodes.sink(insert.getParserPosition(), input, tableName);
    }

    private SqlTreeNode convertSelect(SqlSelect query) {
        SqlTreeNode input = this.convertFrom(query.getFrom());
        SqlTreeNode filter = this.convertWhere(input, query.getWhere());
        if (filter != null) {
            input = filter;
        }
        if (this.validator.isAggregate(query)) {
            SqlNodeList groupList = query.getGroup();
            if (groupList != null) {
                input = SqlTreeNodes.group(groupList.getParserPosition(), input, groupList);
            } else {
                SqlNode agg = this.validator.getAggregate(query);
                Objects.requireNonNull(agg, "Can not find aggregate from query: " + query);
                input = SqlTreeNodes.group(agg.getParserPosition(), input);
            }
        } else {
            SqlNodeList selectList = query.getSelectList();
            input = SqlTreeNodes.select(query.getParserPosition(), input, selectList);
        }
        return this.convertOrder(query, input);
    }

    private SqlTreeNode convertSetOp(SqlCall call) {
        SqlTreeNode left = this.convertQueryRecursive((SqlNode)call.operand(0));
        SqlTreeNode right = this.convertQueryRecursive((SqlNode)call.operand(1));
        switch (call.getKind()) {
            case UNION: {
                return SqlTreeNodes.union(call.getParserPosition(), ImmutableList.of(left, right));
            }
            case INTERSECT: {
                throw Util.unexpected(call.getKind());
            }
            case EXCEPT: {
                throw Util.unexpected(call.getKind());
            }
        }
        throw Util.unexpected(call.getKind());
    }

    private SqlTreeNode convertOrder(SqlSelect select2, SqlTreeNode input) {
        SqlNodeList orderBy = select2.getOrderList();
        if (orderBy == null || orderBy.getList().isEmpty()) {
            return input;
        }
        return SqlTreeNodes.topn(orderBy.getParserPosition(), input, "");
    }

    private SqlTreeNode convertWhere(SqlTreeNode input, SqlNode where) {
        if (where == null) {
            return null;
        }
        return SqlTreeNodes.filter(where.getParserPosition(), input, where);
    }

    private SqlTreeNode convertFrom(SqlNode from) {
        switch (from.getKind()) {
            case IDENTIFIER: {
                String tableName = from.toString();
                return this.context.getOrDefault(tableName, SqlTreeNodes.source(((SqlIdentifier)from).getParserPosition(), tableName));
            }
            case AS: {
                return this.convertFrom((SqlNode)((SqlCall)from).operand(0));
            }
            case MATCH_RECOGNIZE: {
                return this.convertMatchRecognize((SqlCall)from);
            }
            case SNAPSHOT: {
                return this.convertTemporal((SqlSnapshot)from);
            }
            case JOIN: {
                return this.convertJoin((SqlJoin)from);
            }
            case SELECT: 
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                return this.convertQueryRecursive(from);
            }
            case LATERAL: {
                SqlCall call = (SqlCall)from;
                return this.convertFrom(call.getOperandList().get(0));
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)from;
                return SqlTreeNodes.udtf(from.getParserPosition(), call.getOperandList().get(0));
            }
            case VALUES: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)("Not supported operator " + from));
    }

    private SqlTreeNode convertJoin(SqlJoin join) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlTreeNode leftNode = this.convertFrom(left);
        SqlTreeNode rightNode = this.convertFrom(right);
        if (rightNode instanceof SqlTreeNodes.SqlTableFunctionNode) {
            return SqlTreeNodes.correlate(join.getParserPosition(), leftNode, rightNode.explain());
        }
        JoinType joinType = join.getJoinType();
        return SqlTreeNodes.join(join.getParserPosition(), leftNode, rightNode, joinType);
    }

    private SqlTreeNode convertTemporal(SqlSnapshot call) {
        String tableName = call.getTableRef().toString();
        return SqlTreeNodes.snapshot(call.getParserPosition(), this.context.getOrDefault(tableName, SqlTreeNodes.dim(call.getParserPosition(), tableName)));
    }

    private SqlTreeNode convertMatchRecognize(SqlCall call) {
        SqlMatchRecognize matchRecognize = (SqlMatchRecognize)call;
        SqlNode tableRef = matchRecognize.getTableRef();
        SqlTreeNode input = this.convertFrom(tableRef);
        SqlNode pattern = matchRecognize.getPattern();
        return SqlTreeNodes.cep(call.getParserPosition(), input, pattern);
    }
}

