/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.node;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.sql.parser.node.SqlTreeNode;

public class SqlTreeJSONGenerator {
    private int idCounter = 1;
    private Map<SqlTreeNode, Node> nodeMap = new HashMap<SqlTreeNode, Node>();
    private List<Link> links = new ArrayList<Link>();

    public String getJSON(List<SqlTreeNode> treeNodes) {
        for (SqlTreeNode treeNode : treeNodes) {
            this.createNodes(treeNode);
        }
        ArrayList<Node> nodes = Lists.newArrayList(this.nodeMap.values());
        nodes.sort(new NodeComparator());
        Plan plan = new Plan(nodes, this.links);
        return plan.toString();
    }

    private Node createNodes(SqlTreeNode treeNode) {
        Node node = this.nodeMap.get(treeNode);
        if (node == null) {
            node = Node.of(this.idCounter++, treeNode);
            this.nodeMap.put(treeNode, node);
            for (SqlTreeNode input : treeNode.getInputs()) {
                Node inputNode = this.createNodes(input);
                this.links.add(Link.of(inputNode, node));
            }
        }
        return node;
    }

    private static String toJson(Object value) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        catch (JsonProcessingException e2) {
            throw new AssertionError((Object)("Writing a valid object as JSON string should not fail: " + e2.getMessage()));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class Link {
        @JsonProperty(value="source")
        private int source;
        @JsonProperty(value="target")
        private int target;

        public Link() {
        }

        Link(int source, int target) {
            this.source = source;
            this.target = target;
        }

        private static Link of(Node source, Node target) {
            return new Link(source.id, target.id);
        }

        public String toString() {
            return SqlTreeJSONGenerator.toJson(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class Position {
        @JsonProperty(value="line")
        private int line;
        @JsonProperty(value="column")
        private int column;

        public Position() {
        }

        public Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public String toString() {
            return SqlTreeJSONGenerator.toJson(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class Node {
        @JsonProperty(value="id")
        private int id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="pos")
        private Position pos;

        public Node() {
        }

        Node(int id, String type, String name, Position pos) {
            this.id = id;
            this.type = type;
            this.name = name;
            this.pos = pos;
        }

        private static Node of(int idCounter, SqlTreeNode treeNode) {
            return new Node(idCounter, treeNode.getNodeType().toString(), treeNode.explain(), new Position(treeNode.getParserPosition().getLineNum(), treeNode.getParserPosition().getColumnNum()));
        }

        public String toString() {
            return SqlTreeJSONGenerator.toJson(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class Plan {
        @JsonProperty(value="nodes")
        private List<Node> nodes;
        @JsonProperty(value="links")
        private List<Link> links;

        public Plan() {
        }

        Plan(List<Node> nodes, List<Link> links) {
            this.nodes = nodes;
            this.links = links;
        }

        public String toString() {
            return SqlTreeJSONGenerator.toJson(this);
        }
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            return node1.id - node2.id;
        }
    }
}

