/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.node.SqlNodeType;
import org.apache.flink.sql.parser.node.SqlTreeNode;

public class SqlTreeNodes {
    private static final SqlDialect DUMMY = SqlDialect.DatabaseProduct.DB2.getDialect();

    public static SqlTreeNode source(SqlParserPos pos, String tableName) {
        return new SqlTableSourceNode(pos, SqlNodeType.SOURCE, tableName);
    }

    public static SqlTreeNode sink(SqlParserPos pos, SqlTreeNode input, String tableName) {
        return new SqlTableSinkNode(pos, input, tableName);
    }

    public static SqlTreeNode dim(SqlParserPos pos, String tableName) {
        return new SqlTableSourceNode(pos, SqlNodeType.DIM, tableName);
    }

    public static SqlTreeNode select(SqlParserPos pos, SqlTreeNode input, SqlNode selection) {
        return new SqlSelectNode(pos, input, SqlTreeNodes.toSqlString(selection));
    }

    public static SqlTreeNode filter(SqlParserPos pos, SqlTreeNode input, SqlNode condition) {
        return new SqlFilterNode(pos, input, SqlTreeNodes.toSqlString(condition));
    }

    public static SqlTreeNode group(SqlParserPos pos, SqlTreeNode input, SqlNode groupKeys) {
        return new SqlGroupNode(pos, input, SqlTreeNodes.toSqlString(groupKeys));
    }

    public static SqlTreeNode join(SqlParserPos pos, SqlTreeNode left, SqlTreeNode right, JoinType joinType) {
        return new SqlJoinNode(pos, left, right, joinType);
    }

    public static SqlTreeNode group(SqlParserPos pos, SqlTreeNode input) {
        return new SqlGroupNode(pos, input, "");
    }

    public static SqlTreeNode union(SqlParserPos pos, List<SqlTreeNode> nodes) {
        ArrayList<SqlTreeNode> children = new ArrayList<SqlTreeNode>();
        for (SqlTreeNode node : nodes) {
            if (node instanceof SqlUnionNode) {
                children.addAll(node.getInputs());
                continue;
            }
            children.add(node);
        }
        return new SqlUnionNode(pos, children);
    }

    public static SqlTreeNode topn(SqlParserPos pos, SqlTreeNode input, String desc) {
        return new SqlTopnNode(pos, input, desc);
    }

    public static SqlTreeNode udtf(SqlParserPos pos, SqlNode tf) {
        return new SqlTableFunctionNode(pos, SqlTreeNodes.toSqlString(tf));
    }

    public static SqlTreeNode correlate(SqlParserPos pos, SqlTreeNode input, String desc) {
        return new SqlCorrelateNode(pos, input, desc);
    }

    public static SqlTreeNode cep(SqlParserPos pos, SqlTreeNode input, SqlNode pattern) {
        return new SqlCepNode(pos, input, SqlTreeNodes.toSqlString(pattern));
    }

    public static SqlTreeNode snapshot(SqlParserPos pos, SqlTreeNode input) {
        return new SqlSnapshotNode(pos, input);
    }

    protected static String toSqlString(SqlNode node) {
        return node.toSqlString(DUMMY).toString();
    }

    public static class SqlCepNode
    extends SingleSqlTreeNode {
        SqlCepNode(SqlParserPos pos, SqlTreeNode input, String desc) {
            super(pos, SqlNodeType.CEP, input, desc);
        }
    }

    public static class SqlUnionNode
    extends AbstractSqlTreeNode {
        private final List<SqlTreeNode> inputs;

        SqlUnionNode(SqlParserPos pos, List<SqlTreeNode> inputs) {
            super(pos, SqlNodeType.UNION, "");
            this.inputs = inputs;
        }

        @Override
        public List<SqlTreeNode> getInputs() {
            return this.inputs;
        }
    }

    public static class SqlTopnNode
    extends SingleSqlTreeNode {
        SqlTopnNode(SqlParserPos pos, SqlTreeNode input, String desc) {
            super(pos, SqlNodeType.TOPN, input, desc);
        }
    }

    public static class SqlSnapshotNode
    extends SingleSqlTreeNode {
        SqlSnapshotNode(SqlParserPos pos, SqlTreeNode input) {
            super(pos, SqlNodeType.SNAPSHOT, input, "");
        }
    }

    public static class SqlTableSourceNode
    extends AbstractSqlTreeNode {
        private final String tableName;

        public SqlTableSourceNode(SqlParserPos pos, SqlNodeType type, String tableName) {
            super(pos, type, tableName);
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        @Override
        public List<SqlTreeNode> getInputs() {
            return Collections.emptyList();
        }
    }

    public static class SqlTableSinkNode
    extends SingleSqlTreeNode {
        SqlTableSinkNode(SqlParserPos pos, SqlTreeNode input, String tableName) {
            super(pos, SqlNodeType.SINK, input, tableName);
        }
    }

    public static class SqlTableFunctionNode
    extends AbstractSqlTreeNode {
        SqlTableFunctionNode(SqlParserPos pos, String desc) {
            super(pos, SqlNodeType.OTHER, desc);
        }

        @Override
        public List<SqlTreeNode> getInputs() {
            return Collections.emptyList();
        }
    }

    public static class SqlSelectNode
    extends SingleSqlTreeNode {
        SqlSelectNode(SqlParserPos pos, SqlTreeNode input, String projection) {
            super(pos, SqlNodeType.SELECT, input, projection);
        }
    }

    public static class SqlJoinNode
    extends AbstractSqlTreeNode {
        private final SqlTreeNode left;
        private final SqlTreeNode right;
        private final JoinType joinType;

        SqlJoinNode(SqlParserPos pos, SqlTreeNode left, SqlTreeNode right, JoinType joinType) {
            super(pos, SqlNodeType.JOIN, "");
            this.left = left;
            this.right = right;
            this.joinType = joinType;
        }

        @Override
        public List<SqlTreeNode> getInputs() {
            return ImmutableList.of(this.left, this.right);
        }
    }

    public static class SqlGroupNode
    extends SingleSqlTreeNode {
        private final String groupKeys;

        SqlGroupNode(SqlParserPos pos, SqlTreeNode input, String groupKeys) {
            super(pos, SqlNodeType.GROUP, input, groupKeys);
            this.groupKeys = groupKeys;
        }

        public String getGroupKeys() {
            return this.groupKeys;
        }
    }

    public static class SqlFilterNode
    extends SingleSqlTreeNode {
        private final String condition;

        SqlFilterNode(SqlParserPos pos, SqlTreeNode input, String condition) {
            super(pos, SqlNodeType.FILTER, input, condition);
            this.condition = condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static class SqlCorrelateNode
    extends SingleSqlTreeNode {
        SqlCorrelateNode(SqlParserPos pos, SqlTreeNode input, String desc) {
            super(pos, SqlNodeType.UDTF, input, desc);
        }
    }

    public static abstract class SingleSqlTreeNode
    extends AbstractSqlTreeNode {
        protected SqlTreeNode input;

        SingleSqlTreeNode(SqlParserPos pos, SqlNodeType type, SqlTreeNode input, String desc) {
            super(pos, type, desc);
            this.input = input;
        }

        @Override
        public List<SqlTreeNode> getInputs() {
            return ImmutableList.of(this.input);
        }
    }

    public static abstract class AbstractSqlTreeNode
    implements SqlTreeNode {
        protected final SqlParserPos pos;
        protected final SqlNodeType type;
        protected final String desc;

        AbstractSqlTreeNode(SqlParserPos pos, SqlNodeType type, String desc) {
            this.pos = Objects.requireNonNull(pos);
            this.type = Objects.requireNonNull(type);
            this.desc = desc;
        }

        @Override
        public String explain() {
            return this.desc;
        }

        @Override
        public SqlParserPos getParserPosition() {
            return this.pos;
        }

        @Override
        public SqlNodeType getNodeType() {
            return this.type;
        }

        @Override
        public SqlTreeNode getInput(int i) {
            return this.getInputs().get(0);
        }
    }
}

