/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.plan;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.ddl.SqlNodeInfo;
import org.apache.flink.sql.parser.errorcode.ParserErrors;
import org.apache.flink.sql.parser.node.SqlToTreeConverter;
import org.apache.flink.sql.parser.node.SqlTreeNode;
import org.apache.flink.sql.parser.plan.FlinkSqlValidator;
import org.apache.flink.sql.parser.plan.SqlParseException;
import org.apache.flink.sql.parser.plan.builder.BlinkRelBuilder;
import org.apache.flink.sql.parser.util.SqlInfo;
import org.apache.flink.sql.parser.util.SqlLists;

public class FlinkPlannerImpl {
    private RelOptPlanner planner;
    private RelDataTypeFactory typeFactory;
    private SqlOperatorTable operatorTable;
    private List<RelTraitDef> traitDefs;
    private SqlRexConvertletTable convertletTable;
    private SchemaPlus defaultSchema;
    private SqlParser.Config parserConfig;
    private FlinkSqlValidator validator;
    private BlinkRelBuilder relBuilder;

    public FlinkPlannerImpl(FrameworkConfig frameworkConfig) {
        this.relBuilder = BlinkRelBuilder.create(frameworkConfig);
        this.planner = this.relBuilder.getPlanner();
        this.typeFactory = this.relBuilder.getTypeFactory();
        this.traitDefs = frameworkConfig.getTraitDefs();
        this.parserConfig = frameworkConfig.getParserConfig();
        this.convertletTable = frameworkConfig.getConvertletTable();
        this.defaultSchema = frameworkConfig.getDefaultSchema();
        SqlOperatorTable builtinOperatorTable = frameworkConfig.getOperatorTable();
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        this.operatorTable = ChainedSqlOperatorTable.of(builtinOperatorTable, catalogReader);
        this.validator = new FlinkSqlValidator(this.operatorTable, catalogReader, this.typeFactory);
        this.validator.setIdentifierExpansion(true);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public List<SqlNodeInfo> parseContext(String sqlContext) throws SqlParseException {
        this.ready();
        List<SqlInfo> sqlList = SqlLists.getSQLList(sqlContext);
        for (SqlInfo sqlInfo : sqlList) {
            int startLine = sqlInfo.getLine();
            StringBuilder sqlBuilder = new StringBuilder();
            for (int i = 0; i < startLine - 1; ++i) {
                sqlBuilder.append('\n');
            }
            String sql = sqlBuilder.append(sqlInfo.getSqlContent()).toString();
            sqlInfo.setSqlContent(sql);
        }
        ArrayList<SqlNodeInfo> sqlNodeInfoList = new ArrayList<SqlNodeInfo>();
        HashMap<String, SqlParserPos> sinkTables = new HashMap<String, SqlParserPos>();
        HashSet<String> tableNames = new HashSet<String>();
        for (SqlInfo sqlInfo : sqlList) {
            if (StringUtils.isBlank((CharSequence)sqlInfo.getSqlContent())) continue;
            SqlNodeInfo sqlNodeInfo = new SqlNodeInfo();
            SqlParser sqlParser = SqlParser.create(sqlInfo.getSqlContent(), this.parserConfig);
            try {
                SqlNode sqlNode = sqlParser.parseStmt();
                if (sqlNode instanceof SqlCreateView) {
                    String subQuerySql = this.getViewSubQuerySql(sqlInfo, (SqlCreateView)sqlNode);
                    ((SqlCreateView)sqlNode).setSubQuerySql(subQuerySql);
                } else if (sqlNode instanceof SqlInsert) {
                    SqlIdentifier targetTable = (SqlIdentifier)((SqlInsert)sqlNode).getTargetTable();
                    sinkTables.put(targetTable.toString(), targetTable.getParserPosition());
                } else if (sqlNode instanceof SqlCreateTable) {
                    String tableName = ((SqlCreateTable)sqlNode).getTableName().toString();
                    tableNames.add(tableName);
                }
                sqlNodeInfo.setOriginSql(sqlInfo.getSqlContent());
                sqlNodeInfo.setSqlNode(sqlNode);
                sqlNodeInfoList.add(sqlNodeInfo);
            }
            catch (org.apache.calcite.sql.parser.SqlParseException e2) {
                throw new SqlParseException(e2.getPos() == null ? new SqlParserPos(-1, -1) : e2.getPos(), ParserErrors.INST.parParseContextError(e2.getMessage()), e2);
            }
        }
        for (SqlNodeInfo sqlNodeInfo : sqlNodeInfoList) {
            SqlCreateTable sqlCreateTable;
            if (!(sqlNodeInfo.getSqlNode() instanceof SqlCreateTable) || (sqlCreateTable = (SqlCreateTable)sqlNodeInfo.getSqlNode()).getTableType() != null) continue;
            String tableName = sqlCreateTable.getTableName().toString();
            if (sinkTables.containsKey(tableName)) {
                sqlCreateTable.setTableType("SINK");
                continue;
            }
            sqlCreateTable.setTableType("SOURCE");
        }
        return sqlNodeInfoList;
    }

    private String getViewSubQuerySql(SqlInfo sqlInfo, SqlCreateView sqlNode) {
        int lineNum = sqlNode.getQuery().getParserPosition().getLineNum();
        int columnNum = sqlNode.getQuery().getParserPosition().getColumnNum();
        String sql = sqlInfo.getSqlContent();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(sql.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
        int i = 1;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (i < lineNum) {
                    stringBuilder.append("\n");
                } else if (i == lineNum) {
                    for (int j2 = 1; j2 < columnNum; ++j2) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(line.substring(columnNum - 1)).append('\n');
                } else {
                    stringBuilder.append(line).append('\n');
                }
                ++i;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public RelDataType getRelDataType(SqlNode sqlnode) {
        return this.validator.getValidatedNodeType(sqlnode);
    }

    public boolean validate(List<SqlNodeInfo> sqlNodeInfoList) throws SqlParseException {
        for (SqlNodeInfo nodeInfo : sqlNodeInfoList) {
            SqlNode sqlNode = nodeInfo.getSqlNode();
            if (sqlNode instanceof SqlCreateTable) {
                ((SqlCreateTable)sqlNode).validate();
                continue;
            }
            if (sqlNode instanceof SqlCreateFunction) {
                ((SqlCreateFunction)sqlNode).validate();
                continue;
            }
            if (!(sqlNode instanceof SqlCreateView)) continue;
            ((SqlCreateView)sqlNode).validate();
        }
        return true;
    }

    public List<SqlTreeNode> getSqlTreeNode(String sql) throws SqlParseException {
        List<SqlNodeInfo> nodeInfos = this.parseContext(sql);
        SqlToTreeConverter sql2Tree = new SqlToTreeConverter(this.validator);
        for (SqlNodeInfo info : nodeInfos) {
            SqlNode node = info.getSqlNode();
            sql2Tree.convertSql(node);
        }
        return sql2Tree.getNodes();
    }

    public String getJSONPlan(String sql) throws SqlParseException {
        List<SqlNodeInfo> nodeInfos = this.parseContext(sql);
        SqlToTreeConverter sql2Tree = new SqlToTreeConverter(this.validator);
        for (SqlNodeInfo info : nodeInfos) {
            SqlNode node = info.getSqlNode();
            sql2Tree.convertSql(node);
        }
        return sql2Tree.getJSON();
    }

    public RelRoot sqlToRel(SqlNode sqlNode) {
        assert (sqlNode != null);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(this.planner, rexBuilder);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)new ViewExpanderImpl(), (SqlValidator)this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, SqlToRelConverter.Config.DEFAULT);
        RelRoot tempRoot = sqlToRelConverter.convertQuery(sqlNode, false, true);
        tempRoot = tempRoot.withRel(sqlToRelConverter.flattenTypes(tempRoot.project(), true));
        tempRoot = tempRoot.withRel(RelDecorrelator.decorrelateQuery(tempRoot.project()));
        return tempRoot;
    }

    public RelOptPlanner getPlanner() {
        return this.relBuilder.getPlanner();
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    private CalciteCatalogReader createCatalogReader() {
        SchemaPlus rootSchema = FlinkPlannerImpl.rootSchema(this.defaultSchema);
        Properties prop = new Properties();
        prop.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(this.parserConfig.caseSensitive()));
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(prop);
        return new CalciteCatalogReader(CalciteSchema.from(rootSchema), CalciteSchema.from(this.defaultSchema).path(null), this.typeFactory, connectionConfig);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema2) {
        if (schema2.getParentSchema() == null) {
            return schema2;
        }
        return FlinkPlannerImpl.rootSchema(schema2.getParentSchema());
    }

    private void ready() {
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef traitDef : this.traitDefs) {
                this.planner.addRelTraitDef(traitDef);
            }
        }
    }

    public FlinkSqlValidator getValidator() {
        return this.validator;
    }

    class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        ViewExpanderImpl() {
        }

        @Override
        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> list1) {
            SqlParser sqlParser = SqlParser.create(queryString, FlinkPlannerImpl.this.parserConfig);
            try {
                SqlNode sqlNode = sqlParser.parseQuery();
                Prepare.CatalogReader catalogReader = FlinkPlannerImpl.this.createCatalogReader().withSchemaPath((List)schemaPath);
                SqlNode validatedSqlNode = FlinkPlannerImpl.this.validator.validate(sqlNode);
                RexBuilder rexBuilder = FlinkPlannerImpl.this.createRexBuilder();
                RelOptCluster cluster = RelOptCluster.create(FlinkPlannerImpl.this.planner, rexBuilder);
                SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)new ViewExpanderImpl(), (SqlValidator)FlinkPlannerImpl.this.validator, catalogReader, cluster, FlinkPlannerImpl.this.convertletTable, SqlToRelConverter.Config.DEFAULT);
                return null;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

