/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.plan.builder;

import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;

public class BlinkRelBuilder
extends RelBuilder {
    public BlinkRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public RelOptPlanner getPlanner() {
        return this.cluster.getPlanner();
    }

    public static BlinkRelBuilder create(FrameworkConfig config) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(config.getTypeSystem());
        VolcanoPlanner planner = new VolcanoPlanner(config.getCostFactory(), Contexts.empty());
        planner.setExecutor(config.getExecutor());
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        RelOptCluster cluster = RelOptCluster.create(planner, new RexBuilder(typeFactory));
        CalciteSchema calciteSchema = CalciteSchema.from(config.getDefaultSchema());
        Properties prop = new Properties();
        prop.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(config.getParserConfig().caseSensitive()));
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(prop);
        CalciteCatalogReader relOptSchema = new CalciteCatalogReader(calciteSchema, CalciteSchema.from(config.getDefaultSchema()).path(null), typeFactory, connectionConfig);
        return new BlinkRelBuilder(config.getContext(), cluster, relOptSchema);
    }
}

