/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlProperty;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlNodeInfo;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.node.SqlTreeNode;
import org.apache.flink.sql.parser.plan.FlinkPlannerImpl;
import org.apache.flink.sql.parser.plan.SqlParseException;

public class SqlContextUtils {
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setParserFactory(FlinkSqlParserImpl.FACTORY).setQuoting(Quoting.BACK_TICK).setQuotedCasing(Casing.UNCHANGED).setUnquotedCasing(Casing.UNCHANGED).setIdentifierMaxLength(256).setLex(Lex.JAVA).build();
    private static final SchemaPlus ROOT_SCHEMA = Frameworks.createRootSchema(true);
    private static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().defaultSchema(ROOT_SCHEMA).parserConfig(PARSER_CONFIG).typeSystem(RelDataTypeSystem.DEFAULT).build();

    public static String getSqlTreeJson(String sql) throws SqlParseException {
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        return flinkPlannerImpl.getJSONPlan(sql);
    }

    public static List<SqlTreeNode> getSqlTree(String sql) throws SqlParseException {
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        return flinkPlannerImpl.getSqlTreeNode(sql);
    }

    public static List<SqlNodeInfo> parseContext(String sqlContext) throws SqlParseException {
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        return flinkPlannerImpl.parseContext(sqlContext);
    }

    public static List<String> extractConnectorTypes(String sqlContext) throws SqlParseException {
        ArrayList<String> connectorTypes = Lists.newArrayList();
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        List<SqlNodeInfo> sqlNodeInfoList = flinkPlannerImpl.parseContext(sqlContext);
        for (SqlNodeInfo sqlNodeInfo : sqlNodeInfoList) {
            SqlCreateTable sqlCreateTable;
            SqlNodeList propertyList;
            if (!(sqlNodeInfo.getSqlNode() instanceof SqlCreateTable) || (propertyList = (sqlCreateTable = (SqlCreateTable)sqlNodeInfo.getSqlNode()).getPropertyList()) == null) continue;
            for (SqlNode sqlNode : sqlCreateTable.getPropertyList()) {
                String type;
                String key = ((SqlProperty)sqlNode).getKeyString();
                if (!"type".equals(key) || connectorTypes.contains(type = ((SqlProperty)sqlNode).getValueString().toLowerCase())) continue;
                connectorTypes.add(type);
            }
        }
        return connectorTypes;
    }

    public static void extractTables(String sqlContext, List<TableInfo> sourceTables, List<TableInfo> sinkTables) throws SqlParseException {
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        List<SqlNodeInfo> sqlNodeInfoList = flinkPlannerImpl.parseContext(sqlContext);
        flinkPlannerImpl.validate(sqlNodeInfoList);
        for (SqlNodeInfo sqlNodeInfo : sqlNodeInfoList) {
            if (!(sqlNodeInfo.getSqlNode() instanceof SqlCreateTable)) continue;
            SqlCreateTable sqlCreateTable = (SqlCreateTable)sqlNodeInfo.getSqlNode();
            switch (sqlCreateTable.getTableType()) {
                case "SOURCE": {
                    sourceTables.add(SqlContextUtils.extractTableInfo(sqlCreateTable));
                    break;
                }
                case "SINK": {
                    sinkTables.add(SqlContextUtils.extractTableInfo(sqlCreateTable));
                    break;
                }
            }
        }
    }

    private static TableInfo extractTableInfo(SqlCreateTable sqlCreateTable) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.tableName = sqlCreateTable.getTableName().getSimple();
        tableInfo.tableType = sqlCreateTable.getTableType();
        if (sqlCreateTable.getPropertyList() != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (SqlNode sqlNode : sqlCreateTable.getPropertyList()) {
                SqlProperty sqlProperty = (SqlProperty)sqlNode;
                properties.put(sqlProperty.getKeyString().toLowerCase(), sqlProperty.getValueString());
            }
            tableInfo.properties = properties;
            tableInfo.storageType = (String)properties.get("type");
        }
        tableInfo.columnInfoList = new ArrayList();
        for (SqlNode node : sqlCreateTable.getColumnList().getList()) {
            if (node == null || !(node instanceof SqlTableColumn)) continue;
            SqlTableColumn column = (SqlTableColumn)node;
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.columnName = column.getName().getSimple();
            columnInfo.columnType = column.getType().getTypeName().getSimple();
            tableInfo.columnInfoList.add(columnInfo);
        }
        return tableInfo;
    }

    public static class ColumnInfo {
        private String columnName;
        private String columnType;

        public ColumnInfo(String columnName, String columnType) {
            this.columnName = columnName;
            this.columnType = columnType;
        }

        public ColumnInfo() {
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnInfo that = (ColumnInfo)o;
            return this.columnName.equals(that.columnName) && this.columnType.equals(that.columnType);
        }

        public int hashCode() {
            int result = this.columnName != null ? this.columnName.hashCode() : 0;
            result = 31 * result + (this.columnType != null ? this.columnType.hashCode() : 0);
            return result;
        }
    }

    public static class TableInfo {
        private String tableName;
        private String tableType;
        private List<ColumnInfo> columnInfoList;
        private String storageType;
        private Map<String, Object> properties;

        public String getTableName() {
            return this.tableName;
        }

        public List<ColumnInfo> getColumnInfoList() {
            return this.columnInfoList;
        }

        public String getTableType() {
            return this.tableType;
        }

        public void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }
}

