/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.util;

import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.flink.sql.parser.ddl.SqlNodeInfo;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.plan.FlinkPlannerImpl;
import org.apache.flink.sql.parser.plan.SqlParseException;

public class SqlContextValidator {
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setParserFactory(FlinkSqlParserImpl.FACTORY).setQuoting(Quoting.BACK_TICK).setQuotedCasing(Casing.UNCHANGED).setUnquotedCasing(Casing.UNCHANGED).setIdentifierMaxLength(256).setLex(Lex.JAVA).build();
    private static final SchemaPlus ROOT_SCHEMA = Frameworks.createRootSchema(true);
    private static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().defaultSchema(ROOT_SCHEMA).parserConfig(PARSER_CONFIG).typeSystem(RelDataTypeSystem.DEFAULT).build();

    public static void validateSqlContext(String sqlContext) throws SqlParseException {
        FlinkPlannerImpl flinkPlannerImpl = new FlinkPlannerImpl(FRAMEWORK_CONFIG);
        List<SqlNodeInfo> sqlNodeInfoList = flinkPlannerImpl.parseContext(sqlContext);
        flinkPlannerImpl.validate(sqlNodeInfoList);
    }

    public static void main(String[] args) throws SqlParseException {
        SqlContextValidator.validateSqlContext("create table sls_stream1(\n  a bigint,\n  b VARCHAR,\n  PRIMARY KEY(a, b),\n  WATERMARK wk FOR a AS withd(b, 1000)\n) with ( x = 'y', asd = 'dada');\ncreate table rds_output(\n  a VARCHAR,\n  b bigint\n);\ninsert into rds_output\nSELECT \n  b,\n  SUM(a)\nFROM sls_stream1");
    }
}

