/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.util;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.sql.parser.util.SqlInfo;

public class SqlLists {
    private static final Pattern PATTERN_STATEMENT = Pattern.compile("[^\\\\];");
    private static final Pattern PATTERN_STRING = Pattern.compile("(\"|')([^\"^']*)(\"|')");
    private static final Pattern PATTERN_SINGLE_LINE = Pattern.compile("--.*");
    private static final Pattern PATTERN_MULTI_LINE = Pattern.compile("/\\*.*?\\*/", 32);

    public static List<SqlInfo> getSQLList(String context) {
        Object sqlInfo;
        String str;
        TreeMap<Integer, Integer> enterMap = new TreeMap<Integer, Integer>();
        int enterCount = 1;
        for (int i = 0; i < context.length(); ++i) {
            if (context.charAt(i) != '\n') continue;
            enterMap.put(i, enterCount++);
        }
        enterMap.put(context.length(), enterCount++);
        ArrayList<SqlInfo> list = new ArrayList<SqlInfo>();
        Matcher match = PATTERN_STATEMENT.matcher(context);
        int index = 0;
        while (match.find()) {
            if (SqlLists.isInComment(context, match.start() + 1) || !SqlLists.isMatch(context.substring(index, match.start() + 1), '\'') || !SqlLists.isMatch(context.substring(index, match.start() + 1), '\"')) continue;
            str = context.substring(index, match.start() + 1).replaceAll("\\\\;", ";");
            if (!"".equals(str = str.replaceAll("^;", "")) && !SqlLists.isCommentClause(str)) {
                int maxEnters = 0;
                int lastEnter = 0;
                int firstLineIndex = 0;
                int loc = index - 1;
                for (Integer i : enterMap.keySet()) {
                    if (loc > i) {
                        maxEnters = (Integer)enterMap.get(i);
                        lastEnter = i;
                    }
                    if (loc > i) continue;
                    if (loc == i) {
                        firstLineIndex = 0;
                        break;
                    }
                    firstLineIndex = loc - lastEnter;
                    break;
                }
                sqlInfo = new SqlInfo();
                ((SqlInfo)sqlInfo).setSqlContent(str);
                ((SqlInfo)sqlInfo).setLine(maxEnters + 1);
                ((SqlInfo)sqlInfo).setFirstLineIndex(firstLineIndex);
                list.add((SqlInfo)sqlInfo);
            }
            index = match.start() + 2;
        }
        if (context.substring(index) != null && context.substring(index).trim().length() != 0) {
            str = context.substring(index).replaceAll("\\\\;", ";");
            if (!"".equals(str = str.replaceAll("^;", "").replaceAll(";$", "")) && !SqlLists.isCommentClause(str)) {
                int loc = index - 1;
                int maxEnters = 0;
                int lastEnter = 0;
                int firstLineIndex = 0;
                for (Integer i : enterMap.keySet()) {
                    if (index > i) {
                        maxEnters = (Integer)enterMap.get(i);
                        lastEnter = i;
                    }
                    if (index > i) continue;
                    if (index == i) {
                        firstLineIndex = 0;
                        break;
                    }
                    firstLineIndex = index - lastEnter;
                    break;
                }
                sqlInfo = new SqlInfo();
                ((SqlInfo)sqlInfo).setSqlContent(str);
                ((SqlInfo)sqlInfo).setLine(maxEnters + 1);
                ((SqlInfo)sqlInfo).setFirstLineIndex(firstLineIndex);
                list.add((SqlInfo)sqlInfo);
            }
        }
        return list;
    }

    public static String toLowCase(String str) {
        Matcher m = PATTERN_STRING.matcher(str);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (m.find()) {
            sb.append(str.substring(index, m.start()).toLowerCase());
            sb.append(str.substring(m.start(), m.end()));
            index = m.end();
        }
        if (index != str.length()) {
            sb.append(str.substring(index, str.length()).toLowerCase());
        }
        return sb.toString();
    }

    private static boolean isCommentClause(String str) {
        String[] lines;
        String trimStr = str.trim();
        if (trimStr.startsWith("/*") && trimStr.endsWith("*/")) {
            return true;
        }
        boolean res = true;
        for (String line : lines = StringUtils.split((String)str, (String)"\n")) {
            String val = line.trim();
            if (!StringUtils.isEmpty((CharSequence)val) && !val.startsWith("--")) {
                return false;
            }
            res = true;
        }
        return res;
    }

    private static boolean isMatch(String source, char pattern) {
        int count = 0;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == pattern) {
                ++count;
            }
            if (source.charAt(i) != '\\' || i >= source.length() - 1 || source.charAt(i + 1) != pattern) continue;
            ++i;
        }
        return count % 2 == 0;
    }

    private static boolean isInComment(String context, int index) {
        Matcher singleMatch = PATTERN_SINGLE_LINE.matcher(context);
        while (singleMatch.find()) {
            int start = singleMatch.start();
            int end = singleMatch.end() - 1;
            if (index <= start || index > end) continue;
            return true;
        }
        Matcher multiMatch = PATTERN_MULTI_LINE.matcher(context);
        while (multiMatch.find()) {
            int start = multiMatch.start();
            int end = multiMatch.end() - 1;
            if (index <= start || index >= end) continue;
            return true;
        }
        return false;
    }

    private static boolean isComment(String context) {
        return true;
    }
}

