/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.plan.schema.IndexKey;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.util.Preconditions;

public class RichTableSchema
implements Serializable {
    private static final long serialVersionUID = 6101751237548033321L;
    private final String[] columnNames;
    private final InternalType[] columnTypes;
    private final boolean[] nullables;
    private final List<String> primaryKeys = new ArrayList<String>();
    private final List<List<String>> uniqueKeys = new ArrayList<List<String>>();
    private final List<String> partitionColumns = new ArrayList<String>();
    private final List<Index> indexes = new ArrayList<Index>();
    private final List<String> headerFields = new ArrayList<String>();

    public RichTableSchema(String[] columnNames, InternalType[] columnTypes) {
        boolean[] nullables = new boolean[columnNames.length];
        for (int i = 0; i < nullables.length; ++i) {
            nullables[i] = true;
        }
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.nullables = nullables;
    }

    public RichTableSchema(String[] columnNames, InternalType[] columnTypes, boolean[] nullables) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.nullables = nullables;
    }

    public RichTableSchema(String[] columnNames, InternalType[] columnTypes, boolean[] nullables, String[] primaryKeys, List<List<String>> uniqueKeys, String[] partitionColumns, List<Index> indexes, List<String> headerFields) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.nullables = nullables;
        this.setPrimaryKey(primaryKeys);
        this.setUniqueKeys(uniqueKeys);
        this.setPartitionColumns(partitionColumns);
        this.setIndexes(indexes);
        this.setHeaderFields(headerFields);
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<String> fields2) {
        Preconditions.checkArgument(this.headerFields.size() == 0, "header fields has been set");
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(Arrays.asList(this.getColumnNames()));
        for (String field : fields2) {
            if (!columnNames.contains(field)) {
                throw new IllegalArgumentException("The HEADER column field '" + field + "' is not in the table schema");
            }
            this.headerFields.add(field);
        }
    }

    public void setPrimaryKey(String ... keys) {
        Preconditions.checkArgument(this.primaryKeys.size() == 0, "primary key has been set");
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(Arrays.asList(this.getColumnNames()));
        for (String key : keys) {
            if (!columnNames.contains(key)) {
                throw new IllegalArgumentException("The primary key '" + key + "' is not in the table schema");
            }
            this.primaryKeys.add(key);
        }
    }

    public void setUniqueKeys(List<List<String>> uniqueKeys) {
        Preconditions.checkArgument(this.uniqueKeys.size() == 0, "unique key has been set");
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(Arrays.asList(this.getColumnNames()));
        for (List<String> uk : uniqueKeys) {
            for (String key : uk) {
                if (columnNames.contains(key)) continue;
                throw new IllegalArgumentException("The unique key '" + key + "' is not in the table schema");
            }
            this.uniqueKeys.add(uk);
        }
    }

    public void setPartitionColumns(String[] cols) {
        Preconditions.checkArgument(this.partitionColumns.size() == 0, "Partition columns have been set");
        HashSet<String> columnNames = new HashSet<String>(Arrays.asList(this.getColumnNames()));
        for (String colName : cols) {
            if (!columnNames.contains(colName)) {
                throw new IllegalArgumentException("The partition column '" + colName + "' is not in the table schema");
            }
            this.partitionColumns.add(colName);
        }
    }

    public void setIndexes(List<Index> keys) {
        Preconditions.checkArgument(this.indexes.size() == 0, "indexes has been set");
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(Arrays.asList(this.getColumnNames()));
        for (Index index : keys) {
            this.addIndex(index, columnNames);
        }
    }

    public void addSingleIndex(Index index) {
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(Arrays.asList(this.getColumnNames()));
        this.addIndex(index, columnNames);
    }

    protected void addIndex(Index index, Set<String> columnNames) {
        for (String key : index.keyList) {
            if (columnNames.contains(key)) continue;
            throw new IllegalArgumentException("The index key '" + key + "' is not in the table schema");
        }
        this.indexes.add(index);
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<List<String>> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public List<InternalType> getPartitionDataTypes() {
        ArrayList<InternalType> ret = new ArrayList<InternalType>(this.partitionColumns.size());
        block0: for (String partitionColumnName : this.partitionColumns) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals(partitionColumnName)) continue;
                ret.add(this.columnTypes[i]);
                continue block0;
            }
        }
        assert (ret.size() == this.partitionColumns.size());
        return ret;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public List<Index> deduceAllIndexes() {
        ArrayList<Index> indexList = new ArrayList<Index>();
        if (null != this.primaryKeys && this.primaryKeys.size() > 0) {
            indexList.add(new UniqueIndex(this.primaryKeys));
        }
        for (List<String> uk : this.uniqueKeys) {
            indexList.add(new UniqueIndex(uk));
        }
        for (Index idx : this.indexes) {
            indexList.add(idx);
        }
        return indexList;
    }

    public List<IndexKey> toIndexKeys() {
        List<Index> indexes = this.deduceAllIndexes();
        ArrayList<IndexKey> indexKeys = new ArrayList<IndexKey>();
        for (Index index : indexes) {
            indexKeys.add(index.toIndexKey(this));
        }
        return indexKeys;
    }

    public RowType getResultType() {
        return new RowType((DataType[])this.getColumnTypes(), this.getColumnNames());
    }

    public DataType getResultRowType() {
        return DataTypes.createRowTypeV2(this.getColumnTypes(), this.getColumnNames());
    }

    public RowTypeInfo getResultTypeInfo() {
        return (RowTypeInfo)TypeConverters.createExternalTypeInfoFromDataType(this.getResultRowType());
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public InternalType[] getColumnTypes() {
        return this.columnTypes;
    }

    public boolean[] getNullables() {
        return this.nullables;
    }

    public static class Index
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final boolean unique;
        public final List<String> keyList;

        public Index(boolean unique, List<String> keyList) {
            assert (keyList != null);
            this.unique = unique;
            this.keyList = keyList;
        }

        public IndexKey toIndexKey(RichTableSchema schema2) {
            assert (null != schema2);
            String[] fieldNames = schema2.getColumnNames();
            int[] indexes = new int[this.keyList.size()];
            for (int i = 0; i < this.keyList.size(); ++i) {
                int idx;
                indexes[i] = idx = this.findIndex(this.keyList.get(i), fieldNames);
            }
            return IndexKey.of(this.unique, indexes);
        }

        int findIndex(String column, String[] fieldNames) {
            for (int j2 = 0; j2 < fieldNames.length; ++j2) {
                if (!fieldNames[j2].equals(column)) continue;
                return j2;
            }
            return -1;
        }
    }

    public static class UniqueIndex
    extends Index {
        public UniqueIndex(List<String> keyList) {
            super(true, keyList);
        }
    }
}

