/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.functions;

import java.sql.Timestamp;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;

public class TemporalTableFunction
extends TableFunction<BaseRow> {
    private final transient Table underlyingHistoryTable;
    private final Expression timeAttribute;
    private final String primaryKey;
    private final RowType rowType;

    private TemporalTableFunction(Table underlyingHistoryTable, Expression timeAttribute, String primaryKey, RowType rowType) {
        this.underlyingHistoryTable = underlyingHistoryTable;
        this.timeAttribute = timeAttribute;
        this.primaryKey = primaryKey;
        this.rowType = rowType;
    }

    public void eval(Timestamp row2) {
        throw new IllegalStateException("This should never be called");
    }

    @Override
    public RowType getResultType(Object[] arguments, Class[] argTypes) {
        return this.rowType;
    }

    public Expression getTimeAttribute() {
        return this.timeAttribute;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Table getUnderlyingHistoryTable() {
        if (this.underlyingHistoryTable == null) {
            throw new IllegalStateException("Accessing table field after planing/serialization");
        }
        return this.underlyingHistoryTable;
    }

    public static TemporalTableFunction create(Table table, Expression timeAttribute, String primaryKey) {
        return new TemporalTableFunction(table, timeAttribute, primaryKey, new RowType((DataType[])table.getSchema().getTypes(), table.getSchema().getColumnNames()));
    }
}

