/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ReadableCatalog;
import org.apache.flink.table.validate.FunctionCatalogUtils;

public class LazySqlOperatorTable
implements SqlOperatorTable {
    private final CatalogManager catalogManager;
    private final FlinkTypeFactory typeFactory;

    public LazySqlOperatorTable(CatalogManager catalogManager, FlinkTypeFactory typeFactory) {
        this.catalogManager = catalogManager;
        this.typeFactory = typeFactory;
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        if (!opName.isSimple()) {
            return;
        }
        if (category == null || !category.isUserDefinedNotSpecificFunction()) {
            return;
        }
        this.getFunctionsFrom(opName.names).stream().forEachOrdered(operatorList::add);
    }

    private Collection<SqlFunction> getFunctionsFrom(List<String> names) {
        ArrayList<SqlFunction> sqlFunctions = new ArrayList<SqlFunction>();
        if (names.size() <= 1) {
            ReadableCatalog catalog = this.catalogManager.getDefaultCatalog();
            String funcName = names.get(0).toLowerCase();
            ObjectPath functionPath = new ObjectPath(this.catalogManager.getDefaultDatabaseName(), funcName);
            if (catalog.functionExists(functionPath)) {
                sqlFunctions.add(FunctionCatalogUtils.toSqlFunction(catalog, functionPath.getObjectName(), catalog.getFunction(functionPath), this.typeFactory));
            }
        }
        return sqlFunctions;
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        ArrayList<SqlOperator> sqlOperators = new ArrayList<SqlOperator>();
        ReadableCatalog catalog = this.catalogManager.getDefaultCatalog();
        String defaultDatabase = this.catalogManager.getDefaultDatabaseName();
        catalog.listFunctions(defaultDatabase).stream().forEach(functionName -> {
            SqlFunction function = FunctionCatalogUtils.toSqlFunction(catalog, functionName, catalog.getFunction(new ObjectPath(defaultDatabase, (String)functionName)), this.typeFactory);
            sqlOperators.add(function);
        });
        return sqlOperators;
    }
}

