/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Static;

public class RepeatFamilyOperandTypeChecker
implements SqlOperandTypeChecker {
    protected final SqlTypeFamily family;

    public RepeatFamilyOperandTypeChecker(SqlTypeFamily family) {
        this.family = family;
    }

    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, boolean throwOnFailure) {
        if (SqlUtil.isNullLiteral(node, false)) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName.getFamily() == SqlTypeFamily.ANY) {
            return true;
        }
        if (!this.family.getTypeNames().contains((Object)typeName)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>(Collections.nCopies(callBinding.getOperandCount(), this.family));
        for (Ord<SqlNode> op : Ord.zip(callBinding.operands())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, false)) continue;
            boolean changed = false;
            if (callBinding.getValidator().getEnableTypeCoercion()) {
                TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
                ArrayList<RelDataType> dataTypes = new ArrayList<RelDataType>();
                for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                    dataTypes.add(callBinding.getOperandType(i));
                }
                changed = typeCoercion.implicitTypeCast(callBinding, dataTypes, families);
            }
            for (Ord<SqlNode> op1 : Ord.zip(callBinding.operands())) {
                if (this.checkSingleOperandType(callBinding, (SqlNode)op1.e, throwOnFailure)) continue;
                return false;
            }
            return changed;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, Arrays.asList(this.family.toString(), "..."));
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }
}

