/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite.type;

import java.util.List;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;

public class SpecificLiteralOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private final List<Object> literalVals;
    private final int position;
    private final SqlSingleOperandTypeChecker innerChecker;

    public SpecificLiteralOperandTypeChecker(SqlTypeFamily family, int position, List literalVals) {
        if (literalVals.isEmpty()) {
            throw new IllegalArgumentException("Possible literal values must be provided.");
        }
        this.position = position;
        this.innerChecker = OperandTypes.family(family);
        this.literalVals = literalVals;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.innerChecker.checkOperandTypes(callBinding, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return this.innerChecker.getOperandCountRange();
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return this.innerChecker.getAllowedSignatures(op, opName) + ", and the value must be in " + this.literalVals;
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return this.innerChecker.getConsistency();
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        Object value = callBinding.getOperandLiteralValue(this.position, this.literalVals.get(0).getClass());
        return value != null && this.literalVals.contains(value);
    }
}

