/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.catalog.CatalogFactory;
import org.apache.flink.table.catalog.CatalogType;
import org.apache.flink.table.catalog.GenericInMemoryCatalogFactory;
import org.apache.flink.table.catalog.ReadableCatalog;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogLoader.class);
    private static final String HIVE_CATALOG_FACTORY_CLASS_NAME = "org.apache.flink.table.catalog.hive.HiveCatalogFactory";

    public static ReadableCatalog loadCatalogFromConfig(ClassLoader cl, String catalogType, Optional<String> catalogFactoryClass, String catalogName, Map<String, String> properties) throws DynamicCodeLoadingException {
        Preconditions.checkNotNull(cl, "class loader cannot be null or empty");
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(catalogType), "catalogType cannot be null or empty");
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(catalogName), "catalogName cannot be null or empty");
        Preconditions.checkNotNull(properties, "properties cannot be null or empty");
        CatalogType type = CatalogType.valueOf(catalogType);
        switch (type) {
            case generic_in_memory: {
                return new GenericInMemoryCatalogFactory().createCatalog(catalogName, (Map)properties);
            }
            case hive: {
                return CatalogLoader.loadCatalog(cl, HIVE_CATALOG_FACTORY_CLASS_NAME, catalogName, properties);
            }
            case custom: {
                LOG.info("Loading cutom catalog with factory class %s with class loader", (Object)catalogType);
                return CatalogLoader.loadCatalog(cl, catalogFactoryClass.get(), catalogName, properties);
            }
        }
        throw new IllegalStateException("Should never reach here");
    }

    private static ReadableCatalog loadCatalog(ClassLoader cl, String catalogFactoryClass, String catalogName, Map<String, String> properties) throws DynamicCodeLoadingException {
        CatalogFactory factory;
        try {
            Class<CatalogFactory> clazz = Class.forName(catalogFactoryClass, false, cl).asSubclass(CatalogFactory.class);
            factory = clazz.newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new DynamicCodeLoadingException(String.format("Cannot find configured catalog factory class: %s", catalogFactoryClass), e2);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e3) {
            throw new DynamicCodeLoadingException(String.format("The class configured for catalog does not have a valid catalog factory (%s)", catalogFactoryClass), e3);
        }
        return factory.createCatalog(catalogName, properties);
    }
}

