/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.AmbiguousTableFactoryException;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.api.TableSourceParser;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ToolConnectorDescriptor;
import org.apache.flink.table.factories.BatchCompatibleTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.factories.TableSourceParserFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExternalTableUtil$
implements Logging {
    public static final ExternalTableUtil$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExternalTableUtil$();
    }

    private Logger LOG$lzycompute() {
        ExternalTableUtil$ externalTableUtil$ = this;
        synchronized (externalTableUtil$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public TableSourceParser toParser(String name, CatalogTable table, boolean isStreaming) {
        Throwable throwable2;
        block2: {
            TableSourceParser tableSourceParser;
            TableProperties tableProperties = this.generateTableProperties(name, table, isStreaming);
            try {
                TableSourceParserFactory tableFactory = TableFactoryService$.MODULE$.find(TableSourceParserFactory.class, this.getToolDescriptor(this.getStorageType(name, tableProperties), tableProperties));
                tableSourceParser = tableFactory.createParser(name, table.getRichTableSchema(), tableProperties);
            }
            catch (Throwable throwable2) {
                TableSourceParser tableSourceParser2;
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof AmbiguousTableFactoryException ? true : throwable3 instanceof NoMatchingTableFactoryException;
                if (!bl) break block2;
                tableSourceParser = tableSourceParser2 = null;
            }
            return tableSourceParser;
        }
        throw throwable2;
    }

    public TableSource toTableSource(String name, CatalogTable catalogTable, boolean isStreaming) {
        TableProperties tableProperties = this.generateTableProperties(name, catalogTable, isStreaming);
        ToolConnectorDescriptor descriptor = this.getToolDescriptor(this.getStorageType(name, tableProperties), tableProperties);
        return isStreaming ? TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, descriptor).createStreamTableSource(tableProperties.toKeyLowerCase().toMap()) : TableFactoryService$.MODULE$.find(BatchTableSourceFactory.class, descriptor).createBatchTableSource(tableProperties.toKeyLowerCase().toMap());
    }

    public TableSink<?> toTableSink(String name, CatalogTable externalTable, boolean isStreaming) {
        TableSink tableSink;
        TableProperties tableProperties = this.generateTableProperties(name, externalTable, isStreaming);
        ToolConnectorDescriptor descriptor = this.getToolDescriptor(this.getStorageType(name, tableProperties), tableProperties);
        if (isStreaming) {
            tableSink = TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, descriptor).createStreamTableSink(tableProperties.toKeyLowerCase().toMap());
        } else {
            try {
                tableSink = TableFactoryService$.MODULE$.find(BatchTableSinkFactory.class, descriptor).createBatchTableSink(tableProperties.toKeyLowerCase().toMap());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (NoMatchingTableFactoryException noMatchingTableFactoryException) {
                tableSink = TableFactoryService$.MODULE$.find(BatchCompatibleTableSinkFactory.class, descriptor).createBatchCompatibleTableSink(tableProperties.toKeyLowerCase().toMap());
            }
        }
        return tableSink;
    }

    public TableProperties generateTableProperties(String sqlTableName, CatalogTable externalTable, boolean isStream) {
        boolean bl;
        block4: {
            TableProperties tableProperties;
            block3: {
                block2: {
                    tableProperties = new TableProperties();
                    tableProperties.addAll(externalTable.getProperties());
                    bl = isStream;
                    if (!bl) break block2;
                    tableProperties.setString(TableProperties.BLINK_ENVIRONMENT_TYPE_KEY, TableProperties.BLINK_ENVIRONMENT_STREAM_VALUE);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (bl) break block4;
                tableProperties.setString(TableProperties.BLINK_ENVIRONMENT_TYPE_KEY, TableProperties.BLINK_ENVIRONMENT_BATCHEXEC_VALUE);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            tableProperties.setString(TableProperties.BLINK_CONNECTOR_TYPE_KEY, externalTable.getTableType());
            tableProperties.putTableNameIntoProperties(sqlTableName);
            tableProperties.putSchemaIntoProperties(externalTable.getRichTableSchema());
            tableProperties.putTableSchemaIntoProperties(externalTable.getTableSchema());
            return tableProperties;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> normalizeSupportedKeys(Map<String, String> props) {
        void var2_2;
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(props);
        JavaConversions$.MODULE$.asScalaBuffer(TableProperties.INTERNAL_KEYS).foreach((Function1)new Serializable(ret){
            public static final long serialVersionUID = 0L;
            private final HashMap ret$1;

            public final String apply(String x$1) {
                return (String)this.ret$1.remove(x$1);
            }
            {
                this.ret$1 = ret$1;
            }
        });
        return var2_2;
    }

    private ToolConnectorDescriptor getToolDescriptor(String typeName, TableProperties tableProperties) {
        return new ToolConnectorDescriptor(typeName, this.normalizeSupportedKeys(tableProperties.toKeyLowerCase().toMap()));
    }

    /*
     * WARNING - void declaration
     */
    private String getStorageType(String tableName, TableProperties properties) {
        void var3_3;
        String typeName = properties.getString("type", null);
        Preconditions.checkState(typeName != null, "Property of table %s is missing", typeName);
        return var3_3;
    }

    private ExternalTableUtil$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

