/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class ObjectPath {
    private final String dbName;
    private final String objectName;

    public ObjectPath(String dbName, String objectName) {
        Preconditions.checkNotNull(dbName, "dbName cannot be null");
        Preconditions.checkNotNull(objectName, "objectName cannot be null");
        this.dbName = dbName.toLowerCase();
        this.objectName = objectName.toLowerCase();
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFullName() {
        return String.format("%s.%s", this.dbName, this.objectName);
    }

    public static ObjectPath fromString(String fullName) {
        String[] paths = fullName.split("\\.");
        if (paths.length != 2) {
            throw new IllegalArgumentException(String.format("Cannot get split '%s' to get dbName and objectName", fullName));
        }
        return new ObjectPath(paths[0], paths[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath that = (ObjectPath)o;
        return Objects.equals(this.dbName, that.dbName) && Objects.equals(this.objectName, that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.dbName, this.objectName);
    }

    public String toString() {
        return String.format("%s.%s", this.dbName, this.objectName);
    }
}

