/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Closeable;
import java.util.List;
import org.apache.calcite.sql.SqlFunction;
import org.apache.flink.table.api.DatabaseNotExistException;
import org.apache.flink.table.api.FunctionNotExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.api.exceptions.PartitionNotExistException;
import org.apache.flink.table.api.exceptions.TableNotPartitionedException;
import org.apache.flink.table.api.functions.UserDefinedFunction;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.plan.stats.TableStats;

public interface ReadableCatalog
extends Closeable {
    public String getDefaultDatabaseName();

    public void setDefaultDatabaseName(String var1);

    default public void setCurrentDatabaseName(String databaseName) {
    }

    public void open();

    public List<String> listDatabases();

    public CatalogDatabase getDatabase(String var1) throws DatabaseNotExistException;

    public boolean dbExists(String var1);

    public List<String> listTables(String var1) throws DatabaseNotExistException;

    public CatalogTable getTable(ObjectPath var1) throws TableNotExistException;

    public boolean tableExists(ObjectPath var1);

    public List<String> listViews(String var1) throws DatabaseNotExistException;

    public TableStats getTableStats(ObjectPath var1) throws TableNotExistException;

    default public TableStats getPartitionStats(ObjectPath tablePath, CatalogPartition.PartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionNotExistException {
        return TableStats.UNKNOWN_STATS;
    }

    public List<CatalogPartition.PartitionSpec> listPartitions(ObjectPath var1) throws TableNotExistException, TableNotPartitionedException;

    public List<CatalogPartition.PartitionSpec> listPartitions(ObjectPath var1, CatalogPartition.PartitionSpec var2) throws TableNotExistException, TableNotPartitionedException;

    public CatalogPartition getPartition(ObjectPath var1, CatalogPartition.PartitionSpec var2) throws TableNotExistException, TableNotPartitionedException, PartitionNotExistException;

    public boolean partitionExists(ObjectPath var1, CatalogPartition.PartitionSpec var2);

    public List<String> listFunctions(String var1) throws DatabaseNotExistException;

    public CatalogFunction getFunction(ObjectPath var1) throws FunctionNotExistException;

    public boolean functionExists(ObjectPath var1);

    default public UserDefinedFunction initiateUDF(ClassLoader classLoader, String functionName, String functionClassName) {
        return (UserDefinedFunction)UserDefinedFunctionUtils.createUserDefinedFunction(classLoader, functionName, functionClassName);
    }

    default public SqlFunction getSqlFunction(ClassLoader classLoader, String functionName, String functionClassName, FlinkTypeFactory typeFactory) {
        UserDefinedFunction udf = this.initiateUDF(classLoader, functionName, functionClassName);
        if (udf instanceof ScalarFunction) {
            return UserDefinedFunctionUtils.createScalarSqlFunction(functionName, functionName, (ScalarFunction)udf, typeFactory);
        }
        if (udf instanceof TableFunction) {
            return UserDefinedFunctionUtils.createTableSqlFunction(functionName, functionName, (TableFunction)udf, typeFactory);
        }
        if (udf instanceof AggregateFunction) {
            AggregateFunction agg = (AggregateFunction)udf;
            return UserDefinedFunctionUtils.createAggregateSqlFunction(functionName, functionName, agg, UserDefinedFunctionUtils.getResultTypeOfAggregateFunction(agg, null), UserDefinedFunctionUtils.getAccumulatorTypeOfAggregateFunction(agg, null), typeFactory);
        }
        throw new UnsupportedOperationException(String.format("Function %s should be of ScalarFunction, TableFunction, or AggregateFunction", functionName));
    }
}

