/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codegen;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.sql.fun.SqlDatetimeSubtractionOperator;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.calcite.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.ExecutionError;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.codegen.CodeFormatter$;
import org.apache.flink.table.codegen.CodeGenException;
import org.apache.flink.table.codegen.CodeGenUtils$;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedExpression$;
import org.apache.flink.table.codegen.GeneratedSplittableExpression;
import org.apache.flink.table.codegen.calls.BinaryStringCallGen$;
import org.apache.flink.table.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.codegen.calls.CallGenerator;
import org.apache.flink.table.codegen.calls.CurrentTimePointCallGen;
import org.apache.flink.table.codegen.calls.FunctionGenerator$;
import org.apache.flink.table.codegen.calls.ScalarOperators$;
import org.apache.flink.table.codesplit.JavaCodeSplitter;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BoxedWrapperRow;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.functions.sql.ScalarSqlFunctions$;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterBuilderFunction;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterFunction;
import org.apache.flink.table.functions.sql.internal.SqlThrowExceptionFunction;
import org.apache.flink.table.runtime.functions.DateTimeFunctions$;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.CharType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.typeutils.BaseArraySerializer;
import org.apache.flink.table.typeutils.BaseMapSerializer;
import org.apache.flink.table.typeutils.BaseRowSerializer;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging$;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.codehaus.janino.SimpleCompiler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CodeGenUtils$ {
    public static final CodeGenUtils$ MODULE$;
    private final AtomicInteger nameCounter;
    private final LoadingCache<Tuple3<ClassLoader, String, String>, Class<?>> compileCache;

    static {
        new CodeGenUtils$();
    }

    private AtomicInteger nameCounter() {
        return this.nameCounter;
    }

    public String newName(String name) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)this.nameCounter().getAndIncrement())}));
    }

    public Seq<String> newNames(Seq<String> names) {
        Predef$.MODULE$.require(names.toSet().size() == names.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Duplicated names";
            }
        });
        int newId = this.nameCounter().getAndIncrement();
        return (Seq)names.map((Function1)new Serializable(newId){
            public static final long serialVersionUID = 0L;
            private final int newId$1;

            public final String apply(String name) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)this.newId$1)}));
            }
            {
                this.newId$1 = newId$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> String className(Manifest<T> m) {
        return m.runtimeClass().getCanonicalName();
    }

    public boolean needCopyForType(InternalType t) {
        InternalType internalType = t;
        StringType stringType = DataTypes.STRING;
        InternalType internalType2 = internalType;
        boolean bl = !(stringType != null ? !((Object)stringType).equals(internalType2) : internalType2 != null) ? true : (internalType instanceof ArrayType ? true : (internalType instanceof MapType ? true : (internalType instanceof RowType ? true : internalType instanceof GenericType)));
        return bl;
    }

    public boolean needCloneRefForType(InternalType t) {
        InternalType internalType = t;
        StringType stringType = DataTypes.STRING;
        InternalType internalType2 = internalType;
        boolean bl = !(stringType != null ? !((Object)stringType).equals(internalType2) : internalType2 != null);
        return bl;
    }

    public boolean needCloneRefForDataType(DataType t) {
        TypeInformation<?> typeInformation = TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(t);
        BinaryStringTypeInfo binaryStringTypeInfo = BinaryStringTypeInfo.INSTANCE;
        TypeInformation<?> typeInformation2 = typeInformation;
        boolean bl = !(binaryStringTypeInfo != null ? !((Object)binaryStringTypeInfo).equals(typeInformation2) : typeInformation2 != null);
        return bl;
    }

    public String primitiveTypeTermForType(InternalType t) {
        String string;
        InternalType internalType = t;
        IntType intType = DataTypes.INT;
        InternalType internalType2 = internalType;
        if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
            string = "int";
        } else {
            LongType longType = DataTypes.LONG;
            InternalType internalType3 = internalType;
            if (!(longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null)) {
                string = "long";
            } else {
                ShortType shortType = DataTypes.SHORT;
                InternalType internalType4 = internalType;
                if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                    string = "short";
                } else {
                    ByteType byteType = DataTypes.BYTE;
                    InternalType internalType5 = internalType;
                    if (!(byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null)) {
                        string = "byte";
                    } else {
                        FloatType floatType = DataTypes.FLOAT;
                        InternalType internalType6 = internalType;
                        if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                            string = "float";
                        } else {
                            DoubleType doubleType = DataTypes.DOUBLE;
                            InternalType internalType7 = internalType;
                            if (!(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null)) {
                                string = "double";
                            } else {
                                BooleanType booleanType = DataTypes.BOOLEAN;
                                InternalType internalType8 = internalType;
                                if (!(booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null)) {
                                    string = "boolean";
                                } else {
                                    CharType charType = DataTypes.CHAR;
                                    InternalType internalType9 = internalType;
                                    if (!(charType != null ? !((Object)charType).equals(internalType9) : internalType9 != null)) {
                                        string = "char";
                                    } else if (internalType instanceof DateType) {
                                        string = "int";
                                    } else {
                                        TimeType timeType = DataTypes.TIME;
                                        InternalType internalType10 = internalType;
                                        if (!(timeType != null ? !((Object)timeType).equals(internalType10) : internalType10 != null)) {
                                            string = "int";
                                        } else if (internalType instanceof TimestampType) {
                                            string = "long";
                                        } else {
                                            DateType dateType = DataTypes.INTERVAL_MONTHS;
                                            InternalType internalType11 = internalType;
                                            if (!(dateType != null ? !((Object)dateType).equals(internalType11) : internalType11 != null)) {
                                                string = "int";
                                            } else {
                                                TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
                                                InternalType internalType12 = internalType;
                                                string = !(timestampType != null ? !((Object)timestampType).equals(internalType12) : internalType12 != null) ? "long" : this.boxedTypeTermForType(t);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public boolean isInternalPrimitive(InternalType tpe) {
        return TypeCheckUtils$.MODULE$.isTemporal(tpe);
    }

    public String externalBoxedTermForType(DataType t) {
        DataType dataType2;
        block28: {
            String string;
            block18: {
                String string2;
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            ArrayType arrayType;
                                            boolean bl;
                                            block20: {
                                                block19: {
                                                    block17: {
                                                        bl = false;
                                                        arrayType = null;
                                                        dataType2 = t;
                                                        StringType stringType = DataTypes.STRING;
                                                        DataType dataType3 = dataType2;
                                                        if (stringType != null ? !((Object)stringType).equals(dataType3) : dataType3 != null) break block17;
                                                        string = String.class.getCanonicalName();
                                                        break block18;
                                                    }
                                                    if (!(dataType2 instanceof DecimalType)) break block19;
                                                    string = BigDecimal.class.getCanonicalName();
                                                    break block18;
                                                }
                                                if (!(dataType2 instanceof ArrayType)) break block20;
                                                bl = true;
                                                arrayType = (ArrayType)dataType2;
                                                if (!arrayType.isPrimitive()) break block20;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.primitiveTypeTermForType(arrayType.getElementInternalType())}));
                                                break block18;
                                            }
                                            if (!bl) break block21;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.externalBoxedTermForType(arrayType.getElementType())}));
                                            break block18;
                                        }
                                        if (!(dataType2 instanceof RowType)) break block22;
                                        string = Row.class.getCanonicalName();
                                        break block18;
                                    }
                                    if (!(dataType2 instanceof MapType)) break block23;
                                    string = Map.class.getCanonicalName();
                                    break block18;
                                }
                                if (!(dataType2 instanceof TimestampType)) break block24;
                                DataType dataType4 = t;
                                TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
                                if (!(dataType4 == null ? timestampType != null : !dataType4.equals(timestampType))) break block24;
                                string = Timestamp.class.getCanonicalName();
                                break block18;
                            }
                            if (!(dataType2 instanceof DateType)) break block25;
                            DataType dataType5 = t;
                            DateType dateType = DataTypes.INTERVAL_MONTHS;
                            if (!(dataType5 == null ? dateType != null : !dataType5.equals(dateType))) break block25;
                            string = Date.class.getCanonicalName();
                            break block18;
                        }
                        TimeType timeType = DataTypes.TIME;
                        DataType dataType6 = dataType2;
                        if (timeType != null ? !((Object)timeType).equals(dataType6) : dataType6 != null) break block26;
                        string = Time.class.getCanonicalName();
                        break block18;
                    }
                    if (!(dataType2 instanceof InternalType)) break block27;
                    InternalType internalType = (InternalType)dataType2;
                    string = this.boxedTypeTermForType(internalType);
                    break block18;
                }
                if (!(dataType2 instanceof TypeInfoWrappedDataType)) break block28;
                TypeInfoWrappedDataType typeInfoWrappedDataType = (TypeInfoWrappedDataType)dataType2;
                TypeInformation typeInformation = typeInfoWrappedDataType.getTypeInfo();
                PrimitiveArrayTypeInfo<int[]> primitiveArrayTypeInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                TypeInformation typeInformation2 = typeInformation;
                if (!(primitiveArrayTypeInfo != null ? !((Object)primitiveArrayTypeInfo).equals(typeInformation2) : typeInformation2 != null)) {
                    string2 = "int[]";
                } else {
                    PrimitiveArrayTypeInfo<long[]> primitiveArrayTypeInfo2 = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                    TypeInformation typeInformation3 = typeInformation;
                    if (!(primitiveArrayTypeInfo2 != null ? !((Object)primitiveArrayTypeInfo2).equals(typeInformation3) : typeInformation3 != null)) {
                        string2 = "long[]";
                    } else {
                        PrimitiveArrayTypeInfo<short[]> primitiveArrayTypeInfo3 = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                        TypeInformation typeInformation4 = typeInformation;
                        if (!(primitiveArrayTypeInfo3 != null ? !((Object)primitiveArrayTypeInfo3).equals(typeInformation4) : typeInformation4 != null)) {
                            string2 = "short[]";
                        } else {
                            PrimitiveArrayTypeInfo<byte[]> primitiveArrayTypeInfo4 = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
                            TypeInformation typeInformation5 = typeInformation;
                            if (!(primitiveArrayTypeInfo4 != null ? !((Object)primitiveArrayTypeInfo4).equals(typeInformation5) : typeInformation5 != null)) {
                                string2 = "byte[]";
                            } else {
                                PrimitiveArrayTypeInfo<float[]> primitiveArrayTypeInfo5 = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                                TypeInformation typeInformation6 = typeInformation;
                                if (!(primitiveArrayTypeInfo5 != null ? !((Object)primitiveArrayTypeInfo5).equals(typeInformation6) : typeInformation6 != null)) {
                                    string2 = "float[]";
                                } else {
                                    PrimitiveArrayTypeInfo<double[]> primitiveArrayTypeInfo6 = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                                    TypeInformation typeInformation7 = typeInformation;
                                    if (!(primitiveArrayTypeInfo6 != null ? !((Object)primitiveArrayTypeInfo6).equals(typeInformation7) : typeInformation7 != null)) {
                                        string2 = "double[]";
                                    } else {
                                        PrimitiveArrayTypeInfo<boolean[]> primitiveArrayTypeInfo7 = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
                                        TypeInformation typeInformation8 = typeInformation;
                                        if (!(primitiveArrayTypeInfo7 != null ? !((Object)primitiveArrayTypeInfo7).equals(typeInformation8) : typeInformation8 != null)) {
                                            string2 = "boolean[]";
                                        } else {
                                            PrimitiveArrayTypeInfo<char[]> primitiveArrayTypeInfo8 = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                                            TypeInformation typeInformation9 = typeInformation;
                                            string2 = !(primitiveArrayTypeInfo8 != null ? !((Object)primitiveArrayTypeInfo8).equals(typeInformation9) : typeInformation9 != null) ? "char[]" : typeInfoWrappedDataType.getTypeInfo().getTypeClass().getCanonicalName();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                string = string2;
            }
            return string;
        }
        throw new MatchError((Object)dataType2);
    }

    public String boxedTypeTermForType(InternalType t) {
        InternalType internalType;
        block22: {
            String string;
            block15: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        while (true) {
                                            internalType = t;
                                            IntType intType = DataTypes.INT;
                                            InternalType internalType2 = internalType;
                                            if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
                                                string = Integer.class.getCanonicalName();
                                                break block15;
                                            }
                                            LongType longType = DataTypes.LONG;
                                            InternalType internalType3 = internalType;
                                            if (!(longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null)) {
                                                string = Long.class.getCanonicalName();
                                                break block15;
                                            }
                                            ShortType shortType = DataTypes.SHORT;
                                            InternalType internalType4 = internalType;
                                            if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                                                string = Short.class.getCanonicalName();
                                                break block15;
                                            }
                                            ByteType byteType = DataTypes.BYTE;
                                            InternalType internalType5 = internalType;
                                            if (!(byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null)) {
                                                string = Byte.class.getCanonicalName();
                                                break block15;
                                            }
                                            FloatType floatType = DataTypes.FLOAT;
                                            InternalType internalType6 = internalType;
                                            if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                                                string = Float.class.getCanonicalName();
                                                break block15;
                                            }
                                            DoubleType doubleType = DataTypes.DOUBLE;
                                            InternalType internalType7 = internalType;
                                            if (!(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null)) {
                                                string = Double.class.getCanonicalName();
                                                break block15;
                                            }
                                            BooleanType booleanType = DataTypes.BOOLEAN;
                                            InternalType internalType8 = internalType;
                                            if (!(booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null)) {
                                                string = Boolean.class.getCanonicalName();
                                                break block15;
                                            }
                                            CharType charType = DataTypes.CHAR;
                                            InternalType internalType9 = internalType;
                                            if (!(charType != null ? !((Object)charType).equals(internalType9) : internalType9 != null)) {
                                                string = Character.class.getCanonicalName();
                                                break block15;
                                            }
                                            if (internalType instanceof DateType) {
                                                t = DataTypes.INT;
                                                continue;
                                            }
                                            TimeType timeType = DataTypes.TIME;
                                            InternalType internalType10 = internalType;
                                            if (!(timeType != null ? !((Object)timeType).equals(internalType10) : internalType10 != null)) {
                                                t = DataTypes.INT;
                                                continue;
                                            }
                                            if (!(internalType instanceof TimestampType)) break;
                                            t = DataTypes.LONG;
                                        }
                                        StringType stringType = DataTypes.STRING;
                                        InternalType internalType11 = internalType;
                                        if (stringType != null ? !((Object)stringType).equals(internalType11) : internalType11 != null) break block16;
                                        string = CodeGeneratorContext$.MODULE$.BINARY_STRING();
                                        break block15;
                                    }
                                    ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
                                    InternalType internalType12 = internalType;
                                    if (byteArrayType != null ? !((Object)byteArrayType).equals(internalType12) : internalType12 != null) break block17;
                                    string = "byte[]";
                                    break block15;
                                }
                                if (!(internalType instanceof DecimalType)) break block18;
                                string = Decimal.class.getCanonicalName();
                                break block15;
                            }
                            if (!(internalType instanceof ArrayType)) break block19;
                            string = BaseArray.class.getCanonicalName();
                            break block15;
                        }
                        if (!(internalType instanceof MapType)) break block20;
                        string = BaseMap.class.getCanonicalName();
                        break block15;
                    }
                    if (!(internalType instanceof RowType)) break block21;
                    string = BaseRow.class.getCanonicalName();
                    break block15;
                }
                if (!(internalType instanceof GenericType)) break block22;
                GenericType genericType = (GenericType)internalType;
                string = genericType.getTypeInfo().getTypeClass().getCanonicalName();
            }
            return string;
        }
        throw new MatchError((Object)internalType);
    }

    public String primitiveDefaultValue(InternalType t) {
        String string;
        boolean bl;
        InternalType internalType = t;
        IntType intType = DataTypes.INT;
        InternalType internalType2 = internalType;
        if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
            bl = true;
        } else {
            ByteType byteType = DataTypes.BYTE;
            InternalType internalType3 = internalType;
            if (!(byteType != null ? !((Object)byteType).equals(internalType3) : internalType3 != null)) {
                bl = true;
            } else {
                ShortType shortType = DataTypes.SHORT;
                InternalType internalType4 = internalType;
                bl = !(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null);
            }
        }
        if (bl) {
            string = "-1";
        } else {
            LongType longType = DataTypes.LONG;
            InternalType internalType5 = internalType;
            if (!(longType != null ? !((Object)longType).equals(internalType5) : internalType5 != null)) {
                string = "-1L";
            } else {
                FloatType floatType = DataTypes.FLOAT;
                InternalType internalType6 = internalType;
                if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                    string = "-1.0f";
                } else {
                    DoubleType doubleType = DataTypes.DOUBLE;
                    InternalType internalType7 = internalType;
                    if (!(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null)) {
                        string = "-1.0d";
                    } else {
                        BooleanType booleanType = DataTypes.BOOLEAN;
                        InternalType internalType8 = internalType;
                        if (!(booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null)) {
                            string = "false";
                        } else {
                            StringType stringType = DataTypes.STRING;
                            InternalType internalType9 = internalType;
                            if (!(stringType != null ? !((Object)stringType).equals(internalType9) : internalType9 != null)) {
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".EMPTY_UTF8"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BINARY_STRING()}));
                            } else {
                                CharType charType = DataTypes.CHAR;
                                InternalType internalType10 = internalType;
                                if (!(charType != null ? !((Object)charType).equals(internalType10) : internalType10 != null)) {
                                    string = "'\\0'";
                                } else {
                                    boolean bl2;
                                    if (internalType instanceof DateType) {
                                        bl2 = true;
                                    } else {
                                        TimeType timeType = DataTypes.TIME;
                                        InternalType internalType11 = internalType;
                                        bl2 = !(timeType != null ? !((Object)timeType).equals(internalType11) : internalType11 != null);
                                    }
                                    string = bl2 ? "-1" : (internalType instanceof TimestampType ? "-1L" : "null");
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInternalClass(Class<?> clazz, DataType t) {
        Class<?> clazz2 = clazz;
        Class<Object> clazz3 = Object.class;
        if (clazz2 == null) {
            if (clazz3 == null) return false;
        } else if (clazz2.equals(clazz3)) return false;
        Class<?> clazz4 = clazz;
        Class<Row> clazz5 = Row.class;
        if (clazz4 == null) {
            if (clazz5 == null) return false;
        } else if (clazz4.equals(clazz5)) return false;
        if (BaseRow.class.isAssignableFrom(clazz)) return true;
        Class<?> clazz6 = clazz;
        Class<?> clazz7 = TypeConverters$.MODULE$.createInternalTypeInfoFromDataType(t).getTypeClass();
        if (clazz6 != null) {
            if (!clazz6.equals(clazz7)) return false;
            return true;
        }
        if (clazz7 == null) return true;
        return false;
    }

    public String qualifyMethod(Method method) {
        return new StringBuilder().append((Object)method.getDeclaringClass().getCanonicalName()).append((Object)".").append((Object)method.getName()).toString();
    }

    public String qualifyEnum(Enum<?> enum_) {
        return new StringBuilder().append((Object)enum_.getClass().getCanonicalName()).append((Object)".").append((Object)enum_.name()).toString();
    }

    public String internalToStringCode(InternalType t, String resultTerm, String zoneTerm) {
        InternalType internalType;
        block5: {
            String string;
            block3: {
                block4: {
                    block2: {
                        internalType = t;
                        DateType dateType = DataTypes.DATE;
                        InternalType internalType2 = internalType;
                        if (dateType != null ? !((Object)dateType).equals(internalType2) : internalType2 != null) break block2;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifyMethod(BuiltInMethod.UNIX_DATE_TO_STRING.method), resultTerm}));
                        break block3;
                    }
                    TimeType timeType = DataTypes.TIME;
                    InternalType internalType3 = internalType;
                    if (timeType != null ? !((Object)timeType).equals(internalType3) : internalType3 != null) break block4;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifyMethod(BuiltInMethods$.MODULE$.UNIX_TIME_TO_STRING()), resultTerm}));
                    break block3;
                }
                if (!(internalType instanceof TimestampType)) break block5;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", 3, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING()), resultTerm, zoneTerm}));
            }
            return string;
        }
        throw new MatchError((Object)internalType);
    }

    public boolean compareEnum(String term2, Enum<?> enum_) {
        String string = term2;
        String string2 = this.qualifyEnum(enum_);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Enum<?> getEnum(GeneratedExpression genExpr) {
        String[] split = new StringOps(Predef$.MODULE$.augmentString(genExpr.resultTerm())).split('.');
        String value = (String)Predef$.MODULE$.refArrayOps((Object[])split).last();
        return this.enumValueOf(((GenericType)genExpr.resultType()).getTypeInfo().getTypeClass(), value);
    }

    public <T extends Enum<T>> Enum<?> enumValueOf(Class<?> cls, String stringValue) {
        return Enum.valueOf(cls, stringValue);
    }

    public void requireNumeric(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isNumeric(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError(new StringBuilder().append((Object)"Numeric expression type expected, but was ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{genExpr.resultType()}))).toString(), operatorName));
    }

    public void requireComparable(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isComparable(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Comparable type expected, but was '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{genExpr.resultType()})), operatorName));
    }

    public void requireString(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isString(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("String expression type expected.", operatorName));
    }

    public void requireBoolean(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isBoolean(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Boolean expression type expected.", operatorName));
    }

    public void requireTemporal(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isTemporal(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Temporal expression type expected.", operatorName));
    }

    public void requireTimeInterval(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isTimeInterval(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Interval expression type expected.", operatorName));
    }

    public void requireArray(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isArray(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Array expression type expected.", operatorName));
    }

    public void requireMap(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isMap(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Array expression type expected.", operatorName));
    }

    public void requireInteger(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isInteger(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("Integer expression type expected.", operatorName));
    }

    public void requireList(GeneratedExpression genExpr, String operatorName) {
        if (TypeCheckUtils$.MODULE$.isList(genExpr.resultType())) {
            return;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenOperatorParamError("List expression type expected.", operatorName));
    }

    public GeneratedExpression generateNullLiteral(InternalType resultType2, boolean nullCheck) {
        String defaultValue = this.primitiveDefaultValue(resultType2);
        String resultTypeTerm = this.primitiveTypeTermForType(resultType2);
        if (nullCheck) {
            return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ")", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTypeTerm, defaultValue})), "true", "", resultType2, true, GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new CodeGenException("Null literals are not allowed if nullCheck is disabled.");
    }

    public GeneratedExpression generateNonNullLiteral(InternalType literalType, String literalCode, Object literalValue, boolean nullCheck) {
        String resultTypeTerm = this.primitiveTypeTermForType(literalType);
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ")", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTypeTerm, literalCode})), "false", "", literalType, true, literalValue, GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateLiteral(CodeGeneratorContext ctx, RelDataType literalRelDataType, InternalType literalInternalType, Object literalValue, boolean nullCheck) {
        SqlTypeName sqlTypeName;
        block21: {
            scala.math.BigDecimal decimal;
            block22: {
                GeneratedExpression generatedExpression;
                block5: {
                    block19: {
                        scala.math.BigDecimal decimal2;
                        block20: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block9: {
                                                                    block8: {
                                                                        block7: {
                                                                            block6: {
                                                                                block4: {
                                                                                    if (literalValue == null) {
                                                                                        return this.generateNullLiteral(literalInternalType, nullCheck);
                                                                                    }
                                                                                    sqlTypeName = literalRelDataType.getSqlTypeName();
                                                                                    if (!((Object)((Object)SqlTypeName.BOOLEAN)).equals((Object)sqlTypeName)) break block4;
                                                                                    generatedExpression = this.generateNonNullLiteral(literalInternalType, literalValue.toString(), literalValue, nullCheck);
                                                                                    break block5;
                                                                                }
                                                                                if (!((Object)((Object)SqlTypeName.TINYINT)).equals((Object)sqlTypeName)) break block6;
                                                                                scala.math.BigDecimal decimal3 = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                                                                                generatedExpression = this.generateNonNullLiteral(literalInternalType, ((Object)BoxesRunTime.boxToByte((byte)decimal3.byteValue())).toString(), BoxesRunTime.boxToByte((byte)decimal3.byteValue()), nullCheck);
                                                                                break block5;
                                                                            }
                                                                            if (!((Object)((Object)SqlTypeName.SMALLINT)).equals((Object)sqlTypeName)) break block7;
                                                                            scala.math.BigDecimal decimal4 = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                                                                            generatedExpression = this.generateNonNullLiteral(literalInternalType, ((Object)BoxesRunTime.boxToShort((short)decimal4.shortValue())).toString(), BoxesRunTime.boxToShort((short)decimal4.shortValue()), nullCheck);
                                                                            break block5;
                                                                        }
                                                                        if (!((Object)((Object)SqlTypeName.INTEGER)).equals((Object)sqlTypeName)) break block8;
                                                                        scala.math.BigDecimal decimal5 = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                                                                        generatedExpression = this.generateNonNullLiteral(literalInternalType, ((Object)BoxesRunTime.boxToInteger((int)decimal5.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal5.intValue()), nullCheck);
                                                                        break block5;
                                                                    }
                                                                    if (!((Object)((Object)SqlTypeName.BIGINT)).equals((Object)sqlTypeName)) break block9;
                                                                    scala.math.BigDecimal decimal6 = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                                                                    generatedExpression = this.generateNonNullLiteral(literalInternalType, new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong((long)decimal6.longValue())).toString()).append((Object)"L").toString(), BoxesRunTime.boxToLong((long)decimal6.longValue()), nullCheck);
                                                                    break block5;
                                                                }
                                                                if (!((Object)((Object)SqlTypeName.FLOAT)).equals((Object)sqlTypeName)) break block10;
                                                                float floatValue = ((BigDecimal)literalValue).floatValue();
                                                                float f = floatValue;
                                                                GeneratedExpression generatedExpression2 = Float.NaN == f ? this.generateNonNullLiteral(literalInternalType, "java.lang.Float.NaN", BoxesRunTime.boxToFloat((float)Float.NaN), nullCheck) : (Float.NEGATIVE_INFINITY == f ? this.generateNonNullLiteral(literalInternalType, "java.lang.Float.NEGATIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY), nullCheck) : (Float.POSITIVE_INFINITY == f ? this.generateNonNullLiteral(literalInternalType, "java.lang.Float.POSITIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), nullCheck) : this.generateNonNullLiteral(literalInternalType, new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)floatValue)).toString()).append((Object)"f").toString(), BoxesRunTime.boxToFloat((float)floatValue), nullCheck)));
                                                                generatedExpression = generatedExpression2;
                                                                break block5;
                                                            }
                                                            if (!((Object)((Object)SqlTypeName.DOUBLE)).equals((Object)sqlTypeName)) break block11;
                                                            double doubleValue = ((BigDecimal)literalValue).doubleValue();
                                                            double d = doubleValue;
                                                            GeneratedExpression generatedExpression3 = Double.NaN == d ? this.generateNonNullLiteral(literalInternalType, "java.lang.Double.NaN", BoxesRunTime.boxToDouble((double)Double.NaN), nullCheck) : (Double.NEGATIVE_INFINITY == d ? this.generateNonNullLiteral(literalInternalType, "java.lang.Double.NEGATIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY), nullCheck) : (Double.POSITIVE_INFINITY == d ? this.generateNonNullLiteral(literalInternalType, "java.lang.Double.POSITIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), nullCheck) : this.generateNonNullLiteral(literalInternalType, new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)doubleValue)).toString()).append((Object)"d").toString(), BoxesRunTime.boxToDouble((double)doubleValue), nullCheck)));
                                                            generatedExpression = generatedExpression3;
                                                            break block5;
                                                        }
                                                        if (!((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName)) break block12;
                                                        int precision = literalRelDataType.getPrecision();
                                                        int scale = literalRelDataType.getScale();
                                                        String fieldTerm = this.newName("decimal");
                                                        String fieldDecimal = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " =\n             |    ", "(\"", "\", ", ", ", ");\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.class.getCanonicalName(), fieldTerm, Decimal.Ref.castFrom(), literalValue.toString(), BoxesRunTime.boxToInteger((int)precision), BoxesRunTime.boxToInteger((int)scale)})))).stripMargin();
                                                        ctx.addReusableMember(fieldDecimal, ctx.addReusableMember$default$2());
                                                        generatedExpression = this.generateNonNullLiteral(literalInternalType, fieldTerm, Decimal.fromBigDecimal((BigDecimal)literalValue, precision, scale), nullCheck);
                                                        break block5;
                                                    }
                                                    boolean bl = ((Object)((Object)SqlTypeName.VARCHAR)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.CHAR)).equals((Object)sqlTypeName);
                                                    if (!bl) break block13;
                                                    String escapedValue = StringEscapeUtils.escapeJava((String)StringEscapeUtils.unescapeJava((String)literalValue.toString()));
                                                    String field = ctx.addReusableStringConstants(escapedValue);
                                                    generatedExpression = this.generateNonNullLiteral(literalInternalType, field, BinaryString.fromString(escapedValue), nullCheck);
                                                    break block5;
                                                }
                                                boolean bl = ((Object)((Object)SqlTypeName.VARBINARY)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.BINARY)).equals((Object)sqlTypeName);
                                                if (!bl) break block14;
                                                byte[] bytesVal = ((ByteString)literalValue).getBytes();
                                                String fieldTerm = ctx.addReusableObject(bytesVal, "binary", bytesVal.getClass().getCanonicalName());
                                                generatedExpression = this.generateNonNullLiteral(literalInternalType, fieldTerm, BinaryString.fromBytes(bytesVal), nullCheck);
                                                break block5;
                                            }
                                            if (!((Object)((Object)SqlTypeName.SYMBOL)).equals((Object)sqlTypeName)) break block15;
                                            generatedExpression = this.generateSymbol((Enum)literalValue);
                                            break block5;
                                        }
                                        if (!((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName)) break block16;
                                        generatedExpression = this.generateNonNullLiteral(literalInternalType, literalValue.toString(), literalValue, nullCheck);
                                        break block5;
                                    }
                                    if (!((Object)((Object)SqlTypeName.TIME)).equals((Object)sqlTypeName)) break block17;
                                    generatedExpression = this.generateNonNullLiteral(literalInternalType, literalValue.toString(), literalValue, nullCheck);
                                    break block5;
                                }
                                if (!((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName)) break block18;
                                long millis = BoxesRunTime.unboxToLong((Object)literalValue);
                                long adjustedValue = DateTimeFunctions$.MODULE$.utcTsToTzTs(millis, ctx.getTableConfig().getTimeZone());
                                generatedExpression = this.generateNonNullLiteral(literalInternalType, new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong((long)adjustedValue)).toString()).append((Object)"L").toString(), literalValue, nullCheck);
                                break block5;
                            }
                            if (!SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block19;
                            decimal2 = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                            if (!decimal2.isValidInt()) break block20;
                            generatedExpression = this.generateNonNullLiteral(literalInternalType, ((Object)BoxesRunTime.boxToInteger((int)decimal2.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal2.intValue()), nullCheck);
                            break block5;
                        }
                        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decimal '", "' can not be converted to interval of months."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal2})));
                    }
                    if (!SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block21;
                    decimal = package$.MODULE$.BigDecimal().apply((BigDecimal)literalValue);
                    if (!decimal.isValidLong()) break block22;
                    generatedExpression = this.generateNonNullLiteral(literalInternalType, new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong((long)decimal.longValue())).toString()).append((Object)"L").toString(), BoxesRunTime.boxToLong((long)decimal.longValue()), nullCheck);
                }
                return generatedExpression;
            }
            throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decimal '", "' can not be converted to interval of milliseconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal})));
        }
        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName})));
    }

    public GeneratedExpression generateNonNullField(InternalType t, String code, boolean nullCheck) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ") ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.primitiveTypeTermForType(t), code})), "false", "", t, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateSymbol(Enum<?> enum_) {
        return new GeneratedExpression(this.qualifyEnum(enum_), "false", "", new GenericType(enum_.getDeclaringClass()), GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateProctimeTimestamp(String contextTerm, CodeGeneratorContext ctx) {
        String resultTerm = ctx.newReusableField("result", "long");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " = ", ".timerService().currentProcessingTime();\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, contextTerm})))).stripMargin().trim();
        return new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), resultCode, DataTypes.TIMESTAMP, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateCurrentTimestamp(CodeGeneratorContext ctx) {
        return new CurrentTimePointCallGen(false).generate(ctx, "CurrentTimestamp", (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), DataTypes.TIMESTAMP, false);
    }

    public GeneratedExpression generateRowtimeAccess(String contextTerm, CodeGeneratorContext ctx) {
        Seq<String> seq = ctx.newReusableFields((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Long", "boolean"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " = ", ".timestamp();\n         |if (", " == null) {\n         |  throw new RuntimeException(\"Rowtime timestamp is null. Please make sure that a \" +\n         |    \"proper TimestampAssigner is defined and the stream environment uses the EventTime \" +\n         |    \"time characteristic.\");\n         |}\n         |", " = false;\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm2, contextTerm, resultTerm2, nullTerm2})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, DataTypes.ROWTIME_INDICATOR, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateInputAccess(CodeGeneratorContext ctx, InternalType inputType, String inputTerm, int index, boolean nullableInput, boolean nullCheck, boolean fieldCopy) {
        Option<GeneratedExpression> option;
        block4: {
            GeneratedExpression generatedExpression;
            block3: {
                block2: {
                    GeneratedExpression expr;
                    option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    generatedExpression = expr = (GeneratedExpression)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                GeneratedExpression expr = nullableInput ? this.generateNullableInputFieldAccess(ctx, inputType, inputTerm, index, nullCheck, fieldCopy) : this.generateFieldAccess(ctx, inputType, inputTerm, index, nullCheck, fieldCopy);
                ctx.addReusableInputUnboxingExprs(inputTerm, index, expr);
                generatedExpression = expr;
            }
            GeneratedExpression inputExpr = generatedExpression;
            return new GeneratedExpression(inputExpr.resultTerm(), inputExpr.nullTerm(), "", inputExpr.resultType(), GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(option);
    }

    public boolean generateInputAccess$default$7() {
        return false;
    }

    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, InternalType inputType, String inputTerm, int index, boolean nullCheck, boolean fieldCopy) {
        GeneratedExpression expr = this.generateFieldAccess(ctx, inputType, inputTerm, index, nullCheck);
        return fieldCopy ? expr.copyResultIfNeeded(ctx, fieldCopy) : expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, InternalType inputType, String inputTerm, int index, boolean nullCheck) {
        InternalType internalType = inputType;
        if (internalType instanceof RowType) {
            Tuple2 tuple2;
            RowType rowType = (RowType)internalType;
            InternalType fieldType = rowType.getFieldTypes()[index].toInternalType();
            String resultTypeTerm = this.primitiveTypeTermForType(fieldType);
            String defaultValue = this.primitiveDefaultValue(fieldType);
            String readCode = this.baseRowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)index)).toString(), inputTerm, fieldType, this.baseRowFieldReadAccess$default$5());
            Seq<String> seq = ctx.newReusableFields((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"field", "isNull"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resultTypeTerm, "boolean"}))));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty()) throw new MatchError(seq);
            if (some.get() == null) throw new MatchError(seq);
            if (((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError(seq);
            String fieldTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fieldTerm, (Object)nullTerm);
            String fieldTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String inputCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " = ", ".isNullAt(", ");\n             |", " = ", ";\n             |if (!", ") {\n             |  ", " = ", ";\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nullTerm2, inputTerm, BoxesRunTime.boxToInteger((int)index), fieldTerm2, defaultValue, nullTerm2, fieldTerm2, readCode})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " = false;\n             |", " = ", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nullTerm2, fieldTerm2, readCode})))).stripMargin();
            return new GeneratedExpression(fieldTerm2, nullTerm2, inputCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        String fieldTypeTerm = this.boxedTypeTermForType(inputType);
        String inputCode = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldTypeTerm, inputTerm}));
        return this.generateInputFieldUnboxing(inputType, inputCode, nullCheck, ctx);
    }

    public GeneratedExpression generateNullableInputFieldAccess(CodeGeneratorContext ctx, InternalType inputType, String inputTerm, int index, boolean nullCheck, boolean fieldCopy) {
        InternalType internalType;
        InternalType internalType2 = inputType;
        if (internalType2 instanceof RowType) {
            RowType rowType = (RowType)internalType2;
            internalType = rowType.getFieldTypes()[index].toInternalType();
        } else {
            internalType = inputType;
        }
        InternalType fieldType = internalType;
        String resultTypeTerm = this.primitiveTypeTermForType(fieldType);
        String defaultValue = this.primitiveDefaultValue(fieldType);
        Seq<String> seq = ctx.newReusableFields((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resultTypeTerm, "boolean"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            GeneratedExpression fieldAccessExpr = this.generateFieldAccess(ctx, inputType, inputTerm, index, nullCheck, fieldCopy);
            String inputCheckCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " = ", ";\n         |", " = true;\n         |if (", " != null) {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm2, defaultValue, nullTerm2, inputTerm, fieldAccessExpr.code(), resultTerm2, fieldAccessExpr.resultTerm(), nullTerm2, fieldAccessExpr.nullTerm()})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, inputCheckCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public boolean generateNullableInputFieldAccess$default$6() {
        return false;
    }

    public GeneratedExpression generateInputFieldUnboxing(InternalType fieldType, String fieldTerm, boolean nullCheck, CodeGeneratorContext ctx) {
        String resultTypeTerm = this.primitiveTypeTermForType(fieldType);
        String defaultValue = this.primitiveDefaultValue(fieldType);
        Seq<String> seq = ctx.newReusableFields((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resultTypeTerm, "boolean"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String wrappedCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " = ", " == null;\n         |", " = ", ";\n         |if (!", ") {\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nullTerm2, fieldTerm, resultTerm2, defaultValue, nullTerm2, resultTerm2, fieldTerm})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " = ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm2, fieldTerm})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, wrappedCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateCallExpression(CodeGeneratorContext ctx, SqlOperator operator, Seq<GeneratedExpression> operands, InternalType resultType2, boolean nullCheck) {
        SqlOperator sqlOperator;
        block60: {
            GeneratedExpression generatedExpression;
            block10: {
                String operatorName;
                block59: {
                    block58: {
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        block50: {
                                            block53: {
                                                GeneratedExpression generatedExpression2;
                                                block52: {
                                                    InternalType internalType;
                                                    InternalType internalType2;
                                                    block51: {
                                                        InternalType internalType3;
                                                        block46: {
                                                            block49: {
                                                                GeneratedExpression generatedExpression3;
                                                                block48: {
                                                                    InternalType internalType4;
                                                                    InternalType internalType5;
                                                                    block47: {
                                                                        InternalType internalType6;
                                                                        block45: {
                                                                            block44: {
                                                                                block43: {
                                                                                    block42: {
                                                                                        block41: {
                                                                                            block40: {
                                                                                                block39: {
                                                                                                    block38: {
                                                                                                        block37: {
                                                                                                            block36: {
                                                                                                                block35: {
                                                                                                                    block34: {
                                                                                                                        block33: {
                                                                                                                            block32: {
                                                                                                                                block31: {
                                                                                                                                    block30: {
                                                                                                                                        block29: {
                                                                                                                                            block28: {
                                                                                                                                                block27: {
                                                                                                                                                    block26: {
                                                                                                                                                        block25: {
                                                                                                                                                            block24: {
                                                                                                                                                                block23: {
                                                                                                                                                                    block22: {
                                                                                                                                                                        block21: {
                                                                                                                                                                            boolean bl;
                                                                                                                                                                            block20: {
                                                                                                                                                                                SqlOperator sqlOperator2;
                                                                                                                                                                                block19: {
                                                                                                                                                                                    boolean bl2;
                                                                                                                                                                                    block18: {
                                                                                                                                                                                        SqlOperator sqlOperator3;
                                                                                                                                                                                        block17: {
                                                                                                                                                                                            block16: {
                                                                                                                                                                                                boolean bl3;
                                                                                                                                                                                                block15: {
                                                                                                                                                                                                    boolean bl4;
                                                                                                                                                                                                    block14: {
                                                                                                                                                                                                        SqlOperator sqlOperator4;
                                                                                                                                                                                                        block13: {
                                                                                                                                                                                                            boolean bl5;
                                                                                                                                                                                                            block12: {
                                                                                                                                                                                                                block11: {
                                                                                                                                                                                                                    boolean bl6;
                                                                                                                                                                                                                    block9: {
                                                                                                                                                                                                                        operatorName = operator.getName();
                                                                                                                                                                                                                        bl4 = false;
                                                                                                                                                                                                                        sqlOperator4 = null;
                                                                                                                                                                                                                        bl2 = false;
                                                                                                                                                                                                                        sqlOperator3 = null;
                                                                                                                                                                                                                        bl = false;
                                                                                                                                                                                                                        sqlOperator2 = null;
                                                                                                                                                                                                                        sqlOperator = operator;
                                                                                                                                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.PLUS;
                                                                                                                                                                                                                        SqlOperator sqlOperator5 = sqlOperator;
                                                                                                                                                                                                                        if ((sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator5) : sqlOperator5 != null) || !TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block9;
                                                                                                                                                                                                                        GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                                        GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                                        this.requireNumeric(left, operatorName);
                                                                                                                                                                                                                        this.requireNumeric(right, operatorName);
                                                                                                                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "+", nullCheck, resultType2, left, right);
                                                                                                                                                                                                                        break block10;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.PLUS;
                                                                                                                                                                                                                    SqlOperator sqlOperator6 = sqlOperator;
                                                                                                                                                                                                                    if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator6) : sqlOperator6 != null)) {
                                                                                                                                                                                                                        bl6 = true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        SqlSpecialOperator sqlSpecialOperator = SqlStdOperatorTable.DATETIME_PLUS;
                                                                                                                                                                                                                        SqlOperator sqlOperator7 = sqlOperator;
                                                                                                                                                                                                                        bl6 = !(sqlSpecialOperator != null ? !((Object)sqlSpecialOperator).equals(sqlOperator7) : sqlOperator7 != null);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!bl6 || !TypeCheckUtils$.MODULE$.isTemporal(resultType2)) break block11;
                                                                                                                                                                                                                    GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                                    GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                                    this.requireTemporal(left, operatorName);
                                                                                                                                                                                                                    this.requireTemporal(right, operatorName);
                                                                                                                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateTemporalPlusMinus(ctx, operatorName, true, nullCheck, resultType2, left, right);
                                                                                                                                                                                                                    break block10;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.MINUS;
                                                                                                                                                                                                                SqlOperator sqlOperator8 = sqlOperator;
                                                                                                                                                                                                                if ((sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator8) : sqlOperator8 != null) || !TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block12;
                                                                                                                                                                                                                GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                                GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                                this.requireNumeric(left, operatorName);
                                                                                                                                                                                                                this.requireNumeric(right, operatorName);
                                                                                                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "-", nullCheck, resultType2, left, right);
                                                                                                                                                                                                                break block10;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.MINUS;
                                                                                                                                                                                                            SqlOperator sqlOperator9 = sqlOperator;
                                                                                                                                                                                                            if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator9) : sqlOperator9 != null)) {
                                                                                                                                                                                                                bl5 = true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                SqlDatetimeSubtractionOperator sqlDatetimeSubtractionOperator = SqlStdOperatorTable.MINUS_DATE;
                                                                                                                                                                                                                SqlOperator sqlOperator10 = sqlOperator;
                                                                                                                                                                                                                bl5 = !(sqlDatetimeSubtractionOperator != null ? !((Object)sqlDatetimeSubtractionOperator).equals(sqlOperator10) : sqlOperator10 != null);
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!bl5 || !TypeCheckUtils$.MODULE$.isTemporal(resultType2)) break block13;
                                                                                                                                                                                                            GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                            GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                            this.requireTemporal(left, operatorName);
                                                                                                                                                                                                            this.requireTemporal(right, operatorName);
                                                                                                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateTemporalPlusMinus(ctx, operatorName, false, nullCheck, resultType2, left, right);
                                                                                                                                                                                                            break block10;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.MULTIPLY;
                                                                                                                                                                                                        SqlOperator sqlOperator11 = sqlOperator;
                                                                                                                                                                                                        if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator11) : sqlOperator11 != null) break block14;
                                                                                                                                                                                                        bl4 = true;
                                                                                                                                                                                                        sqlOperator4 = sqlOperator;
                                                                                                                                                                                                        if (!TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block14;
                                                                                                                                                                                                        GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                        GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                        this.requireNumeric(left, operatorName);
                                                                                                                                                                                                        this.requireNumeric(right, operatorName);
                                                                                                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "*", nullCheck, resultType2, left, right);
                                                                                                                                                                                                        break block10;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (!bl4 || !TypeCheckUtils$.MODULE$.isTimeInterval(resultType2)) break block15;
                                                                                                                                                                                                    GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                    GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                    this.requireTimeInterval(left, operatorName);
                                                                                                                                                                                                    this.requireNumeric(right, operatorName);
                                                                                                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "*", nullCheck, resultType2, left, right);
                                                                                                                                                                                                    break block10;
                                                                                                                                                                                                }
                                                                                                                                                                                                SqlBinaryOperator sqlBinaryOperator = ScalarSqlFunctions$.MODULE$.DIVIDE();
                                                                                                                                                                                                SqlOperator sqlOperator12 = sqlOperator;
                                                                                                                                                                                                if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator12) : sqlOperator12 != null)) {
                                                                                                                                                                                                    bl3 = true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.DIVIDE_INTEGER;
                                                                                                                                                                                                    SqlOperator sqlOperator13 = sqlOperator;
                                                                                                                                                                                                    bl3 = !(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator13) : sqlOperator13 != null);
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!bl3 || !TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block16;
                                                                                                                                                                                                GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                                GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                                this.requireNumeric(left, operatorName);
                                                                                                                                                                                                this.requireNumeric(right, operatorName);
                                                                                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "/", nullCheck, resultType2, left, right);
                                                                                                                                                                                                break block10;
                                                                                                                                                                                            }
                                                                                                                                                                                            SqlFunction sqlFunction = SqlStdOperatorTable.MOD;
                                                                                                                                                                                            SqlOperator sqlOperator14 = sqlOperator;
                                                                                                                                                                                            if ((sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator14) : sqlOperator14 != null) || !TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block17;
                                                                                                                                                                                            GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                                            GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                                            this.requireNumeric(left, operatorName);
                                                                                                                                                                                            this.requireNumeric(right, operatorName);
                                                                                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateArithmeticOperator(ctx, "%", nullCheck, resultType2, left, right);
                                                                                                                                                                                            break block10;
                                                                                                                                                                                        }
                                                                                                                                                                                        SqlPrefixOperator sqlPrefixOperator = SqlStdOperatorTable.UNARY_MINUS;
                                                                                                                                                                                        SqlOperator sqlOperator15 = sqlOperator;
                                                                                                                                                                                        if (sqlPrefixOperator != null ? !((Object)sqlPrefixOperator).equals(sqlOperator15) : sqlOperator15 != null) break block18;
                                                                                                                                                                                        bl2 = true;
                                                                                                                                                                                        sqlOperator3 = sqlOperator;
                                                                                                                                                                                        if (!TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block18;
                                                                                                                                                                                        GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                                                                        this.requireNumeric(operand, operatorName);
                                                                                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateUnaryArithmeticOperator(ctx, "-", nullCheck, resultType2, operand);
                                                                                                                                                                                        break block10;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!bl2 || !TypeCheckUtils$.MODULE$.isTimeInterval(resultType2)) break block19;
                                                                                                                                                                                    GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                                                                    this.requireTimeInterval(operand, operatorName);
                                                                                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateUnaryIntervalPlusMinus(ctx, false, nullCheck, operand);
                                                                                                                                                                                    break block10;
                                                                                                                                                                                }
                                                                                                                                                                                SqlPrefixOperator sqlPrefixOperator = SqlStdOperatorTable.UNARY_PLUS;
                                                                                                                                                                                SqlOperator sqlOperator16 = sqlOperator;
                                                                                                                                                                                if (sqlPrefixOperator != null ? !((Object)sqlPrefixOperator).equals(sqlOperator16) : sqlOperator16 != null) break block20;
                                                                                                                                                                                bl = true;
                                                                                                                                                                                sqlOperator2 = sqlOperator;
                                                                                                                                                                                if (!TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block20;
                                                                                                                                                                                GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                                                                this.requireNumeric(operand, operatorName);
                                                                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateUnaryArithmeticOperator(ctx, "+", nullCheck, resultType2, operand);
                                                                                                                                                                                break block10;
                                                                                                                                                                            }
                                                                                                                                                                            if (!bl || !TypeCheckUtils$.MODULE$.isTimeInterval(resultType2)) break block21;
                                                                                                                                                                            GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                                                            this.requireTimeInterval(operand, operatorName);
                                                                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateUnaryIntervalPlusMinus(ctx, true, nullCheck, operand);
                                                                                                                                                                            break block10;
                                                                                                                                                                        }
                                                                                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.EQUALS;
                                                                                                                                                                        SqlOperator sqlOperator17 = sqlOperator;
                                                                                                                                                                        if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator17) : sqlOperator17 != null) break block22;
                                                                                                                                                                        GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                        GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateEquals(ctx, operatorName, nullCheck, left, right);
                                                                                                                                                                        break block10;
                                                                                                                                                                    }
                                                                                                                                                                    SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.NOT_EQUALS;
                                                                                                                                                                    SqlOperator sqlOperator18 = sqlOperator;
                                                                                                                                                                    if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator18) : sqlOperator18 != null) break block23;
                                                                                                                                                                    GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                    GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateNotEquals(ctx, operatorName, nullCheck, left, right);
                                                                                                                                                                    break block10;
                                                                                                                                                                }
                                                                                                                                                                SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.GREATER_THAN;
                                                                                                                                                                SqlOperator sqlOperator19 = sqlOperator;
                                                                                                                                                                if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator19) : sqlOperator19 != null) break block24;
                                                                                                                                                                GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                                GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                                this.requireComparable(left, operatorName);
                                                                                                                                                                this.requireComparable(right, operatorName);
                                                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateComparison(ctx, ">", nullCheck, left, right);
                                                                                                                                                                break block10;
                                                                                                                                                            }
                                                                                                                                                            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                                                                                                                                                            SqlOperator sqlOperator20 = sqlOperator;
                                                                                                                                                            if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator20) : sqlOperator20 != null) break block25;
                                                                                                                                                            GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                            GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                            this.requireComparable(left, operatorName);
                                                                                                                                                            this.requireComparable(right, operatorName);
                                                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateComparison(ctx, ">=", nullCheck, left, right);
                                                                                                                                                            break block10;
                                                                                                                                                        }
                                                                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.LESS_THAN;
                                                                                                                                                        SqlOperator sqlOperator21 = sqlOperator;
                                                                                                                                                        if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator21) : sqlOperator21 != null) break block26;
                                                                                                                                                        GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                        GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                        this.requireComparable(left, operatorName);
                                                                                                                                                        this.requireComparable(right, operatorName);
                                                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateComparison(ctx, "<", nullCheck, left, right);
                                                                                                                                                        break block10;
                                                                                                                                                    }
                                                                                                                                                    SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                                                                                                                                                    SqlOperator sqlOperator22 = sqlOperator;
                                                                                                                                                    if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator22) : sqlOperator22 != null) break block27;
                                                                                                                                                    GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                                                                    GeneratedExpression right = (GeneratedExpression)operands.apply(1);
                                                                                                                                                    this.requireComparable(left, operatorName);
                                                                                                                                                    this.requireComparable(right, operatorName);
                                                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateComparison(ctx, "<=", nullCheck, left, right);
                                                                                                                                                    break block10;
                                                                                                                                                }
                                                                                                                                                SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_NULL;
                                                                                                                                                SqlOperator sqlOperator23 = sqlOperator;
                                                                                                                                                if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator23) : sqlOperator23 != null) break block28;
                                                                                                                                                GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateIsNull(nullCheck, operand);
                                                                                                                                                break block10;
                                                                                                                                            }
                                                                                                                                            SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_NOT_NULL;
                                                                                                                                            SqlOperator sqlOperator24 = sqlOperator;
                                                                                                                                            if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator24) : sqlOperator24 != null) break block29;
                                                                                                                                            GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateIsNotNull(nullCheck, operand);
                                                                                                                                            break block10;
                                                                                                                                        }
                                                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.AND;
                                                                                                                                        SqlOperator sqlOperator25 = sqlOperator;
                                                                                                                                        if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator25) : sqlOperator25 != null) break block30;
                                                                                                                                        generatedExpression = (GeneratedExpression)operands.reduceLeft((Function2)new Serializable(nullCheck, operatorName){
                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                            private final boolean nullCheck$1;
                                                                                                                                            private final String operatorName$1;

                                                                                                                                            public final GeneratedExpression apply(GeneratedExpression left, GeneratedExpression right) {
                                                                                                                                                CodeGenUtils$.MODULE$.requireBoolean(left, this.operatorName$1);
                                                                                                                                                CodeGenUtils$.MODULE$.requireBoolean(right, this.operatorName$1);
                                                                                                                                                return ScalarOperators$.MODULE$.generateAnd(this.nullCheck$1, left, right);
                                                                                                                                            }
                                                                                                                                            {
                                                                                                                                                this.nullCheck$1 = nullCheck$1;
                                                                                                                                                this.operatorName$1 = operatorName$1;
                                                                                                                                            }
                                                                                                                                        });
                                                                                                                                        break block10;
                                                                                                                                    }
                                                                                                                                    SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
                                                                                                                                    SqlOperator sqlOperator26 = sqlOperator;
                                                                                                                                    if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator26) : sqlOperator26 != null) break block31;
                                                                                                                                    generatedExpression = (GeneratedExpression)operands.reduceLeft((Function2)new Serializable(nullCheck, operatorName){
                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                        private final boolean nullCheck$1;
                                                                                                                                        private final String operatorName$1;

                                                                                                                                        public final GeneratedExpression apply(GeneratedExpression left, GeneratedExpression right) {
                                                                                                                                            CodeGenUtils$.MODULE$.requireBoolean(left, this.operatorName$1);
                                                                                                                                            CodeGenUtils$.MODULE$.requireBoolean(right, this.operatorName$1);
                                                                                                                                            return ScalarOperators$.MODULE$.generateOr(this.nullCheck$1, left, right);
                                                                                                                                        }
                                                                                                                                        {
                                                                                                                                            this.nullCheck$1 = nullCheck$1;
                                                                                                                                            this.operatorName$1 = operatorName$1;
                                                                                                                                        }
                                                                                                                                    });
                                                                                                                                    break block10;
                                                                                                                                }
                                                                                                                                SqlPrefixOperator sqlPrefixOperator = SqlStdOperatorTable.NOT;
                                                                                                                                SqlOperator sqlOperator27 = sqlOperator;
                                                                                                                                if (sqlPrefixOperator != null ? !((Object)sqlPrefixOperator).equals(sqlOperator27) : sqlOperator27 != null) break block32;
                                                                                                                                GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                                this.requireBoolean(operand, operatorName);
                                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateNot(ctx, operatorName, nullCheck, operand);
                                                                                                                                break block10;
                                                                                                                            }
                                                                                                                            SqlCaseOperator sqlCaseOperator = SqlStdOperatorTable.CASE;
                                                                                                                            SqlOperator sqlOperator28 = sqlOperator;
                                                                                                                            if (sqlCaseOperator != null ? !((Object)sqlCaseOperator).equals(sqlOperator28) : sqlOperator28 != null) break block33;
                                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateIfElse(ctx, operatorName, nullCheck, operands, resultType2, ScalarOperators$.MODULE$.generateIfElse$default$6());
                                                                                                                            break block10;
                                                                                                                        }
                                                                                                                        SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_TRUE;
                                                                                                                        SqlOperator sqlOperator29 = sqlOperator;
                                                                                                                        if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator29) : sqlOperator29 != null) break block34;
                                                                                                                        GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                        this.requireBoolean(operand, operatorName);
                                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateIsTrue(operand);
                                                                                                                        break block10;
                                                                                                                    }
                                                                                                                    SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_NOT_TRUE;
                                                                                                                    SqlOperator sqlOperator30 = sqlOperator;
                                                                                                                    if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator30) : sqlOperator30 != null) break block35;
                                                                                                                    GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                    this.requireBoolean(operand, operatorName);
                                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateIsNotTrue(operand);
                                                                                                                    break block10;
                                                                                                                }
                                                                                                                SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_FALSE;
                                                                                                                SqlOperator sqlOperator31 = sqlOperator;
                                                                                                                if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator31) : sqlOperator31 != null) break block36;
                                                                                                                GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                                this.requireBoolean(operand, operatorName);
                                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateIsFalse(operand);
                                                                                                                break block10;
                                                                                                            }
                                                                                                            SqlPostfixOperator sqlPostfixOperator = SqlStdOperatorTable.IS_NOT_FALSE;
                                                                                                            SqlOperator sqlOperator32 = sqlOperator;
                                                                                                            if (sqlPostfixOperator != null ? !((Object)sqlPostfixOperator).equals(sqlOperator32) : sqlOperator32 != null) break block37;
                                                                                                            GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                            this.requireBoolean(operand, operatorName);
                                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateIsNotFalse(operand);
                                                                                                            break block10;
                                                                                                        }
                                                                                                        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.IN;
                                                                                                        SqlOperator sqlOperator33 = sqlOperator;
                                                                                                        if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator33) : sqlOperator33 != null) break block38;
                                                                                                        GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                        Seq right = (Seq)operands.tail();
                                                                                                        generatedExpression = ScalarOperators$.MODULE$.generateIn(ctx, operatorName, left, (Seq<GeneratedExpression>)right, nullCheck);
                                                                                                        break block10;
                                                                                                    }
                                                                                                    SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.NOT_IN;
                                                                                                    SqlOperator sqlOperator34 = sqlOperator;
                                                                                                    if (sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator34) : sqlOperator34 != null) break block39;
                                                                                                    GeneratedExpression left = (GeneratedExpression)operands.head();
                                                                                                    Seq right = (Seq)operands.tail();
                                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateNot(ctx, operatorName, nullCheck, ScalarOperators$.MODULE$.generateIn(ctx, operatorName, left, (Seq<GeneratedExpression>)right, nullCheck));
                                                                                                    break block10;
                                                                                                }
                                                                                                SqlFunction sqlFunction = SqlStdOperatorTable.CAST;
                                                                                                SqlOperator sqlOperator35 = sqlOperator;
                                                                                                if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator35) : sqlOperator35 != null) break block40;
                                                                                                GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                                generatedExpression = ScalarOperators$.MODULE$.generateCast(ctx, operatorName, nullCheck, operand, resultType2);
                                                                                                break block10;
                                                                                            }
                                                                                            SqlSpecialOperator sqlSpecialOperator = SqlStdOperatorTable.REINTERPRET;
                                                                                            SqlOperator sqlOperator36 = sqlOperator;
                                                                                            if (sqlSpecialOperator != null ? !((Object)sqlSpecialOperator).equals(sqlOperator36) : sqlOperator36 != null) break block41;
                                                                                            GeneratedExpression operand = (GeneratedExpression)operands.head();
                                                                                            generatedExpression = ScalarOperators$.MODULE$.generateReinterpret(ctx, operatorName, nullCheck, operand, resultType2);
                                                                                            break block10;
                                                                                        }
                                                                                        SqlAsOperator sqlAsOperator = SqlStdOperatorTable.AS;
                                                                                        SqlOperator sqlOperator37 = sqlOperator;
                                                                                        if (sqlAsOperator != null ? !((Object)sqlAsOperator).equals(sqlOperator37) : sqlOperator37 != null) break block42;
                                                                                        generatedExpression = (GeneratedExpression)operands.head();
                                                                                        break block10;
                                                                                    }
                                                                                    SqlRowOperator sqlRowOperator = SqlStdOperatorTable.ROW;
                                                                                    SqlOperator sqlOperator38 = sqlOperator;
                                                                                    if (sqlRowOperator != null ? !((Object)sqlRowOperator).equals(sqlOperator38) : sqlOperator38 != null) break block43;
                                                                                    generatedExpression = ScalarOperators$.MODULE$.generateRow(ctx, resultType2, operands, nullCheck);
                                                                                    break block10;
                                                                                }
                                                                                SqlArrayValueConstructor sqlArrayValueConstructor = SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR;
                                                                                SqlOperator sqlOperator39 = sqlOperator;
                                                                                if (sqlArrayValueConstructor != null ? !((Object)sqlArrayValueConstructor).equals(sqlOperator39) : sqlOperator39 != null) break block44;
                                                                                generatedExpression = ScalarOperators$.MODULE$.generateArray(ctx, resultType2, operands, nullCheck);
                                                                                break block10;
                                                                            }
                                                                            SqlMapValueConstructor sqlMapValueConstructor = SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR;
                                                                            SqlOperator sqlOperator40 = sqlOperator;
                                                                            if (sqlMapValueConstructor != null ? !((Object)sqlMapValueConstructor).equals(sqlOperator40) : sqlOperator40 != null) break block45;
                                                                            generatedExpression = ScalarOperators$.MODULE$.generateMap(ctx, resultType2, operands, nullCheck);
                                                                            break block10;
                                                                        }
                                                                        SqlOperator sqlOperator41 = SqlStdOperatorTable.ITEM;
                                                                        SqlOperator sqlOperator42 = sqlOperator;
                                                                        if (sqlOperator41 != null ? !((Object)sqlOperator41).equals(sqlOperator42) : sqlOperator42 != null) break block46;
                                                                        internalType5 = ((GeneratedExpression)operands.head()).resultType();
                                                                        if (internalType5 == null || !TypeCheckUtils$.MODULE$.isArray(internalType6 = internalType5)) break block47;
                                                                        GeneratedExpression array2 = (GeneratedExpression)operands.head();
                                                                        GeneratedExpression index = (GeneratedExpression)operands.apply(1);
                                                                        this.requireInteger(index, operatorName);
                                                                        generatedExpression3 = ScalarOperators$.MODULE$.generateArrayElementAt(ctx, array2, index, nullCheck);
                                                                        break block48;
                                                                    }
                                                                    if (internalType5 == null || !TypeCheckUtils$.MODULE$.isMap(internalType4 = internalType5)) break block49;
                                                                    GeneratedExpression key = (GeneratedExpression)operands.apply(1);
                                                                    generatedExpression3 = ScalarOperators$.MODULE$.generateMapGet(ctx, operatorName, (GeneratedExpression)operands.head(), key, nullCheck);
                                                                }
                                                                generatedExpression = generatedExpression3;
                                                                break block10;
                                                            }
                                                            throw new CodeGenException("Expect an array or a map.");
                                                        }
                                                        SqlFunction sqlFunction = SqlStdOperatorTable.CARDINALITY;
                                                        SqlOperator sqlOperator43 = sqlOperator;
                                                        if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator43) : sqlOperator43 != null) break block50;
                                                        internalType2 = ((GeneratedExpression)operands.head()).resultType();
                                                        if (internalType2 == null || !TypeCheckUtils$.MODULE$.isArray(internalType3 = internalType2)) break block51;
                                                        GeneratedExpression array3 = (GeneratedExpression)operands.head();
                                                        generatedExpression2 = ScalarOperators$.MODULE$.generateArrayCardinality(ctx, operatorName, nullCheck, array3);
                                                        break block52;
                                                    }
                                                    if (internalType2 == null || !TypeCheckUtils$.MODULE$.isMap(internalType = internalType2)) break block53;
                                                    GeneratedExpression map2 = (GeneratedExpression)operands.head();
                                                    generatedExpression2 = ScalarOperators$.MODULE$.generateMapCardinality(ctx, operatorName, nullCheck, map2);
                                                }
                                                generatedExpression = generatedExpression2;
                                                break block10;
                                            }
                                            throw new CodeGenException("Expect an array or a map.");
                                        }
                                        SqlFunction sqlFunction = SqlStdOperatorTable.ELEMENT;
                                        SqlOperator sqlOperator44 = sqlOperator;
                                        if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator44) : sqlOperator44 != null) break block54;
                                        GeneratedExpression array4 = (GeneratedExpression)operands.head();
                                        this.requireArray(array4, operatorName);
                                        generatedExpression = ScalarOperators$.MODULE$.generateArrayElement(ctx, array4, nullCheck);
                                        break block10;
                                    }
                                    SqlOperator sqlOperator45 = SqlStdOperatorTable.DOT;
                                    SqlOperator sqlOperator46 = sqlOperator;
                                    if (sqlOperator45 != null ? !((Object)sqlOperator45).equals(sqlOperator46) : sqlOperator46 != null) break block55;
                                    generatedExpression = ScalarOperators$.MODULE$.generateDOT(ctx, operands, nullCheck);
                                    break block10;
                                }
                                if (!(sqlOperator instanceof SqlRuntimeFilterFunction)) break block56;
                                SqlRuntimeFilterFunction sqlRuntimeFilterFunction = (SqlRuntimeFilterFunction)sqlOperator;
                                generatedExpression = ScalarOperators$.MODULE$.generateRuntimeFilter(ctx, operands, sqlRuntimeFilterFunction);
                                break block10;
                            }
                            if (!(sqlOperator instanceof SqlRuntimeFilterBuilderFunction)) break block57;
                            SqlRuntimeFilterBuilderFunction sqlRuntimeFilterBuilderFunction = (SqlRuntimeFilterBuilderFunction)sqlOperator;
                            generatedExpression = ScalarOperators$.MODULE$.generateRuntimeFilterBuilder(ctx, operands, sqlRuntimeFilterBuilderFunction);
                            break block10;
                        }
                        if (!(sqlOperator instanceof SqlThrowExceptionFunction)) break block58;
                        GeneratedExpression nullValue = this.generateNullLiteral(resultType2, nullCheck);
                        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |org.apache.flink.util.ExceptionUtils.rethrow(\n             |  new RuntimeException(", ".toString()));\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nullValue.code(), ((GeneratedExpression)operands.head()).resultTerm()})))).stripMargin();
                        generatedExpression = new GeneratedExpression(nullValue.resultTerm(), nullValue.nullTerm(), code, resultType2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                        break block10;
                    }
                    SqlFunction sqlFunction = ScalarSqlFunctions$.MODULE$.PROCTIME();
                    SqlOperator sqlOperator47 = sqlOperator;
                    if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator47) : sqlOperator47 != null) break block59;
                    generatedExpression = this.generateNullLiteral(DataTypes.PROCTIME_INDICATOR, nullCheck);
                    break block10;
                }
                if (sqlOperator == null) break block60;
                SqlOperator sqlOperator48 = sqlOperator;
                generatedExpression = (GeneratedExpression)BinaryStringCallGen$.MODULE$.generateCallExpression(ctx, operator, operands, resultType2).getOrElse((Function0)new Serializable(ctx, operands, resultType2, nullCheck, operatorName, sqlOperator48){
                    public static final long serialVersionUID = 0L;
                    private final CodeGeneratorContext ctx$1;
                    public final Seq operands$1;
                    private final InternalType resultType$1;
                    private final boolean nullCheck$1;
                    private final String operatorName$1;
                    public final SqlOperator x49$1;

                    public final GeneratedExpression apply() {
                        return ((CallGenerator)FunctionGenerator$.MODULE$.getCallGenerator(this.x49$1, (Seq<GeneratedExpression>)this.operands$1, this.resultType$1).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.generateCallExpression.3 $outer;

                            public final Nothing$ apply() {
                                throw new CodeGenException(TableErrors.INST.sqlCodeGenUnsupportedScalaFunc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.x49$1, ((TraversableOnce)this.$outer.operands$1.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final InternalType apply(GeneratedExpression x$5) {
                                        return x$5.resultType();
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).mkString(",")}))));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).generate(this.ctx$1, this.operatorName$1, (Seq<GeneratedExpression>)this.operands$1, this.resultType$1, this.nullCheck$1);
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.operands$1 = operands$1;
                        this.resultType$1 = resultType$1;
                        this.nullCheck$1 = nullCheck$1;
                        this.operatorName$1 = operatorName$1;
                        this.x49$1 = x49$1;
                    }
                });
            }
            return generatedExpression;
        }
        throw new CodeGenException(TableErrors.INST.sqlCodeGenUnsupportedCall(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlOperator, ((TraversableOnce)operands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(GeneratedExpression x$6) {
                return x$6.resultType();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")}))));
    }

    public boolean isReference(GeneratedExpression genExpr) {
        return this.isReference(genExpr.resultType());
    }

    public boolean isReference(InternalType t) {
        boolean bl;
        InternalType internalType = t;
        IntType intType = DataTypes.INT;
        InternalType internalType2 = internalType;
        if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
            bl = true;
        } else {
            LongType longType = DataTypes.LONG;
            InternalType internalType3 = internalType;
            if (!(longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null)) {
                bl = true;
            } else {
                ShortType shortType = DataTypes.SHORT;
                InternalType internalType4 = internalType;
                if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                    bl = true;
                } else {
                    ByteType byteType = DataTypes.BYTE;
                    InternalType internalType5 = internalType;
                    if (!(byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null)) {
                        bl = true;
                    } else {
                        FloatType floatType = DataTypes.FLOAT;
                        InternalType internalType6 = internalType;
                        if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                            bl = true;
                        } else {
                            DoubleType doubleType = DataTypes.DOUBLE;
                            InternalType internalType7 = internalType;
                            if (!(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null)) {
                                bl = true;
                            } else {
                                BooleanType booleanType = DataTypes.BOOLEAN;
                                InternalType internalType8 = internalType;
                                if (!(booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null)) {
                                    bl = true;
                                } else {
                                    CharType charType = DataTypes.CHAR;
                                    InternalType internalType9 = internalType;
                                    bl = !(charType != null ? !((Object)charType).equals(internalType9) : internalType9 != null);
                                }
                            }
                        }
                    }
                }
            }
        }
        boolean bl2 = !bl;
        return bl2;
    }

    public String baseRowFieldReadAccess(CodeGeneratorContext ctx, int pos, String rowTerm, InternalType fieldType) {
        return this.baseRowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), rowTerm, fieldType, this.baseRowFieldReadAccess$default$5());
    }

    public String baseRowFieldReadAccess(CodeGeneratorContext ctx, int pos, String rowTerm, InternalType fieldType, Option<String> reuseBinaryString) {
        return this.baseRowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), rowTerm, fieldType, reuseBinaryString);
    }

    public String baseRowFieldReadAccess(CodeGeneratorContext ctx, String pos, String rowTerm, InternalType fieldType, Option<String> reuseBinaryString) {
        InternalType internalType;
        block23: {
            String string;
            block3: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block10: {
                                                        Option<String> option;
                                                        block13: {
                                                            String string2;
                                                            block12: {
                                                                block11: {
                                                                    String s;
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                internalType = fieldType;
                                                                                                IntType intType = DataTypes.INT;
                                                                                                InternalType internalType2 = internalType;
                                                                                                if (intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null) break block2;
                                                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                                                break block3;
                                                                                            }
                                                                                            LongType longType = DataTypes.LONG;
                                                                                            InternalType internalType3 = internalType;
                                                                                            if (longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null) break block4;
                                                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getLong(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                                            break block3;
                                                                                        }
                                                                                        ShortType shortType = DataTypes.SHORT;
                                                                                        InternalType internalType4 = internalType;
                                                                                        if (shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null) break block5;
                                                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getShort(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                                        break block3;
                                                                                    }
                                                                                    ByteType byteType = DataTypes.BYTE;
                                                                                    InternalType internalType5 = internalType;
                                                                                    if (byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null) break block6;
                                                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getByte(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                                    break block3;
                                                                                }
                                                                                FloatType floatType = DataTypes.FLOAT;
                                                                                InternalType internalType6 = internalType;
                                                                                if (floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null) break block7;
                                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getFloat(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                                break block3;
                                                                            }
                                                                            DoubleType doubleType = DataTypes.DOUBLE;
                                                                            InternalType internalType7 = internalType;
                                                                            if (doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null) break block8;
                                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getDouble(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                            break block3;
                                                                        }
                                                                        BooleanType booleanType = DataTypes.BOOLEAN;
                                                                        InternalType internalType8 = internalType;
                                                                        if (booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null) break block9;
                                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBoolean(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                                        break block3;
                                                                    }
                                                                    StringType stringType = DataTypes.STRING;
                                                                    InternalType internalType9 = internalType;
                                                                    if (stringType != null ? !((Object)stringType).equals(internalType9) : internalType9 != null) break block10;
                                                                    option = reuseBinaryString;
                                                                    if (!(option instanceof Some)) break block11;
                                                                    Some some = (Some)option;
                                                                    string2 = s = (String)some.x();
                                                                    break block12;
                                                                }
                                                                if (!None$.MODULE$.equals(option)) break block13;
                                                                String s = this.newName("reuseBString");
                                                                ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BINARY_STRING(), s, CodeGeneratorContext$.MODULE$.BINARY_STRING()})), ctx.addReusableMember$default$2());
                                                                string2 = s;
                                                            }
                                                            String reuse = string2;
                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBinaryString(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, reuse}));
                                                            break block3;
                                                        }
                                                        throw new MatchError(option);
                                                    }
                                                    if (!(internalType instanceof DecimalType)) break block14;
                                                    DecimalType decimalType = (DecimalType)internalType;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getDecimal(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                                                    break block3;
                                                }
                                                CharType charType = DataTypes.CHAR;
                                                InternalType internalType10 = internalType;
                                                if (charType != null ? !((Object)charType).equals(internalType10) : internalType10 != null) break block15;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getChar(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                                break block3;
                                            }
                                            if (!(internalType instanceof TimestampType)) break block16;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getLong(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                            break block3;
                                        }
                                        if (!(internalType instanceof DateType)) break block17;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                        break block3;
                                    }
                                    TimeType timeType = DataTypes.TIME;
                                    InternalType internalType11 = internalType;
                                    if (timeType != null ? !((Object)timeType).equals(internalType11) : internalType11 != null) break block18;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                    break block3;
                                }
                                ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
                                InternalType internalType12 = internalType;
                                if (byteArrayType != null ? !((Object)byteArrayType).equals(internalType12) : internalType12 != null) break block19;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getByteArray(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                                break block3;
                            }
                            if (!(internalType instanceof ArrayType)) break block20;
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBaseArray(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                            break block3;
                        }
                        if (!(internalType instanceof MapType)) break block21;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBaseMap(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
                        break block3;
                    }
                    if (!(internalType instanceof RowType)) break block22;
                    RowType rowType = (RowType)internalType;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBaseRow(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, BoxesRunTime.boxToInteger((int)rowType.getArity())}));
                    break block3;
                }
                if (!(internalType instanceof GenericType)) break block23;
                GenericType genericType = (GenericType)internalType;
                string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |(", ")\n           |  ", ".getGeneric(", ", ", ")\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{genericType.getTypeClass().getCanonicalName(), rowTerm, pos, ctx.addReusableTypeSerializer(fieldType)})))).stripMargin().trim();
            }
            return string;
        }
        throw new MatchError((Object)internalType);
    }

    public Option<String> baseRowFieldReadAccess$default$5() {
        return None$.MODULE$;
    }

    public String binaryWriterWriteNull(int pos, String writerTerm, InternalType t) {
        return this.binaryWriterWriteNull(((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), writerTerm, t);
    }

    public String binaryWriterWriteNull(String pos, String writerTerm, InternalType t) {
        DecimalType decimalType;
        InternalType internalType = t;
        String string = internalType instanceof DecimalType && !Decimal.isCompact((decimalType = (DecimalType)internalType).precision()) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeDecimal(", ", null, ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos}));
        return string;
    }

    public String binaryRowSetNull(int pos, String rowTerm, InternalType t) {
        return this.binaryRowSetNull(((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), rowTerm, t);
    }

    public String binaryRowSetNull(String pos, String rowTerm, InternalType t) {
        DecimalType decimalType;
        InternalType internalType = t;
        String string = internalType instanceof DecimalType && !Decimal.isCompact((decimalType = (DecimalType)internalType).precision()) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setDecimal(", ", null, ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos}));
        return string;
    }

    public String binaryRowFieldSetAccess(int pos, String binaryRowTerm, InternalType fieldType, String fieldValTerm) {
        return this.binaryRowFieldSetAccess(((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), binaryRowTerm, fieldType, fieldValTerm);
    }

    public String binaryRowFieldSetAccess(String pos, String binaryRowTerm, InternalType fieldType, String fieldValTerm) {
        block14: {
            String string;
            block3: {
                InternalType internalType;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            internalType = fieldType;
                                                            IntType intType = DataTypes.INT;
                                                            InternalType internalType2 = internalType;
                                                            if (intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null) break block2;
                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                                            break block3;
                                                        }
                                                        LongType longType = DataTypes.LONG;
                                                        InternalType internalType3 = internalType;
                                                        if (longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null) break block4;
                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                                        break block3;
                                                    }
                                                    ShortType shortType = DataTypes.SHORT;
                                                    InternalType internalType4 = internalType;
                                                    if (shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null) break block5;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setShort(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                                    break block3;
                                                }
                                                ByteType byteType = DataTypes.BYTE;
                                                InternalType internalType5 = internalType;
                                                if (byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null) break block6;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setByte(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                                break block3;
                                            }
                                            FloatType floatType = DataTypes.FLOAT;
                                            InternalType internalType6 = internalType;
                                            if (floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null) break block7;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setFloat(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                            break block3;
                                        }
                                        DoubleType doubleType = DataTypes.DOUBLE;
                                        InternalType internalType7 = internalType;
                                        if (doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null) break block8;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setDouble(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                        break block3;
                                    }
                                    BooleanType booleanType = DataTypes.BOOLEAN;
                                    InternalType internalType8 = internalType;
                                    if (booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null) break block9;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setBoolean(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                    break block3;
                                }
                                CharType charType = DataTypes.CHAR;
                                InternalType internalType9 = internalType;
                                if (charType != null ? !((Object)charType).equals(internalType9) : internalType9 != null) break block10;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setChar(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                                break block3;
                            }
                            if (!(internalType instanceof DateType)) break block11;
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                            break block3;
                        }
                        TimeType timeType = DataTypes.TIME;
                        InternalType internalType10 = internalType;
                        if (timeType != null ? !((Object)timeType).equals(internalType10) : internalType10 != null) break block12;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                        break block3;
                    }
                    if (!(internalType instanceof TimestampType)) break block13;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm}));
                    break block3;
                }
                if (!(internalType instanceof DecimalType)) break block14;
                DecimalType decimalType = (DecimalType)internalType;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setDecimal(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRowTerm, pos, fieldValTerm, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
            }
            return string;
        }
        throw new CodeGenException(new StringBuilder().append((Object)"Fail to find binary row field setter method of InternalType ").append((Object)fieldType).append((Object)".").toString());
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, int pos, String fieldValTerm, String writerTerm, InternalType fieldType) {
        return this.binaryWriterWriteField(ctx, ((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), fieldValTerm, writerTerm, fieldType);
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, String pos, String fieldValTerm, String writerTerm, InternalType fieldType) {
        InternalType internalType;
        block20: {
            String string;
            block3: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block8: {
                                                                block7: {
                                                                    block6: {
                                                                        block5: {
                                                                            block4: {
                                                                                block2: {
                                                                                    internalType = fieldType;
                                                                                    IntType intType = DataTypes.INT;
                                                                                    InternalType internalType2 = internalType;
                                                                                    if (intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null) break block2;
                                                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                                    break block3;
                                                                                }
                                                                                LongType longType = DataTypes.LONG;
                                                                                InternalType internalType3 = internalType;
                                                                                if (longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null) break block4;
                                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                                break block3;
                                                                            }
                                                                            ShortType shortType = DataTypes.SHORT;
                                                                            InternalType internalType4 = internalType;
                                                                            if (shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null) break block5;
                                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeShort(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                            break block3;
                                                                        }
                                                                        ByteType byteType = DataTypes.BYTE;
                                                                        InternalType internalType5 = internalType;
                                                                        if (byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null) break block6;
                                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeByte(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                        break block3;
                                                                    }
                                                                    FloatType floatType = DataTypes.FLOAT;
                                                                    InternalType internalType6 = internalType;
                                                                    if (floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null) break block7;
                                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeFloat(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                    break block3;
                                                                }
                                                                DoubleType doubleType = DataTypes.DOUBLE;
                                                                InternalType internalType7 = internalType;
                                                                if (doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null) break block8;
                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeDouble(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                                break block3;
                                                            }
                                                            BooleanType booleanType = DataTypes.BOOLEAN;
                                                            InternalType internalType8 = internalType;
                                                            if (booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null) break block9;
                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeBoolean(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                            break block3;
                                                        }
                                                        StringType stringType = DataTypes.STRING;
                                                        InternalType internalType9 = internalType;
                                                        if (stringType != null ? !((Object)stringType).equals(internalType9) : internalType9 != null) break block10;
                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeBinaryString(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                        break block3;
                                                    }
                                                    if (!(internalType instanceof DecimalType)) break block11;
                                                    DecimalType decimalType = (DecimalType)internalType;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeDecimal(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                                                    break block3;
                                                }
                                                CharType charType = DataTypes.CHAR;
                                                InternalType internalType10 = internalType;
                                                if (charType != null ? !((Object)charType).equals(internalType10) : internalType10 != null) break block12;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeChar(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                                break block3;
                                            }
                                            if (!(internalType instanceof DateType)) break block13;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                            break block3;
                                        }
                                        TimeType timeType = DataTypes.TIME;
                                        InternalType internalType11 = internalType;
                                        if (timeType != null ? !((Object)timeType).equals(internalType11) : internalType11 != null) break block14;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                        break block3;
                                    }
                                    if (!(internalType instanceof TimestampType)) break block15;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                    break block3;
                                }
                                ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
                                InternalType internalType12 = internalType;
                                if (byteArrayType != null ? !((Object)byteArrayType).equals(internalType12) : internalType12 != null) break block16;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeByteArray(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}));
                                break block3;
                            }
                            if (!(internalType instanceof ArrayType)) break block17;
                            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeBaseArray(", ", ", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BASE_ROW_UTIL(), writerTerm, pos, fieldValTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BaseArraySerializer.class.getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.addReusableTypeSerializer(fieldType)}))).toString();
                            break block3;
                        }
                        if (!(internalType instanceof MapType)) break block18;
                        string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeBaseMap(", ", ", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BASE_ROW_UTIL(), writerTerm, pos, fieldValTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BaseMapSerializer.class.getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.addReusableTypeSerializer(fieldType)}))).toString();
                        break block3;
                    }
                    if (!(internalType instanceof RowType)) break block19;
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeBaseRow(", ", ", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BASE_ROW_UTIL(), writerTerm, pos, fieldValTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BaseRowSerializer.class.getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.addReusableTypeSerializer(fieldType)}))).toString();
                    break block3;
                }
                if (!(internalType instanceof GenericType)) break block20;
                string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".writeGeneric(", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, pos, fieldValTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.addReusableTypeSerializer(fieldType)}))).toString();
            }
            return string;
        }
        throw new MatchError((Object)internalType);
    }

    public String baseArraySetNull(int pos, String term2, InternalType t) {
        String string;
        InternalType internalType = t;
        BooleanType booleanType = DataTypes.BOOLEAN;
        InternalType internalType2 = internalType;
        if (!(booleanType != null ? !((Object)booleanType).equals(internalType2) : internalType2 != null)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullBoolean(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
        } else {
            ByteType byteType = DataTypes.BYTE;
            InternalType internalType3 = internalType;
            if (!(byteType != null ? !((Object)byteType).equals(internalType3) : internalType3 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullByte(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
            } else {
                CharType charType = DataTypes.CHAR;
                InternalType internalType4 = internalType;
                if (!(charType != null ? !((Object)charType).equals(internalType4) : internalType4 != null)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullChar(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                } else {
                    ShortType shortType = DataTypes.SHORT;
                    InternalType internalType5 = internalType;
                    if (!(shortType != null ? !((Object)shortType).equals(internalType5) : internalType5 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullShort(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                    } else {
                        IntType intType = DataTypes.INT;
                        InternalType internalType6 = internalType;
                        if (!(intType != null ? !((Object)intType).equals(internalType6) : internalType6 != null)) {
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                        } else {
                            LongType longType = DataTypes.LONG;
                            InternalType internalType7 = internalType;
                            if (!(longType != null ? !((Object)longType).equals(internalType7) : internalType7 != null)) {
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullLong(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                            } else {
                                FloatType floatType = DataTypes.FLOAT;
                                InternalType internalType8 = internalType;
                                if (!(floatType != null ? !((Object)floatType).equals(internalType8) : internalType8 != null)) {
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullFloat(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                                } else {
                                    DoubleType doubleType = DataTypes.DOUBLE;
                                    InternalType internalType9 = internalType;
                                    if (!(doubleType != null ? !((Object)doubleType).equals(internalType9) : internalType9 != null)) {
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullDouble(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}));
                                    } else {
                                        TimeType timeType = DataTypes.TIME;
                                        InternalType internalType10 = internalType;
                                        string = !(timeType != null ? !((Object)timeType).equals(internalType10) : internalType10 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)})) : (internalType instanceof DateType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullInt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)})) : (internalType instanceof TimestampType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullLong(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNullLong(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, BoxesRunTime.boxToInteger((int)pos)}))));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String boxedWrapperRowFieldUpdateAccess(int pos, String fieldValTerm, String rowTerm, InternalType fieldType) {
        return this.boxedWrapperRowFieldUpdateAccess(((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), fieldValTerm, rowTerm, fieldType);
    }

    public String boxedWrapperRowFieldUpdateAccess(String pos, String fieldValTerm, String rowTerm, InternalType fieldType) {
        String string;
        InternalType internalType = fieldType;
        IntType intType = DataTypes.INT;
        InternalType internalType2 = internalType;
        if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
        } else {
            LongType longType = DataTypes.LONG;
            InternalType internalType3 = internalType;
            if (!(longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
            } else {
                ShortType shortType = DataTypes.SHORT;
                InternalType internalType4 = internalType;
                if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setShort(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                } else {
                    ByteType byteType = DataTypes.BYTE;
                    InternalType internalType5 = internalType;
                    if (!(byteType != null ? !((Object)byteType).equals(internalType5) : internalType5 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setByte(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                    } else {
                        FloatType floatType = DataTypes.FLOAT;
                        InternalType internalType6 = internalType;
                        if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setFloat(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                        } else {
                            DoubleType doubleType = DataTypes.DOUBLE;
                            InternalType internalType7 = internalType;
                            if (!(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null)) {
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setDouble(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                            } else {
                                BooleanType booleanType = DataTypes.BOOLEAN;
                                InternalType internalType8 = internalType;
                                if (!(booleanType != null ? !((Object)booleanType).equals(internalType8) : internalType8 != null)) {
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setBoolean(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                                } else {
                                    CharType charType = DataTypes.CHAR;
                                    InternalType internalType9 = internalType;
                                    if (!(charType != null ? !((Object)charType).equals(internalType9) : internalType9 != null)) {
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setChar(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                                    } else if (internalType instanceof DateType) {
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm}));
                                    } else {
                                        TimeType timeType = DataTypes.TIME;
                                        InternalType internalType10 = internalType;
                                        string = !(timeType != null ? !((Object)timeType).equals(internalType10) : internalType10 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setInt(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm})) : (internalType instanceof TimestampType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setLong(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setNonPrimitiveValue(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowTerm, pos, fieldValTerm})));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private LoadingCache<Tuple3<ClassLoader, String, String>, Class<?>> compileCache() {
        return this.compileCache;
    }

    public <T> Class<T> compile(ClassLoader cl, String name, String code) {
        try {
            return this.compileCache().get((Tuple3<ClassLoader, String, String>)new Tuple3((Object)cl, (Object)name, (Object)code));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError;
            if (bl) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Class<T> org$apache$flink$table$codegen$CodeGenUtils$$doCompile(ClassLoader cl, String name, String originCode) {
        String code;
        try {
            code = JavaCodeSplitter.split(originCode);
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)CodeFormatter$.MODULE$.format(originCode, CodeFormatter$.MODULE$.format$default$2()));
            throw throwable;
        }
        if (Logging$.MODULE$.CODE_LOG().isDebugEnabled()) {
            Logging$.MODULE$.CODE_LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, originCode})));
        }
        Predef$.MODULE$.require(cl != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Classloader must not be null.";
            }
        });
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.setParentClassLoader(cl);
        try {}
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2()));
                Logging$.MODULE$.CODE_LOG().info("JavaCodeSplitter Failed.", throwable);
                compiler.cook(originCode);
                return compiler.getClassLoader().loadClass(name);
            }
            catch (Throwable throwable2) {
                Predef$.MODULE$.println((Object)CodeFormatter$.MODULE$.format(originCode, CodeFormatter$.MODULE$.format$default$2()));
                throw new InvalidProgramException("Table program cannot be compiled. This is a bug. Please file an issue.", throwable2);
            }
        }
        compiler.cook(code);
        return compiler.getClassLoader().loadClass(name);
    }

    public void enableCodeGenerateDebug() {
        System.setProperty("org.codehaus.janino.source_debugging.enable", "true");
    }

    public void disableCodeGenerateDebug() {
        System.setProperty("org.codehaus.janino.source_debugging.enable", "false");
    }

    public void setCodeGenerateTmpDir(String path) {
        if (StringUtils.isNullOrWhitespaceOnly(path)) {
            throw new RuntimeException("code generate tmp dir can't be empty");
        }
        System.setProperty("org.codehaus.janino.source_debugging.dir", path);
    }

    public String genLogInfo(String logTerm, String format2, String argTerm) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".info(\"", "\", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logTerm, format2, argTerm}));
    }

    public GeneratedSplittableExpression generateSplitFunctionCalls(Seq<String> codeBuffer, int limitLength, String subFunctionName, String subFunctionModifier, int fieldStatementLength, String defineParams, String callingParams) {
        ListBuffer bodies = new ListBuffer();
        String rest = (String)codeBuffer.foldLeft((Object)"", (Function2)new Serializable(limitLength, bodies){
            public static final long serialVersionUID = 0L;
            private final int limitLength$1;
            private final ListBuffer bodies$1;

            public final String apply(String acc, String code) {
                String string;
                if (acc.length() + code.length() <= this.limitLength$1) {
                    string = acc.length() > 0 ? new StringBuilder().append((Object)acc).append((Object)"\n").append((Object)code).toString() : code;
                } else {
                    Object object = acc.length() > 0 ? this.bodies$1.$plus$eq((Object)acc) : BoxedUnit.UNIT;
                    string = code;
                }
                return string;
            }
            {
                this.limitLength$1 = limitLength$1;
                this.bodies$1 = bodies$1;
            }
        });
        bodies.$plus$eq((Object)rest);
        IndexedSeq defines = (IndexedSeq)bodies.indices().map((Function1)new Serializable(subFunctionName, subFunctionModifier, defineParams){
            public static final long serialVersionUID = 0L;
            private final String subFunctionName$1;
            private final String subFunctionModifier$1;
            private final String defineParams$1;

            public final String apply(int index) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", "_", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subFunctionModifier$1, this.subFunctionName$1, BoxesRunTime.boxToInteger((int)index), this.defineParams$1}));
            }
            {
                this.subFunctionName$1 = subFunctionName$1;
                this.subFunctionModifier$1 = subFunctionModifier$1;
                this.defineParams$1 = defineParams$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq callings = (IndexedSeq)bodies.indices().map((Function1)new Serializable(subFunctionName, callingParams){
            public static final long serialVersionUID = 0L;
            private final String subFunctionName$1;
            private final String callingParams$1;

            public final String apply(int index) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subFunctionName$1, BoxesRunTime.boxToInteger((int)index), this.callingParams$1}));
            }
            {
                this.subFunctionName$1 = subFunctionName$1;
                this.callingParams$1 = callingParams$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        boolean isSplit = defines.length() > 1 || defines.length() == 1 && BoxesRunTime.unboxToInt((Object)((TraversableOnce)codeBuffer.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$7) {
                return x$7.length();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + fieldStatementLength > limitLength;
        return new GeneratedSplittableExpression((Seq<String>)defines, (Seq<String>)bodies, (Seq<String>)callings, isSplit);
    }

    public String generateSplitFunctionCalls$default$6() {
        return "";
    }

    public String generateSplitFunctionCalls$default$7() {
        return "";
    }

    public String getDefineParamsByFunctionClass(Class<?> clazz) {
        String string;
        Class<?> clazz2 = clazz;
        Class<FlatMapFunction> clazz3 = FlatMapFunction.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Object _in1, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.flink.util.Collector ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString();
        } else {
            Class<?> clazz4 = clazz;
            Class<MapFunction> clazz5 = MapFunction.class;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Object _in1"})).s((Seq)Nil$.MODULE$);
            } else {
                Class<?> clazz6 = clazz;
                Class<FlatJoinFunction> clazz7 = FlatJoinFunction.class;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Object _in1, Object _in2, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.flink.util.Collector ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString();
                } else {
                    Class<?> clazz8 = clazz;
                    Class<ProcessFunction> clazz9 = ProcessFunction.class;
                    string = !(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null) ? new StringBuilder().append((Object)"Object _in1, org.apache.flink.streaming.api.functions.ProcessFunction.Context ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", org.apache.flink.util.Collector "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_CONTEXT_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString() : "";
                }
            }
        }
        return string;
    }

    public String getCallingParamsByFunctionClass(Class<?> clazz) {
        String string;
        Class<?> clazz2 = clazz;
        Class<FlatMapFunction> clazz3 = FlatMapFunction.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_INPUT1_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString();
        } else {
            Class<?> clazz4 = clazz;
            Class<MapFunction> clazz5 = MapFunction.class;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_INPUT1_TERM()}));
            } else {
                Class<?> clazz6 = clazz;
                Class<FlatJoinFunction> clazz7 = FlatJoinFunction.class;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_INPUT1_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_INPUT2_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString();
                } else {
                    Class<?> clazz8 = clazz;
                    Class<ProcessFunction> clazz9 = ProcessFunction.class;
                    string = !(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null) ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_INPUT1_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_CONTEXT_TERM()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.DEFAULT_COLLECTOR_TERM()}))).toString() : "";
                }
            }
        }
        return string;
    }

    public Tuple2<Function5<String, InternalType, String, String, String, String>, Function1<Seq<String>, GeneratedExpression>> getSetFieldCodeGenerator(CodeGeneratorContext ctx, RowType outRowType, Class<? extends BaseRow> outRowClass, String outRow, Option<String> outRowWriter, boolean nullCheck, boolean reusedOutRow, boolean outRowAlreadyExists) {
        Class<? extends BaseRow> clazz;
        block12: {
            Tuple2 tuple2;
            block9: {
                Tuple2 tuple22;
                block11: {
                    Serializable expressionGenerator;
                    block10: {
                        String string;
                        block5: {
                            Option<String> option;
                            block8: {
                                Tuple2 tuple23;
                                block7: {
                                    block6: {
                                        Class<? extends BaseRow> clazz2 = outRowClass;
                                        Class<BinaryRow> clazz3 = BinaryRow.class;
                                        if (clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null) break block5;
                                        option = outRowWriter;
                                        if (!(option instanceof Some)) break block6;
                                        Some some = (Some)option;
                                        String writer = (String)some.x();
                                        tuple23 = new Tuple2((Object)new Serializable(ctx, nullCheck, writer){
                                            public static final long serialVersionUID = 0L;
                                            private final CodeGeneratorContext ctx$2;
                                            private final boolean nullCheck$2;
                                            private final String writer$1;

                                            public final String apply(String idx, InternalType t, String code, String nullTerm, String resultTerm) {
                                                String writeCode = CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$2, idx, resultTerm, this.writer$1, t);
                                                return this.nullCheck$2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", "\n                 |if (", ") {\n                 |  ", ";\n                 |} else {\n                 |  ", ";\n                 |}\n                "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, nullTerm, CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, this.writer$1, t), writeCode})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", "\n                 |", ";\n                "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, writeCode})))).stripMargin().trim();
                                            }
                                            {
                                                this.ctx$2 = ctx$2;
                                                this.nullCheck$2 = nullCheck$2;
                                                this.writer$1 = writer$1;
                                            }
                                        }, (Object)new Serializable(ctx, outRowType, outRowClass, outRow, outRowWriter, nullCheck, reusedOutRow, outRowAlreadyExists, writer){
                                            public static final long serialVersionUID = 0L;
                                            private final CodeGeneratorContext ctx$2;
                                            private final RowType outRowType$1;
                                            private final Class outRowClass$1;
                                            private final String outRow$1;
                                            private final Option outRowWriter$1;
                                            private final boolean nullCheck$2;
                                            private final boolean reusedOutRow$1;
                                            private final boolean outRowAlreadyExists$1;
                                            private final String writer$1;

                                            public final GeneratedExpression apply(Seq<String> codeBuffer) {
                                                String initReturnRecord = this.outRowAlreadyExists$1 ? "" : this.ctx$2.addOutputRecord(this.outRowType$1, this.outRowClass$1, this.outRow$1, (Option<String>)this.outRowWriter$1, this.reusedOutRow$1);
                                                String resetWriter = this.nullCheck$2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".reset();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.writer$1})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".resetCursor();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.writer$1}));
                                                String completeWriter = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".complete();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.writer$1}));
                                                String statement = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", "\n                 |", "\n                 |", "\n                 |", "\n                "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{initReturnRecord, resetWriter, codeBuffer.mkString("\n"), completeWriter})))).stripMargin().trim();
                                                String x$9 = this.outRow$1;
                                                String x$10 = "false";
                                                String x$11 = statement;
                                                RowType x$12 = this.outRowType$1;
                                                Seq<String> x$13 = codeBuffer;
                                                String x$14 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{initReturnRecord, resetWriter}));
                                                String x$15 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completeWriter}));
                                                boolean x$16 = GeneratedExpression$.MODULE$.apply$default$5();
                                                Object x$17 = GeneratedExpression$.MODULE$.apply$default$6();
                                                return new GeneratedExpression(x$9, x$10, x$11, x$12, x$16, x$17, x$13, x$14, x$15);
                                            }
                                            {
                                                this.ctx$2 = ctx$2;
                                                this.outRowType$1 = outRowType$1;
                                                this.outRowClass$1 = outRowClass$1;
                                                this.outRow$1 = outRow$1;
                                                this.outRowWriter$1 = outRowWriter$1;
                                                this.nullCheck$2 = nullCheck$2;
                                                this.reusedOutRow$1 = reusedOutRow$1;
                                                this.outRowAlreadyExists$1 = outRowAlreadyExists$1;
                                                this.writer$1 = writer$1;
                                            }
                                        });
                                        break block7;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block8;
                                    Preconditions.checkArgument(outRowAlreadyExists);
                                    tuple23 = new Tuple2((Object)new Serializable(outRow, nullCheck){
                                        public static final long serialVersionUID = 0L;
                                        private final String outRow$1;
                                        private final boolean nullCheck$2;

                                        public final String apply(String idx, InternalType t, String code, String nullTerm, String resultTerm) {
                                            String writeCode = CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.outRow$1, t, resultTerm);
                                            return this.nullCheck$2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", "\n                 |if (", ") {\n                 |  ", ";\n                 |} else {\n                 |  ", ";\n                 |}\n                  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, nullTerm, CodeGenUtils$.MODULE$.binaryRowSetNull(idx, this.outRow$1, t), writeCode})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", "\n                 |", ";\n                  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, writeCode})))).stripMargin().trim();
                                        }
                                        {
                                            this.outRow$1 = outRow$1;
                                            this.nullCheck$2 = nullCheck$2;
                                        }
                                    }, (Object)new Serializable(outRowType, outRow){
                                        public static final long serialVersionUID = 0L;
                                        private final RowType outRowType$1;
                                        private final String outRow$1;

                                        public final GeneratedExpression apply(Seq<String> codeBuffer) {
                                            return new GeneratedExpression(this.outRow$1, "false", codeBuffer.mkString(""), this.outRowType$1, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                                        }
                                        {
                                            this.outRowType$1 = outRowType$1;
                                            this.outRow$1 = outRow$1;
                                        }
                                    });
                                }
                                tuple2 = tuple23;
                                break block9;
                            }
                            throw new MatchError(option);
                        }
                        if (outRowAlreadyExists) {
                            string = "";
                        } else {
                            RowType x$18 = outRowType;
                            Class<? extends BaseRow> x$19 = outRowClass;
                            String x$20 = outRow;
                            boolean x$21 = reusedOutRow;
                            Option<String> x$22 = ctx.addOutputRecord$default$4();
                            string = ctx.addOutputRecord(x$18, x$19, x$20, x$22, x$21);
                        }
                        String initReturnRecord = string;
                        expressionGenerator = new Serializable(outRowType, outRow, initReturnRecord){
                            public static final long serialVersionUID = 0L;
                            private final RowType outRowType$1;
                            private final String outRow$1;
                            private final String initReturnRecord$1;

                            public final GeneratedExpression apply(Seq<String> codeBuffer) {
                                String statement = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |", "\n                "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initReturnRecord$1, codeBuffer.mkString("")})))).stripMargin().trim();
                                String x$23 = this.outRow$1;
                                String x$24 = "false";
                                String x$25 = statement;
                                RowType x$26 = this.outRowType$1;
                                Seq<String> x$27 = codeBuffer;
                                String x$28 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initReturnRecord$1}));
                                boolean x$29 = GeneratedExpression$.MODULE$.apply$default$5();
                                Object x$30 = GeneratedExpression$.MODULE$.apply$default$6();
                                String x$31 = GeneratedExpression$.MODULE$.apply$default$9();
                                return new GeneratedExpression(x$23, x$24, x$25, x$26, x$29, x$30, x$27, x$28, x$31);
                            }
                            {
                                this.outRowType$1 = outRowType$1;
                                this.outRow$1 = outRow$1;
                                this.initReturnRecord$1 = initReturnRecord$1;
                            }
                        };
                        Class<? extends BaseRow> clazz4 = clazz = outRowClass;
                        Class<GenericRow> clazz5 = GenericRow.class;
                        if (clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null) break block10;
                        tuple22 = new Tuple2((Object)new Serializable(outRow, nullCheck){
                            public static final long serialVersionUID = 0L;
                            private final String outRow$1;
                            private final boolean nullCheck$2;

                            public final String apply(String idx, InternalType x$8, String code, String nullTerm, String resultTerm) {
                                String updateCode = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".update(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outRow$1, idx, resultTerm}));
                                return CodeGenUtils$.MODULE$.org$apache$flink$table$codegen$CodeGenUtils$$getRowUpdate$1(idx, code, nullTerm, updateCode, this.outRow$1, this.nullCheck$2);
                            }
                            {
                                this.outRow$1 = outRow$1;
                                this.nullCheck$2 = nullCheck$2;
                            }
                        }, (Object)expressionGenerator);
                        break block11;
                    }
                    Class<? extends BaseRow> clazz6 = clazz;
                    Class<BoxedWrapperRow> clazz7 = BoxedWrapperRow.class;
                    if (clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null) break block12;
                    tuple22 = new Tuple2((Object)new Serializable(outRow, nullCheck){
                        public static final long serialVersionUID = 0L;
                        private final String outRow$1;
                        private final boolean nullCheck$2;

                        public final String apply(String idx, InternalType t, String code, String nullTerm, String resultTerm) {
                            String updateCode = new StringBuilder().append((Object)CodeGenUtils$.MODULE$.boxedWrapperRowFieldUpdateAccess(idx, resultTerm, this.outRow$1, t)).append((Object)";").toString();
                            return CodeGenUtils$.MODULE$.org$apache$flink$table$codegen$CodeGenUtils$$getRowUpdate$1(idx, code, nullTerm, updateCode, this.outRow$1, this.nullCheck$2);
                        }
                        {
                            this.outRow$1 = outRow$1;
                            this.nullCheck$2 = nullCheck$2;
                        }
                    }, (Object)expressionGenerator);
                }
                tuple2 = tuple22;
            }
            return tuple2;
        }
        throw new MatchError(clazz);
    }

    public final String org$apache$flink$table$codegen$CodeGenUtils$$getRowUpdate$1(String idx, String code, String nullTerm, String updateCode, String outRow$1, boolean nullCheck$2) {
        return nullCheck$2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |if (", ") {\n           |  ", ".setNullAt(", ");\n           |} else {\n           |  ", "\n           |}\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, nullTerm, outRow$1, idx, updateCode})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, updateCode})))).stripMargin().trim();
    }

    private CodeGenUtils$() {
        MODULE$ = this;
        this.nameCounter = new AtomicInteger();
        this.compileCache = CacheBuilder.newBuilder().maximumSize(100L).build(new CacheLoader<Tuple3<ClassLoader, String, String>, Class<?>>(){

            public Class<?> load(Tuple3<ClassLoader, String, String> args) {
                return CodeGenUtils$.MODULE$.org$apache$flink$table$codegen$CodeGenUtils$$doCompile((ClassLoader)args._1(), (String)args._2(), (String)args._3());
            }
        });
    }
}

