/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.concurrent.atomic.AtomicLong;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.flink.table.codesplit.JavaParser;

public class CodeSplitUtil {
    private static AtomicLong counter = new AtomicLong(0L);

    public static AtomicLong getCounter() {
        return counter;
    }

    public static String newName(String name) {
        return name + "$" + counter.getAndIncrement();
    }

    public static String getContextString(ParserRuleContext ctx) {
        if (ctx == null) {
            return "";
        }
        CharStream cs = ctx.start.getInputStream();
        return cs.getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    public static int getContextTextLength(ParserRuleContext ctx) {
        return CodeSplitUtil.getContextString(ctx).length();
    }

    public static String getMethodParameters(JavaParser.MethodDeclarationContext ctx) {
        JavaParser.FormalParameterListContext params = ctx.formalParameters().formalParameterList();
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (JavaParser.FormalParameterContext p : params.formalParameter()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(p.variableDeclaratorId().getText());
        }
        return sb.toString();
    }
}

