/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.util.Preconditions;

public class DeclarationRewriter {
    private final String code;
    private final int maxMethodLength;
    private final CommonTokenStream tokenStream;
    private final TokenStreamRewriter rewriter;

    public DeclarationRewriter(String code, int maxMethodLength) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
        this.tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)CharStreams.fromString((String)code)));
        this.rewriter = new TokenStreamRewriter((TokenStream)this.tokenStream);
    }

    public String rewrite() {
        JavaParser javaParser = new JavaParser((TokenStream)this.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        new OuterBlockStatementExtractor().visit((ParseTree)javaParser.compilationUnit());
        return this.rewriter.getText();
    }

    private class InnerBlockStatementExtractor
    extends JavaParserBaseVisitor<Void> {
        private final TokenStreamRewriter rewriter;
        private final StringBuilder newLocalVariables;
        private final Set<String> allVarNames;
        private final Map<String, String> replaceMap;

        InnerBlockStatementExtractor(TokenStreamRewriter rewriter, Set<String> allVarNames) {
            this.rewriter = rewriter;
            this.newLocalVariables = new StringBuilder();
            this.allVarNames = allVarNames;
            this.replaceMap = new HashMap<String, String>();
        }

        @Override
        public Void visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            Preconditions.checkArgument(ctx.variableDeclarators().variableDeclarator().size() == 1, "%s\nCodegen rewrite failed. You can only declare one local variable in one statement.", DeclarationRewriter.this.code);
            JavaParser.VariableDeclaratorContext dec = ctx.variableDeclarators().variableDeclarator(0);
            JavaParser.VariableDeclaratorIdContext decId = dec.variableDeclaratorId();
            this.extractLocalVariable(decId, ctx.typeType(), false);
            if (dec.variableInitializer() == null) {
                this.rewriter.delete(ctx.start, ctx.getParent().stop);
                return null;
            }
            if (ctx.variableModifier() != null) {
                for (JavaParser.VariableModifierContext modifier : ctx.variableModifier()) {
                    this.rewriter.delete(modifier.start, modifier.stop);
                }
            }
            this.rewriter.delete(ctx.typeType().start, ctx.typeType().stop);
            this.replaceLocalVar(decId.getText(), decId.IDENTIFIER().getSymbol());
            return (Void)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Void visitEnhancedForControl(JavaParser.EnhancedForControlContext ctx) {
            JavaParser.VariableDeclaratorIdContext decId = ctx.variableDeclaratorId();
            String newName = this.extractLocalVariable(decId, ctx.typeType(), true);
            JavaParser.StatementContext stmt = (JavaParser.StatementContext)ctx.getParent().getParent();
            Preconditions.checkState(stmt.statement(0) != null && stmt.statement(0).block() != null, "%s\nCodegen rewrite failed. For statements must be placed inside a block.\n", DeclarationRewriter.this.code);
            this.rewriter.insertAfter(stmt.statement((int)0).block().start, (Object)(newName + " = " + decId.getText() + ";"));
            return null;
        }

        private String extractLocalVariable(JavaParser.VariableDeclaratorIdContext decId, JavaParser.TypeTypeContext typeType, boolean forceNewName) {
            String name = decId.getText();
            if (forceNewName || this.allVarNames.contains(name)) {
                String newName = CodeSplitUtil.newName("local");
                this.replaceMap.put(name, newName);
                this.newLocalVariables.append(typeType.getText()).append(" ").append(newName).append(";\n");
                return newName;
            }
            this.newLocalVariables.append(typeType.getText()).append(" ").append(name).append(";\n");
            this.allVarNames.add(name);
            return name;
        }

        @Override
        public Void visitPrimary(JavaParser.PrimaryContext ctx) {
            if (ctx.IDENTIFIER() != null) {
                this.replaceLocalVar(ctx.IDENTIFIER().getText(), ctx.IDENTIFIER().getSymbol());
                return null;
            }
            return (Void)this.visitChildren((RuleNode)ctx);
        }

        private void replaceLocalVar(String name, Token token) {
            String rep = this.replaceMap.get(name);
            if (rep != null) {
                this.rewriter.replace(token, (Object)rep);
            }
        }

        String getNewLocalVariables() {
            return this.newLocalVariables.toString();
        }
    }

    private class OuterBlockStatementExtractor
    extends JavaParserBaseVisitor<Void> {
        private final Stack<StringBuilder> newFields = new Stack();
        private final Set<String> allVarNames = new HashSet<String>();

        OuterBlockStatementExtractor() {
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            this.newFields.push(new StringBuilder());
            Void ret = (Void)this.visitChildren((RuleNode)ctx);
            DeclarationRewriter.this.rewriter.insertAfter(ctx.start, (Object)("\n" + this.newFields.pop().toString()));
            return ret;
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if ("void".equals(ctx.typeTypeOrVoid().getText())) {
                this.visitMethodBody(ctx.methodBody());
            }
            return null;
        }

        @Override
        public Void visitMethodBody(JavaParser.MethodBodyContext ctx) {
            if (CodeSplitUtil.getContextTextLength(ctx.block()) <= DeclarationRewriter.this.maxMethodLength) {
                return null;
            }
            InnerBlockStatementExtractor extractor = new InnerBlockStatementExtractor(DeclarationRewriter.this.rewriter, this.allVarNames);
            if (ctx.block() != null && ctx.block().blockStatement() != null) {
                for (JavaParser.BlockStatementContext blockStatementContext : ctx.block().blockStatement()) {
                    extractor.visitBlockStatement(blockStatementContext);
                }
                this.newFields.peek().append(extractor.getNewLocalVariables());
            }
            return null;
        }
    }
}

