/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;

public class FunctionSplitter {
    private final String code;
    private final int maxMethodLength;

    public FunctionSplitter(String code, int maxMethodLength) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
    }

    public String split() {
        FunctionSplitVisitor visitor = new FunctionSplitVisitor();
        JavaParser javaParser = new JavaParser((TokenStream)visitor.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        visitor.visit((ParseTree)javaParser.compilationUnit());
        return visitor.rewriter.getText();
    }

    private class FunctionSplitVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;

        private FunctionSplitVisitor() {
            this.tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)CharStreams.fromString((String)FunctionSplitter.this.code)));
            this.rewriter = new TokenStreamRewriter((TokenStream)this.tokenStream);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            long methodBodyLength = CodeSplitUtil.getContextTextLength(ctx.methodBody().block());
            if (methodBodyLength < (long)FunctionSplitter.this.maxMethodLength) {
                return null;
            }
            if (ctx.methodBody().block().blockStatement() == null || ctx.methodBody().block().blockStatement().size() <= 1) {
                return null;
            }
            ArrayList<String> splitFuncBodies = new ArrayList<String>();
            ArrayList<JavaParser.BlockStatementContext> blockStatementContexts = new ArrayList<JavaParser.BlockStatementContext>();
            final LinkedHashSet declarations = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarations.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit((ParseTree)ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.methodBody().block().blockStatement()) {
                blockStatementContexts.add(blockStatementContext);
                splitFuncBodies.add(CodeSplitUtil.getContextString(blockStatementContext));
            }
            List<String> mergedCodeBlocks = this.getMergedCodeBlocks(splitFuncBodies);
            ArrayList<String> newSplitMethods = new ArrayList<String>();
            ArrayList<String> newSplitMethodCalls = new ArrayList<String>();
            String methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            for (String methodBody : mergedCodeBlocks) {
                long counter = CodeSplitUtil.getCounter().getAndIncrement();
                String splitMethodDef = type + " " + functionName + "_split" + counter + parameters + methodQualifier;
                String newSplitMethod = splitMethodDef + " {\n" + methodBody + "\n}\n";
                String newSplitMethodCall = functionName + "_split" + counter + "(" + String.join((CharSequence)", ", declarations) + ");\n";
                newSplitMethods.add(newSplitMethod);
                newSplitMethodCalls.add(newSplitMethodCall);
            }
            for (int i = 0; i < blockStatementContexts.size(); ++i) {
                if (i < newSplitMethods.size()) {
                    this.rewriter.replace(((JavaParser.BlockStatementContext)((Object)blockStatementContexts.get((int)i))).start, ((JavaParser.BlockStatementContext)((Object)blockStatementContexts.get((int)i))).stop, newSplitMethodCalls.get(i));
                    this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + (String)newSplitMethods.get(i)));
                    continue;
                }
                this.rewriter.delete(((JavaParser.BlockStatementContext)((Object)blockStatementContexts.get((int)i))).start, ((JavaParser.BlockStatementContext)((Object)blockStatementContexts.get((int)i))).stop);
            }
            return null;
        }

        private List<String> getMergedCodeBlocks(List<String> codeBlock) {
            ArrayList<String> mergedCodeBlocks = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            codeBlock.forEach(code -> {
                if (sb.length() + code.length() + 1 <= FunctionSplitter.this.maxMethodLength) {
                    sb.append("\n").append((String)code);
                } else {
                    if (sb.length() > 0) {
                        mergedCodeBlocks.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append((String)code);
                }
            });
            if (sb.length() > 0) {
                mergedCodeBlocks.add(sb.toString());
            }
            return mergedCodeBlocks;
        }
    }
}

