/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.LinkedHashSet;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;

public class IfStatementRewriter {
    private final long maxMethodLength;
    private IfStatementVisitor visitor;

    public IfStatementRewriter(String code, long maxMethodLength) {
        this.maxMethodLength = maxMethodLength;
        this.visitor = new IfStatementVisitor(code, maxMethodLength);
    }

    public String rewrite() {
        String rewriterCode = this.visitor.rewriteAndGetCode();
        while (this.visitor.hasRewrite()) {
            this.visitor = new IfStatementVisitor(rewriterCode, this.maxMethodLength);
            rewriterCode = this.visitor.rewriteAndGetCode();
        }
        return rewriterCode;
    }

    private class IfStatementVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;
        private final long maxMethodLength;
        private long rewriteCount;

        private IfStatementVisitor(String code, long maxMethodLength) {
            this.maxMethodLength = maxMethodLength;
            this.tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)CharStreams.fromString((String)code)));
            this.rewriter = new TokenStreamRewriter((TokenStream)this.tokenStream);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            final LinkedHashSet declarationContext = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarationContext.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit((ParseTree)ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            String methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.methodBody().block().blockStatement()) {
                String newMethodCall;
                String newMethod;
                String methodDef;
                long counter;
                if (blockStatementContext.statement() == null || blockStatementContext.statement().IF() == null || (long)blockStatementContext.statement().getText().length() <= this.maxMethodLength) continue;
                if (blockStatementContext.statement().statement(0) != null && blockStatementContext.statement().statement(0).block() != null && blockStatementContext.statement().statement(0).block().blockStatement() != null && blockStatementContext.statement().statement(0).block().blockStatement().size() > 1) {
                    counter = CodeSplitUtil.getCounter().incrementAndGet();
                    methodDef = type + " " + functionName + "_trueFilter" + counter + parameters + methodQualifier;
                    newMethod = methodDef + CodeSplitUtil.getContextString(blockStatementContext.statement().statement(0).block()) + "\n";
                    newMethodCall = functionName + "_trueFilter" + counter + "(" + String.join((CharSequence)", ", declarationContext) + ");\n";
                    this.rewriter.replace(blockStatementContext.statement().statement((int)0).block().start, blockStatementContext.statement().statement((int)0).block().stop, (Object)("{\n" + newMethodCall + "\n}\n"));
                    this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + newMethod + "\n"));
                    ++this.rewriteCount;
                }
                if (blockStatementContext.statement().statement(1) == null || blockStatementContext.statement().statement(1).block() == null || blockStatementContext.statement().statement(1).block().blockStatement() == null || blockStatementContext.statement().statement(1).block().blockStatement().size() <= 1) continue;
                counter = CodeSplitUtil.getCounter().incrementAndGet();
                methodDef = type + " " + functionName + "_falseFilter" + counter + parameters + methodQualifier;
                newMethod = methodDef + CodeSplitUtil.getContextString(blockStatementContext.statement().statement(1).block()) + "\n";
                newMethodCall = functionName + "_falseFilter" + counter + "(" + String.join((CharSequence)", ", declarationContext) + ");\n";
                this.rewriter.replace(blockStatementContext.statement().statement((int)1).block().start, blockStatementContext.statement().statement((int)1).block().stop, (Object)("{\n" + newMethodCall + "\n}\n"));
                this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + newMethod + "\n"));
                ++this.rewriteCount;
            }
            return null;
        }

        private String rewriteAndGetCode() {
            JavaParser javaParser = new JavaParser((TokenStream)this.tokenStream);
            ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            this.visit((ParseTree)javaParser.compilationUnit());
            return this.rewriter.getText();
        }

        private boolean hasRewrite() {
            return this.rewriteCount > 0L;
        }
    }
}

