/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import org.apache.flink.table.codesplit.DeclarationRewriter;
import org.apache.flink.table.codesplit.FunctionSplitter;
import org.apache.flink.table.codesplit.IfStatementRewriter;
import org.apache.flink.table.codesplit.MemberFieldRewriter;
import org.apache.flink.util.Preconditions;

public class JavaCodeSplitter {
    public static final int DEFAULT_MAX_METHOD_LENGTH = 4000;
    public static final int DEFAULT_MAX_CLASS_MEMBER_COUNT = 10000;

    public static String split(String code) {
        return JavaCodeSplitter.split(code, 4000, 10000);
    }

    public static String split(String code, int maxMethodLength, int maxClassMemberCount) {
        Preconditions.checkArgument(code != null && !code.isEmpty(), "code cannot be empty");
        Preconditions.checkArgument(maxMethodLength > 0);
        Preconditions.checkArgument(maxClassMemberCount > 0);
        String declarationRewriteCode = new DeclarationRewriter(code, maxMethodLength).rewrite();
        String ifSplitCode = new IfStatementRewriter(declarationRewriteCode, maxMethodLength).rewrite();
        String functionSplitCode = new FunctionSplitter(ifSplitCode, maxMethodLength).split();
        return new MemberFieldRewriter(functionSplitCode, maxClassMemberCount).rewrite();
    }
}

