/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.util.Preconditions;

public class MemberFieldRewriter {
    private String code;
    private int maxFieldCount;
    private TokenStreamRewriter rewriter;

    public MemberFieldRewriter(String code, int maxFieldCount) {
        this.code = code;
        this.maxFieldCount = maxFieldCount;
    }

    public String rewrite() {
        MemberFieldVisitor fieldVisitor = new MemberFieldVisitor();
        fieldVisitor.visit((ParseTree)this.prepareRewrite().compilationUnit());
        if (fieldVisitor.fieldCount >= this.maxFieldCount) {
            this.code = this.rewriter.getText();
            new MemberFieldReplaceVisitor(fieldVisitor.replaceMap).visit((ParseTree)this.prepareRewrite().compilationUnit());
            return this.rewriter.getText();
        }
        return this.code;
    }

    private JavaParser prepareRewrite() {
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)CharStreams.fromString((String)this.code)));
        this.rewriter = new TokenStreamRewriter((TokenStream)tokenStream);
        JavaParser javaParser = new JavaParser((TokenStream)tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        return javaParser;
    }

    private class MemberFieldReplaceVisitor
    extends JavaParserBaseVisitor<Void> {
        private final Map<String, String> replaceMap;
        private final Set<String> excludedNames;

        MemberFieldReplaceVisitor(Map<String, String> replaceMap) {
            this.replaceMap = replaceMap;
            this.excludedNames = new HashSet<String>();
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext formalParameter : ctx.formalParameters().formalParameterList().formalParameter()) {
                    this.excludedNames.add(formalParameter.variableDeclaratorId().getText());
                }
            }
            this.visitChildren((RuleNode)ctx);
            this.excludedNames.clear();
            return null;
        }

        @Override
        public Void visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext formalParameter : ctx.formalParameters().formalParameterList().formalParameter()) {
                    this.excludedNames.add(formalParameter.variableDeclaratorId().getText());
                }
            }
            this.visitChildren((RuleNode)ctx);
            this.excludedNames.clear();
            return null;
        }

        @Override
        public Void visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            for (JavaParser.VariableDeclaratorContext dec : ctx.variableDeclarators().variableDeclarator()) {
                this.excludedNames.add(dec.variableDeclaratorId().getText());
            }
            return (Void)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Void visitPrimary(JavaParser.PrimaryContext ctx) {
            if (ctx.THIS() != null) {
                ParserRuleContext parent = this.getThisParentContext(ctx);
                if (parent instanceof JavaParser.ExpressionContext) {
                    String rep;
                    JavaParser.ExpressionContext expressionContext = (JavaParser.ExpressionContext)parent;
                    if (expressionContext.bop != null && expressionContext.IDENTIFIER() != null && (rep = this.replaceMap.get(expressionContext.IDENTIFIER().getText())) != null) {
                        MemberFieldRewriter.this.rewriter.replace(expressionContext.IDENTIFIER().getSymbol(), (Object)rep);
                    }
                }
            } else if (ctx.IDENTIFIER() != null) {
                String identifier = ctx.IDENTIFIER().getText();
                if (this.excludedNames.contains(identifier)) {
                    return null;
                }
                String rep = this.replaceMap.get(identifier);
                if (rep != null) {
                    MemberFieldRewriter.this.rewriter.replace(ctx.IDENTIFIER().getSymbol(), (Object)rep);
                }
            } else {
                this.visitChildren((RuleNode)ctx);
            }
            return null;
        }

        private ParserRuleContext getThisParentContext(JavaParser.PrimaryContext ctx) {
            return ctx.getParent().getParent();
        }
    }

    private class MemberFieldVisitor
    extends JavaParserBaseVisitor<Void> {
        private final Stack<StackElement> classStack = new Stack();
        private final Map<String, String> replaceMap = new HashMap<String, String>();
        private final Set<String> varNames = new HashSet<String>();
        private int fieldCount = 0;

        MemberFieldVisitor() {
        }

        @Override
        public Void visitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.classStack.push(new StackElement());
            Void ret = (Void)this.visitChildren((RuleNode)ctx);
            this.rewriteClassDeclaration(ctx);
            this.classStack.pop();
            return ret;
        }

        @Override
        public Void visitMemberDeclaration(JavaParser.MemberDeclarationContext ctx) {
            if (ctx.fieldDeclaration() == null) {
                return null;
            }
            this.checkMemberDeclaration(ctx);
            for (JavaParser.ModifierContext modifier : ((JavaParser.ClassBodyDeclarationContext)ctx.getParent()).modifier()) {
                if (!"static".equals(modifier.getText())) continue;
                return null;
            }
            String fieldName = ctx.fieldDeclaration().variableDeclarators().variableDeclarator(0).variableDeclaratorId().getText();
            String type = ctx.fieldDeclaration().typeType().getText();
            String init = CodeSplitUtil.getContextString(ctx.fieldDeclaration().variableDeclarators().variableDeclarator(0).variableInitializer());
            StackElement classInfo = this.classStack.peek();
            Integer typeCount = classInfo.typeCounts.get(type);
            int id = typeCount == null ? 0 : typeCount;
            classInfo.typeCounts.put(type, id + 1);
            classInfo.fields.add(new MemberField(fieldName, type, id, init));
            MemberFieldRewriter.this.rewriter.delete(ctx.getParent().start, ctx.getParent().stop);
            ++this.fieldCount;
            return null;
        }

        private void rewriteClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            HashMap<String, String> typeFieldNames = new HashMap<String, String>();
            StringBuilder newDeclaration = new StringBuilder("\n");
            for (Map.Entry<String, Integer> typeCount : this.classStack.peek().typeCounts.entrySet()) {
                String type = typeCount.getKey();
                String typeWithoutArgs = type.indexOf(60) == -1 ? type : type.substring(0, type.indexOf(60)) + type.substring(type.lastIndexOf(62) + 1);
                int count = typeCount.getValue();
                String fieldName = CodeSplitUtil.newName("rewrite");
                typeFieldNames.put(type, fieldName);
                StringBuilder newField = new StringBuilder();
                newField.append(type).append("[] ").append(fieldName).append(" = new ");
                int pos = typeWithoutArgs.indexOf("[");
                if (pos == -1) {
                    newField.append(typeWithoutArgs).append("[").append(count).append("]");
                } else {
                    newField.append(typeWithoutArgs, 0, pos).append("[").append(count).append("]").append(typeWithoutArgs, pos, typeWithoutArgs.length());
                }
                newField.append(";\n");
                newDeclaration.append((CharSequence)newField);
            }
            boolean hasInit = false;
            for (MemberField field : this.classStack.peek().fields) {
                String newName = (String)typeFieldNames.get(field.type) + "[" + field.id + "]";
                this.replaceMap.put(field.oldName, newName);
                if (field.init.length() == 0) continue;
                if (!hasInit) {
                    newDeclaration.append("\n{\n");
                    hasInit = true;
                }
                newDeclaration.append(newName).append(" = ").append(field.init).append(";\n");
            }
            if (hasInit) {
                newDeclaration.append("}\n");
            }
            MemberFieldRewriter.this.rewriter.insertAfter(ctx.classBody().start, (Object)newDeclaration.toString());
        }

        private void checkMemberDeclaration(JavaParser.MemberDeclarationContext ctx) {
            if (ctx.fieldDeclaration() == null) {
                return;
            }
            Preconditions.checkArgument(ctx.fieldDeclaration().variableDeclarators().variableDeclarator().size() == 1, "%s\nCodegen rewrite failed. You can only declare one field in one statement.", MemberFieldRewriter.this.code);
            for (JavaParser.VariableDeclaratorContext v : ctx.fieldDeclaration().variableDeclarators().variableDeclarator()) {
                String identifier = v.variableDeclaratorId().getText();
                Preconditions.checkArgument(!this.varNames.contains(identifier), "%s\nCodegen rewrite failed. Field names should not be the same. Name: %s", MemberFieldRewriter.this.code, identifier);
                this.varNames.add(identifier);
            }
        }
    }

    private class StackElement {
        List<MemberField> fields = new ArrayList<MemberField>();
        Map<String, Integer> typeCounts = new HashMap<String, Integer>();

        StackElement() {
        }
    }

    private class MemberField {
        String oldName;
        String type;
        int id;
        String init;

        MemberField(String oldName, String type, int id, String init) {
            this.oldName = oldName;
            this.type = type;
            this.id = id;
            this.init = init;
        }
    }
}

