/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.ObjectArrayRow;

public final class GenericRow
extends ObjectArrayRow {
    public GenericRow(int arity) {
        super(arity);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return (Boolean)this.fields[ordinal];
    }

    @Override
    public byte getByte(int ordinal) {
        return (Byte)this.fields[ordinal];
    }

    @Override
    public short getShort(int ordinal) {
        return (Short)this.fields[ordinal];
    }

    @Override
    public int getInt(int ordinal) {
        return (Integer)this.fields[ordinal];
    }

    @Override
    public long getLong(int ordinal) {
        return (Long)this.fields[ordinal];
    }

    @Override
    public float getFloat(int ordinal) {
        return ((Float)this.fields[ordinal]).floatValue();
    }

    @Override
    public double getDouble(int ordinal) {
        return (Double)this.fields[ordinal];
    }

    @Override
    public char getChar(int ordinal) {
        return ((Character)this.fields[ordinal]).charValue();
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.fields[ordinal] = Float.valueOf(value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.fields[ordinal] = value;
    }

    @Override
    public void setChar(int ordinal, char value) {
        this.fields[ordinal] = Character.valueOf(value);
    }

    public void update(int ordinal, Object value) {
        this.fields[ordinal] = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GenericRow)) {
            return false;
        }
        GenericRow row2 = (GenericRow)o;
        return this.getHeader() == row2.getHeader() && GenericRow.equalObjectArray(this.fields, row2.fields);
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GenericRow)) {
            return false;
        }
        GenericRow row2 = (GenericRow)o;
        return GenericRow.equalObjectArray(this.fields, row2.fields);
    }

    public Object getField(int ordinal) {
        return this.fields[ordinal];
    }

    public static GenericRow of(Object ... values) {
        GenericRow row2 = new GenericRow(values.length);
        for (int i = 0; i < values.length; ++i) {
            row2.update(i, values[i]);
        }
        return row2;
    }

    public static GenericRow wrap(Object o) {
        GenericRow row2 = new GenericRow(1);
        row2.update(0, o);
        return row2;
    }

    public static GenericRow copyReference(GenericRow row2) {
        GenericRow newRow = new GenericRow(row2.fields.length);
        System.arraycopy(row2.fields, 0, newRow.fields, 0, row2.fields.length);
        newRow.setHeader(row2.getHeader());
        return newRow;
    }
}

