/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.util.StringUtils;

public abstract class ObjectArrayRow
implements BaseRow {
    private byte header;
    protected final Object[] fields;

    public ObjectArrayRow(int arity) {
        this.fields = new Object[arity];
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public byte getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(byte header) {
        this.header = header;
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.fields[ordinal] == null;
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        return (byte[])this.fields[ordinal];
    }

    @Override
    public BinaryString getBinaryString(int ordinal) {
        Object value = this.fields[ordinal];
        if (value instanceof BinaryString) {
            return (BinaryString)value;
        }
        return BinaryString.fromString((String)value);
    }

    @Override
    public BinaryString getBinaryString(int ordinal, BinaryString reuse) {
        return this.getBinaryString(ordinal);
    }

    @Override
    public String getString(int ordinal) {
        Object value = this.fields[ordinal];
        if (value instanceof BinaryString) {
            return value.toString();
        }
        return (String)value;
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        Object value = this.fields[ordinal];
        if (value instanceof Decimal) {
            return (Decimal)value;
        }
        return Decimal.fromBigDecimal((BigDecimal)value, precision, scale);
    }

    @Override
    public <T> T getGeneric(int pos, TypeSerializer<T> serializer) {
        return (T)this.fields[pos];
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> type) {
        return (T)this.fields[pos];
    }

    @Override
    public BaseRow getBaseRow(int ordinal, int numFields) {
        return (BaseRow)this.fields[ordinal];
    }

    @Override
    public BaseArray getBaseArray(int ordinal) {
        return (BaseArray)this.fields[ordinal];
    }

    @Override
    public BaseMap getBaseMap(int ordinal) {
        return (BaseMap)this.fields[ordinal];
    }

    @Override
    public void setNullAt(int ordinal) {
        this.fields[ordinal] = null;
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision, int scale) {
        this.fields[ordinal] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader()).append("|");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString(this.fields[i]));
        }
        return sb.toString();
    }

    public int hashCode() {
        return 31 * Byte.hashCode(this.getHeader()) + Arrays.hashCode(this.fields);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ObjectArrayRow) {
            ObjectArrayRow other = (ObjectArrayRow)o;
            return this.header == other.header && Arrays.equals(this.fields, other.fields);
        }
        return false;
    }

    private static boolean equalNonNullField(Object o1, Object o2) {
        if (o1 instanceof String && o2 instanceof BinaryString) {
            return o2.toString().equals(o1);
        }
        if (o2 instanceof String && o1 instanceof BinaryString) {
            return o1.toString().equals(o2);
        }
        return o1.equals(o2);
    }

    static boolean equalObjectArray(Object[] arr1, Object[] arr2) {
        int length = arr1.length;
        if (arr2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = arr1[i];
            Object o2 = arr2[i];
            if (o1 != null ? ObjectArrayRow.equalNonNullField(o1, o2) : o2 == null) continue;
            return false;
        }
        return true;
    }
}

