/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.Types;

public interface TypeGetterSetters {
    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public char getChar(int var1);

    public byte[] getByteArray(int var1);

    public BinaryString getBinaryString(int var1);

    public BinaryString getBinaryString(int var1, BinaryString var2);

    default public String getString(int ordinal) {
        return this.getBinaryString(ordinal).toString();
    }

    public Decimal getDecimal(int var1, int var2, int var3);

    @Deprecated
    public <T> T getGeneric(int var1, TypeSerializer<T> var2);

    public <T> T getGeneric(int var1, GenericType<T> var2);

    public BaseRow getBaseRow(int var1, int var2);

    public BaseArray getBaseArray(int var1);

    public BaseMap getBaseMap(int var1);

    public void setBoolean(int var1, boolean var2);

    public void setByte(int var1, byte var2);

    public void setShort(int var1, short var2);

    public void setInt(int var1, int var2);

    public void setLong(int var1, long var2);

    public void setFloat(int var1, float var2);

    public void setDouble(int var1, double var2);

    public void setChar(int var1, char var2);

    public void setDecimal(int var1, Decimal var2, int var3, int var4);

    public static Object get(TypeGetterSetters row2, int ordinal, InternalType type) {
        if (row2 instanceof GenericRow) {
            return ((GenericRow)row2).getField(ordinal);
        }
        if (type.equals(Types.BOOLEAN)) {
            return row2.getBoolean(ordinal);
        }
        if (type.equals(Types.BYTE)) {
            return row2.getByte(ordinal);
        }
        if (type.equals(Types.SHORT)) {
            return row2.getShort(ordinal);
        }
        if (type.equals(Types.INT)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(Types.LONG)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(Types.FLOAT)) {
            return Float.valueOf(row2.getFloat(ordinal));
        }
        if (type.equals(Types.DOUBLE)) {
            return row2.getDouble(ordinal);
        }
        if (type instanceof DecimalType) {
            DecimalType dt = (DecimalType)type;
            return row2.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (type.equals(Types.STRING)) {
            return row2.getBinaryString(ordinal);
        }
        if (type.equals(Types.CHAR)) {
            return Character.valueOf(row2.getChar(ordinal));
        }
        if (type.equals(Types.ROWTIME_INDICATOR)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(Types.DATE)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(Types.TIME)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(Types.TIMESTAMP)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(Types.BYTE_ARRAY)) {
            return row2.getByteArray(ordinal);
        }
        if (type instanceof ArrayType) {
            return row2.getBaseArray(ordinal);
        }
        if (type instanceof MapType) {
            return row2.getBaseMap(ordinal);
        }
        if (type instanceof RowType) {
            return row2.getBaseRow(ordinal, ((RowType)type).getArity());
        }
        if (type instanceof GenericType) {
            return row2.getGeneric(ordinal, (GenericType)type);
        }
        throw new RuntimeException("Not support type: " + type);
    }
}

