/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.util;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.BigDecimalTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.NestedRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.typeutils.BaseArraySerializer;
import org.apache.flink.table.typeutils.BaseMapSerializer;
import org.apache.flink.table.typeutils.BaseRowSerializer;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TypeUtils;
import org.apache.flink.util.Preconditions;

public final class BaseRowUtil {
    public static final byte ACCUMULATE_MSG = 0;
    public static final byte RETRACT_MSG = 1;

    public static boolean isAccumulateMsg(BaseRow baseRow) {
        return baseRow.getHeader() == 0;
    }

    public static boolean isRetractMsg(BaseRow baseRow) {
        return baseRow.getHeader() == 1;
    }

    public static BaseRow setAccumulate(BaseRow baseRow) {
        baseRow.setHeader((byte)0);
        return baseRow;
    }

    public static BaseRow setRetract(BaseRow baseRow) {
        baseRow.setHeader((byte)1);
        return baseRow;
    }

    public static GenericRow toGenericRow(BaseRow baseRow, TypeInformation[] typeInfos, TypeSerializer[] typeSerializers) {
        if (baseRow instanceof GenericRow) {
            return (GenericRow)baseRow;
        }
        GenericRow row2 = new GenericRow(baseRow.getArity());
        row2.setHeader(baseRow.getHeader());
        for (int i = 0; i < row2.getArity(); ++i) {
            if (baseRow.isNullAt(i)) {
                row2.update(i, null);
                continue;
            }
            row2.update(i, BaseRowUtil.get(baseRow, i, typeInfos[i], typeSerializers[i]));
        }
        return row2;
    }

    public static GenericRow toGenericRow(BaseRow baseRow, InternalType[] types) {
        if (baseRow instanceof GenericRow) {
            return (GenericRow)baseRow;
        }
        GenericRow row2 = new GenericRow(baseRow.getArity());
        row2.setHeader(baseRow.getHeader());
        for (int i = 0; i < row2.getArity(); ++i) {
            if (baseRow.isNullAt(i)) {
                row2.update(i, null);
                continue;
            }
            row2.update(i, TypeGetterSetters.get(baseRow, i, types[i]));
        }
        return row2;
    }

    public static Object get(BaseRow row2, int ordinal, TypeInformation type, TypeSerializer serializer) {
        if (row2 instanceof GenericRow) {
            return ((GenericRow)row2).getField(ordinal);
        }
        if (type.equals(Types.BOOLEAN)) {
            return row2.getBoolean(ordinal);
        }
        if (type.equals(Types.BYTE)) {
            return row2.getByte(ordinal);
        }
        if (type.equals(Types.SHORT)) {
            return row2.getShort(ordinal);
        }
        if (type.equals(Types.INT)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(Types.LONG)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(Types.FLOAT)) {
            return Float.valueOf(row2.getFloat(ordinal));
        }
        if (type.equals(Types.DOUBLE)) {
            return row2.getDouble(ordinal);
        }
        if (type instanceof BigDecimalTypeInfo) {
            BigDecimalTypeInfo dt = (BigDecimalTypeInfo)type;
            return row2.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (type.equals(Types.STRING)) {
            return row2.getBinaryString(ordinal);
        }
        if (type.equals(BasicTypeInfo.CHAR_TYPE_INFO)) {
            return Character.valueOf(row2.getChar(ordinal));
        }
        if (type.equals(TimeIndicatorTypeInfo.ROWTIME_INDICATOR())) {
            return row2.getLong(ordinal);
        }
        if (type.equals(SqlTimeTypeInfo.DATE)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(SqlTimeTypeInfo.TIME)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(SqlTimeTypeInfo.TIMESTAMP)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO)) {
            return row2.getByteArray(ordinal);
        }
        if (TypeUtils.isInternalArrayType(type)) {
            return row2.getBaseArray(ordinal);
        }
        if (type instanceof MapTypeInfo) {
            return row2.getBaseMap(ordinal);
        }
        if (TypeUtils.isInternalCompositeType(type)) {
            return row2.getBaseRow(ordinal, type.getArity());
        }
        return row2.getGeneric(ordinal, serializer);
    }

    public static Object get(BaseRow row2, int ordinal, DataType type) {
        if (row2 instanceof GenericRow) {
            return ((GenericRow)row2).getField(ordinal);
        }
        if (type.equals(DataTypes.BOOLEAN)) {
            return row2.getBoolean(ordinal);
        }
        if (type.equals(DataTypes.BYTE)) {
            return row2.getByte(ordinal);
        }
        if (type.equals(DataTypes.SHORT)) {
            return row2.getShort(ordinal);
        }
        if (type.equals(DataTypes.INT)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(DataTypes.LONG)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(DataTypes.FLOAT)) {
            return Float.valueOf(row2.getFloat(ordinal));
        }
        if (type.equals(DataTypes.DOUBLE)) {
            return row2.getDouble(ordinal);
        }
        if (type instanceof DecimalType) {
            DecimalType dt = (DecimalType)type;
            return row2.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (type.equals(DataTypes.STRING)) {
            return row2.getBinaryString(ordinal);
        }
        if (type.equals(DataTypes.CHAR)) {
            return Character.valueOf(row2.getChar(ordinal));
        }
        if (type.equals(DataTypes.ROWTIME_INDICATOR)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(DataTypes.DATE)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(DataTypes.TIME)) {
            return row2.getInt(ordinal);
        }
        if (type.equals(DataTypes.TIMESTAMP)) {
            return row2.getLong(ordinal);
        }
        if (type.equals(DataTypes.BYTE_ARRAY)) {
            return row2.getByteArray(ordinal);
        }
        if (type instanceof ArrayType) {
            return row2.getBaseArray(ordinal);
        }
        if (type instanceof MapType) {
            return row2.getBaseMap(ordinal);
        }
        if (type instanceof RowType) {
            return row2.getBaseRow(ordinal, ((RowType)type).getArity());
        }
        if (type instanceof GenericType) {
            return row2.getGeneric(ordinal, (GenericType)type);
        }
        if (type instanceof TypeInfoWrappedDataType) {
            return TypeGetterSetters.get(row2, ordinal, type.toInternalType());
        }
        throw new RuntimeException("Not support type: " + type);
    }

    public static String toOriginString(BaseRow row2, TypeInformation[] types, TypeSerializer[] serializers) {
        Preconditions.checkArgument(types.length == row2.getArity());
        StringBuilder build2 = new StringBuilder("[");
        build2.append(row2.getHeader());
        for (int i = 0; i < row2.getArity(); ++i) {
            build2.append(',');
            if (row2.isNullAt(i)) {
                build2.append("null");
                continue;
            }
            TypeSerializer serializer = serializers != null ? serializers[i] : null;
            build2.append(BaseRowUtil.get(row2, i, types[i], serializer));
        }
        build2.append(']');
        return build2.toString();
    }

    public static void write(BinaryWriter writer, int pos, Object o, InternalType type, TypeSerializer serializer) {
        if (type.equals(DataTypes.BOOLEAN)) {
            writer.writeBoolean(pos, (Boolean)o);
        } else if (type.equals(DataTypes.BYTE)) {
            writer.writeByte(pos, (Byte)o);
        } else if (type.equals(DataTypes.SHORT)) {
            writer.writeShort(pos, (Short)o);
        } else if (type.equals(DataTypes.INT)) {
            writer.writeInt(pos, (Integer)o);
        } else if (type.equals(DataTypes.LONG)) {
            writer.writeLong(pos, (Long)o);
        } else if (type.equals(DataTypes.FLOAT)) {
            writer.writeFloat(pos, ((Float)o).floatValue());
        } else if (type.equals(DataTypes.DOUBLE)) {
            writer.writeDouble(pos, (Double)o);
        } else if (type.equals(DataTypes.STRING)) {
            writer.writeBinaryString(pos, (BinaryString)o);
        } else if (type.equals(DataTypes.CHAR)) {
            writer.writeChar(pos, ((Character)o).charValue());
        } else if (type instanceof DecimalType) {
            DecimalType t = (DecimalType)type;
            writer.writeDecimal(pos, (Decimal)o, t.precision(), t.scale());
        } else if (type instanceof DateType) {
            writer.writeInt(pos, (Integer)o);
        } else if (type.equals(DataTypes.TIME)) {
            writer.writeInt(pos, (Integer)o);
        } else if (type instanceof TimestampType) {
            writer.writeLong(pos, (Long)o);
        } else if (type.equals(DataTypes.BYTE_ARRAY)) {
            writer.writeByteArray(pos, (byte[])o);
        } else if (type instanceof ArrayType) {
            BaseRowUtil.writeBaseArray(writer, pos, (BaseArray)o, (BaseArraySerializer)serializer);
        } else if (type instanceof MapType) {
            BaseRowUtil.writeBaseMap(writer, pos, (BaseMap)o, (BaseMapSerializer)serializer);
        } else if (type instanceof RowType) {
            BaseRowUtil.writeBaseRow(writer, pos, (BaseRow)o, (BaseRowSerializer)serializer);
        } else {
            writer.writeGeneric(pos, o, (GenericType)type);
        }
    }

    public static void writeBaseArray(BinaryWriter writer, int pos, BaseArray input, BaseArraySerializer serializer) {
        BinaryArray binaryArray = input instanceof BinaryArray ? (BinaryArray)input : serializer.baseArrayToBinary(input);
        writer.writeBinaryArray(pos, binaryArray);
    }

    public static void writeBaseMap(BinaryWriter writer, int pos, BaseMap input, BaseMapSerializer serializer) {
        BinaryMap binaryMap = input instanceof BinaryMap ? (BinaryMap)input : serializer.baseMapToBinary(input);
        writer.writeBinaryMap(pos, binaryMap);
    }

    public static void writeBaseRow(BinaryWriter writer, int pos, BaseRow input, BaseRowSerializer serializer) {
        if (input instanceof BinaryRow) {
            BinaryRow row2 = (BinaryRow)input;
            writer.writeSegments(pos, row2.getAllSegments(), row2.getBaseOffset(), row2.getSizeInBytes());
        } else if (input instanceof NestedRow) {
            NestedRow row3 = (NestedRow)input;
            writer.writeNestedRow(pos, row3);
        } else {
            try {
                BinaryRow row4 = serializer.baseRowToBinary(input);
                writer.writeBinaryRow(pos, row4);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

