/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class BytesColumnVector
extends ColumnVector {
    private static final long serialVersionUID = -8529155738773478597L;
    public int[] start;
    public int[] length;
    public byte[] buffer;
    private int elementsAppended = 0;
    private int capacity;

    public BytesColumnVector(int size) {
        super(size);
        this.capacity = size;
        this.buffer = new byte[this.capacity];
        this.start = new int[size];
        this.length = new int[size];
    }

    @Override
    public void reset() {
        super.reset();
        this.elementsAppended = 0;
    }

    @Override
    public Object get(int index) {
        return this.buffer;
    }

    public int bufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length;
    }

    public void setVal(int elementNum, byte[] sourceBuf, int start, int length) {
        this.reserve(this.elementsAppended + length);
        System.arraycopy(sourceBuf, start, this.buffer, this.elementsAppended, length);
        this.start[elementNum] = this.elementsAppended;
        this.length[elementNum] = length;
        this.elementsAppended += length;
    }

    public void setVal(int elementNum, byte[] sourceBuf) {
        this.setVal(elementNum, sourceBuf, 0, sourceBuf.length);
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((BytesColumnVector)output2).setVal(i, this.buffer, this.start[i], this.length[i]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                ((BytesColumnVector)output2).setVal(i, this.buffer, this.start[i], this.length[i]);
            }
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            BytesColumnVector in = (BytesColumnVector)inputVector;
            this.setVal(outElementNum, in.buffer, in.start[inputElementNum], in.length[inputElementNum]);
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    private void reserve(int requiredCapacity) {
        if (requiredCapacity > this.capacity) {
            int newCapacity = requiredCapacity * 2;
            try {
                byte[] newData = new byte[newCapacity];
                System.arraycopy(this.buffer, 0, newData, 0, this.elementsAppended);
                this.buffer = newData;
                this.capacity = newCapacity;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new UnsupportedOperationException(requiredCapacity + " cannot be satisfied.", outOfMemoryError);
            }
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        BytesColumnVector other = (BytesColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.start = this.start;
        other.length = this.length;
        other.buffer = this.buffer;
    }

    public String toString(int row2) {
        if (this.noNulls || !this.isNull[row2]) {
            return new String(this.buffer, this.start[row2], this.length[row2]);
        }
        return null;
    }
}

