/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class FloatColumnVector
extends ColumnVector {
    private static final long serialVersionUID = 8928878923550041110L;
    public float[] vector;

    public FloatColumnVector(int len) {
        super(len);
        this.vector = new float[len];
    }

    @Override
    public Object get(int index) {
        return Float.valueOf(this.vector[index]);
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((FloatColumnVector)output2).vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, ((FloatColumnVector)output2).vector, 0, size);
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((FloatColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        FloatColumnVector other = (FloatColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

